/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.CollectionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtils {
    public static <T extends Resource> List<T> maximalLowerElements(Collection<T> resources, Property rel, boolean inverse) {
        return ResourceUtils.maximalLowerElements(resources.iterator(), rel, inverse);
    }

    public static <T extends Resource> List<T> maximalLowerElements(Iterator<T> resources, Property rel, boolean inverse) {
        ArrayList<T> in = new ArrayList<T>();
        ArrayList out = new ArrayList();
        ArrayList<Resource> drop = new ArrayList<Resource>();
        while (resources.hasNext()) {
            in.add(resources.next());
        }
        while (!in.isEmpty()) {
            Resource r = (Resource)in.remove(0);
            boolean rCovered = ResourceUtils.testResourceCovered(in, rel, inverse, r) || ResourceUtils.testResourceCovered(out, rel, inverse, r) || ResourceUtils.testResourceCovered(drop, rel, inverse, r);
            (rCovered ? drop : out).add(r);
        }
        return out;
    }

    private static boolean testResourceCovered(List<? extends Resource> l, Property rel, boolean inverse, Resource r) {
        boolean rCovered = false;
        Iterator<? extends Resource> i = l.iterator();
        while (!rCovered && i.hasNext()) {
            Resource next = i.next();
            rCovered = inverse ? r.hasProperty(rel, next) : next.hasProperty(rel, r);
        }
        return rCovered;
    }

    public static <T extends Resource> List<T> removeEquiv(List<T> l, Property p, Resource ref) {
        ArrayList<Resource> equiv = new ArrayList<Resource>();
        for (Resource r : l) {
            if (!r.hasProperty(p, ref) || !ref.hasProperty(p, r)) continue;
            equiv.add(r);
        }
        l.removeAll(equiv);
        return equiv;
    }

    public static <T extends Resource> List<List<T>> partition(List<T> l, Property p) {
        ArrayList<T> source = new ArrayList<T>();
        source.addAll(l);
        ArrayList<List<T>> parts = new ArrayList<List<T>>();
        while (!source.isEmpty()) {
            Resource seed = (Resource)source.remove(0);
            List<Resource> part = ResourceUtils.removeEquiv(source, p, seed);
            part.add(seed);
            parts.add(part);
        }
        return parts;
    }

    public static Resource renameResource(Resource old, String uri) {
        Model m = old.getModel();
        ArrayList stmts = new ArrayList();
        StmtIterator i = old.listProperties();
        while (i.hasNext()) {
            stmts.add(i.next());
        }
        i = m.listStatements(null, null, old);
        while (i.hasNext()) {
            stmts.add(i.next());
        }
        Resource res = uri == null ? m.createResource() : m.createResource(uri);
        for (Statement s : stmts) {
            s.remove();
            Resource subj = ((Object)s.getSubject()).equals(old) ? res : s.getSubject();
            RDFNode obj = s.getObject().equals(old) ? res : s.getObject();
            m.add(subj, s.getPredicate(), obj);
        }
        return res;
    }

    public static Model reachableClosure(Resource root) {
        Model m = ModelFactory.createDefaultModel();
        Set seen = CollectionFactory.createHashedSet();
        LinkedList<RDFNode> queue = new LinkedList<RDFNode>();
        queue.add(root);
        while (!queue.isEmpty()) {
            Resource r = (Resource)queue.remove(0);
            if (seen.contains(r)) continue;
            seen.add(r);
            StmtIterator i = r.listProperties();
            while (i.hasNext()) {
                Statement s = i.nextStatement();
                m.add(s);
                if (!(s.getObject() instanceof Resource)) continue;
                queue.add(s.getObject());
            }
        }
        return m;
    }
}

