/*
 * Decompiled with CFR 0.152.
 */
package ambit2.smarts;

import ambit2.base.exceptions.AmbitException;
import ambit2.base.processors.DefaultAmbitProcessor;
import ambit2.smarts.AliphaticSymbolQueryAtom;
import ambit2.smarts.AromaticSymbolQueryAtom;
import ambit2.smarts.DoubleBondAromaticityNotSpecified;
import ambit2.smarts.DoubleNonAromaticBond;
import ambit2.smarts.SingleNonAromaticBond;
import ambit2.smarts.SingleOrAromaticBond;
import ambit2.smarts.SmartsAtomExpression;
import ambit2.smarts.SmartsBondExpression;
import ambit2.smarts.SmartsConst;
import ambit2.smarts.SmartsExpressionToken;
import ambit2.smarts.SmartsHelper;
import java.util.Vector;
import org.openscience.cdk.Bond;
import org.openscience.cdk.RingSet;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.smarts.AromaticQueryBond;
import org.openscience.cdk.isomorphism.matchers.smarts.OrderQueryBond;
import org.openscience.cdk.ringsearch.SSSRFinder;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

public class SmartsToChemObject
extends DefaultAmbitProcessor<QueryAtomContainer, IAtomContainer> {
    private static final long serialVersionUID = -5893878673124511317L;
    public static final String markProperty = "MARKED_AB";
    public boolean forceAromaticBondsAlways = false;
    public boolean forceAromaticBondsForNonRingAtoms = true;
    boolean mFlagConfirmAromaticBond;
    int mSubAtomType;
    int mSubAromaticity;
    int mCurSubArom;
    int mRecCurSubArom;
    int mSubAtomCharge;
    int mCurSubAtCharge;
    int mSubBondType;
    int mSubBoAromaticity;
    int mCurSubBoArom;
    protected IChemObjectBuilder builder;

    public IChemObjectBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(IChemObjectBuilder builder) {
        this.builder = builder;
    }

    public SmartsToChemObject(IChemObjectBuilder builder) {
        this.setBuilder(builder);
    }

    public IAtomContainer extractAtomContainer(QueryAtomContainer query, IRingSet ringSet) {
        int i;
        if (query == null) {
            return null;
        }
        Vector<IAtom> atoms = new Vector<IAtom>();
        for (int i2 = 0; i2 < query.getAtomCount(); ++i2) {
            atoms.add(this.toAtom(query.getAtom(i2)));
        }
        IMolecule container = (IMolecule)this.builder.newInstance(IMolecule.class, new Object[0]);
        for (i = 0; i < atoms.size(); ++i) {
            IAtom a = (IAtom)atoms.get(i);
            if (a == null) continue;
            container.addAtom(a);
        }
        for (i = 0; i < query.getBondCount(); ++i) {
            this.mFlagConfirmAromaticBond = false;
            IBond b = this.toBond(query.getBond(i));
            if (b == null) continue;
            IAtom[] ats = new IAtom[2];
            int atNum = query.getAtomNumber(query.getBond(i).getAtom(0));
            ats[0] = (IAtom)atoms.get(atNum);
            if (ats[0] == null) continue;
            atNum = query.getAtomNumber(query.getBond(i).getAtom(1));
            ats[1] = (IAtom)atoms.get(atNum);
            if (ats[1] == null) continue;
            b.setAtoms(ats);
            if (this.mFlagConfirmAromaticBond && ats[0].getFlag(5) && ats[1].getFlag(5)) {
                if (this.forceAromaticBondsAlways) {
                    b.setFlag(5, true);
                } else if (ringSet == null) {
                    if (this.forceAromaticBondsForNonRingAtoms) {
                        b.setFlag(5, true);
                    }
                } else if (this.isRingBond(query.getBond(i), ringSet)) {
                    b.setFlag(5, true);
                }
            }
            container.addBond(b);
        }
        return container;
    }

    public IAtomContainer extractAtomContainerFullyConnected(QueryAtomContainer query, IRingSet ringSet) {
        int i;
        if (query == null) {
            return null;
        }
        Vector<IAtom> atoms = new Vector<IAtom>();
        for (int i2 = 0; i2 < query.getAtomCount(); ++i2) {
            IAtom a = this.toAtom(query.getAtom(i2));
            if (a == null) {
                a = this.getMarkedAtom();
            }
            atoms.add(a);
        }
        IMolecule container = (IMolecule)this.builder.newInstance(IMolecule.class, new Object[0]);
        for (i = 0; i < atoms.size(); ++i) {
            IAtom a = (IAtom)atoms.get(i);
            container.addAtom(a);
        }
        for (i = 0; i < query.getBondCount(); ++i) {
            this.mFlagConfirmAromaticBond = false;
            IBond b = this.toBond(query.getBond(i));
            IAtom[] ats = new IAtom[2];
            int atNum = query.getAtomNumber(query.getBond(i).getAtom(0));
            ats[0] = (IAtom)atoms.get(atNum);
            atNum = query.getAtomNumber(query.getBond(i).getAtom(1));
            ats[1] = (IAtom)atoms.get(atNum);
            if (b != null) {
                b.setAtoms(ats);
                if (this.mFlagConfirmAromaticBond && ats[0].getFlag(5) && ats[1].getFlag(5)) {
                    if (this.forceAromaticBondsAlways) {
                        b.setFlag(5, true);
                    } else if (ringSet == null) {
                        if (this.forceAromaticBondsForNonRingAtoms) {
                            b.setFlag(5, true);
                        }
                    } else if (this.isRingBond(query.getBond(i), ringSet)) {
                        b.setFlag(5, true);
                    }
                }
                container.addBond(b);
                continue;
            }
            b = this.getMarkedBond();
            b.setAtoms(ats);
            container.addBond(b);
        }
        return container;
    }

    public QueryAtomContainer convertKekuleSmartsToAromatic(QueryAtomContainer query, IRingSet ringSet) throws Exception {
        Vector<IRingSet> rs = this.getMaxCondensedRingSystems(ringSet);
        if (rs.size() == 0) {
            return query;
        }
        for (int i = 0; i < rs.size(); ++i) {
            QueryAtomContainer qac = this.getCondensedFragmentFromRingSets(query, rs.get(i));
            IAtomContainer container = this.condensedFragmentToContainer(qac);
            if (container != null) {
                String smiles = SmartsHelper.moleculeToSMILES(container);
                System.out.print("condensed: " + smiles);
            } else {
                System.out.println("condensed: null");
            }
            IAtomContainer ac = this.extractAtomContainerFullyConnected(qac, ringSet);
            String smiles = SmartsHelper.moleculeToSMILES(ac);
            System.out.print("extract: " + smiles);
        }
        return null;
    }

    public IAtomContainer process(QueryAtomContainer target) throws AmbitException {
        return this.extractAtomContainer(target);
    }

    public IAtomContainer extractAtomContainer(QueryAtomContainer query) {
        SSSRFinder sssrf = new SSSRFinder((IAtomContainer)query);
        IRingSet ringSet = sssrf.findSSSR();
        return this.extractAtomContainer(query, ringSet);
    }

    public IAtomContainer extractAtomContainerFullyConnected(QueryAtomContainer query) {
        SSSRFinder sssrf = new SSSRFinder((IAtomContainer)query);
        IRingSet ringSet = sssrf.findSSSR();
        return this.extractAtomContainerFullyConnected(query, ringSet);
    }

    public QueryAtomContainer convertKekuleSmartsToAromatic(QueryAtomContainer query) throws Exception {
        SSSRFinder sssrf = new SSSRFinder((IAtomContainer)query);
        IRingSet ringSet = sssrf.findSSSR();
        return this.convertKekuleSmartsToAromatic(query, ringSet);
    }

    public IAtom toAtom(IAtom a) {
        if (a instanceof AliphaticSymbolQueryAtom) {
            IAtom atom = (IAtom)this.builder.newInstance(IAtom.class, new Object[0]);
            atom.setSymbol(a.getSymbol());
            atom.setFlag(5, false);
            return atom;
        }
        if (a instanceof AromaticSymbolQueryAtom) {
            IAtom atom = (IAtom)this.builder.newInstance(IAtom.class, new Object[0]);
            atom.setSymbol(a.getSymbol());
            atom.setFlag(5, true);
            return atom;
        }
        if (a instanceof SmartsAtomExpression) {
            return this.smartsExpressionToAtom((SmartsAtomExpression)a);
        }
        return null;
    }

    public IAtom smartsExpressionToAtom(SmartsAtomExpression a) {
        int atomCharge = 0;
        Vector<SmartsAtomExpression> subs = this.getSubExpressions(a, 1003);
        int atType = -1;
        int isArom = -1;
        for (int i = 0; i < subs.size(); ++i) {
            this.analyzeSubExpressionsFromLowAnd(a, subs.get(i));
            if (this.mSubAtomType != -1) {
                if (atType == -1) {
                    atType = this.mSubAtomType;
                } else if (atType != this.mSubAtomType) {
                    atType = -1;
                    break;
                }
            }
            if (this.mSubAromaticity != -1) {
                if (isArom == -1) {
                    isArom = this.mSubAromaticity;
                } else if (isArom != this.mSubAromaticity) {
                    isArom = -1;
                    break;
                }
            }
            if (this.mSubAtomCharge == 0) continue;
            atomCharge = this.mSubAtomCharge;
        }
        if (atType != -1) {
            IAtom atom = (IAtom)SilentChemObjectBuilder.getInstance().newInstance(IAtom.class, new Object[0]);
            atom.setSymbol(PeriodicTable.getSymbol((int)atType));
            if (isArom != -1) {
                if (isArom == 1) {
                    atom.setFlag(5, true);
                } else {
                    atom.setFlag(5, false);
                }
            }
            if (atomCharge != 0) {
                atom.setFormalCharge(new Integer(atomCharge));
            }
            return atom;
        }
        return null;
    }

    public Vector<SmartsAtomExpression> getSubExpressions(SmartsAtomExpression a, int separator) {
        Vector<SmartsAtomExpression> v = new Vector<SmartsAtomExpression>();
        SmartsAtomExpression sub = new SmartsAtomExpression();
        for (int i = 0; i < a.tokens.size(); ++i) {
            if (a.tokens.get((int)i).type == separator) {
                v.add(sub);
                sub = new SmartsAtomExpression();
                continue;
            }
            sub.tokens.add(a.tokens.get(i));
        }
        v.add(sub);
        return v;
    }

    public void analyzeSubExpressionsFromLowAnd(SmartsAtomExpression atExp, SmartsAtomExpression sub) {
        int i;
        Vector<SmartsAtomExpression> sub_subs = this.getSubExpressions(sub, 1002);
        int[] subAtType = new int[sub_subs.size()];
        int[] subArom = new int[sub_subs.size()];
        int[] subCharge = new int[sub_subs.size()];
        for (i = 0; i < sub_subs.size(); ++i) {
            subAtType[i] = this.getExpressionAtomType(atExp, sub_subs.get(i));
            subArom[i] = this.mCurSubArom;
            subCharge[i] = this.mCurSubAtCharge;
        }
        this.mSubAtomType = subAtType[0];
        for (i = 1; i < subAtType.length; ++i) {
            if (this.mSubAtomType == subAtType[i]) continue;
            this.mSubAtomType = -1;
            break;
        }
        this.mSubAromaticity = subArom[0];
        for (i = 1; i < subAtType.length; ++i) {
            if (this.mSubAromaticity == subArom[i]) continue;
            this.mSubAromaticity = -1;
            break;
        }
        this.mSubAtomCharge = subCharge[0];
        for (i = 1; i < subCharge.length; ++i) {
            if (this.mSubAtomCharge == subCharge[i]) continue;
            this.mSubAtomCharge = 0;
            break;
        }
    }

    public int getExpressionAtomType(SmartsAtomExpression atExp, SmartsAtomExpression sub) {
        this.mCurSubArom = -1;
        this.mCurSubAtCharge = 0;
        int[] pos = new int[sub.tokens.size() + 2];
        pos[0] = -1;
        int n = 0;
        for (int i = 0; i < sub.tokens.size(); ++i) {
            if (sub.tokens.get((int)i).type != 1001) continue;
            pos[++n] = i;
        }
        pos[++n] = sub.tokens.size();
        int expAtType = -1;
        for (int i = 1; i <= n; ++i) {
            boolean FlagNot = false;
            block9: for (int k = pos[i - 1] + 1; k < pos[i]; ++k) {
                SmartsExpressionToken seTok = sub.tokens.get(k);
                if (seTok.isLogicalOperation()) {
                    if (seTok.getLogOperation() == 0) {
                        boolean bl = FlagNot = !FlagNot;
                    }
                    if (seTok.getLogOperation() != 1) continue;
                    FlagNot = false;
                    continue;
                }
                switch (seTok.type) {
                    case 1: {
                        if (seTok.param <= 0 || FlagNot) continue block9;
                        expAtType = seTok.param;
                        this.mCurSubArom = 1;
                        continue block9;
                    }
                    case 2: {
                        if (seTok.param <= 0 || FlagNot) continue block9;
                        expAtType = seTok.param;
                        this.mCurSubArom = 0;
                        continue block9;
                    }
                    case 11: {
                        if (seTok.param <= 0 || FlagNot) continue block9;
                        expAtType = seTok.param;
                        continue block9;
                    }
                    case 10: {
                        if (FlagNot) continue block9;
                        this.mCurSubAtCharge = seTok.param;
                        continue block9;
                    }
                    case 14: {
                        int recExpAtType = this.getRecursiveExpressionAtomType(atExp, seTok.param);
                        if (recExpAtType <= 0 || FlagNot) continue block9;
                        expAtType = recExpAtType;
                        this.mCurSubArom = this.mRecCurSubArom;
                    }
                }
            }
        }
        return expAtType;
    }

    public int getRecursiveExpressionAtomType(SmartsAtomExpression atExp, int n) {
        int mSubAtomType_old = this.mSubAtomType;
        int mSubAromaticity_old = this.mSubAromaticity;
        int mCurSubArom_old = this.mCurSubArom;
        IAtom a0 = atExp.recSmartsContainers.get(n).getAtom(0);
        IAtom anew = this.toAtom(a0);
        this.mRecCurSubArom = a0.getFlag(5) ? 1 : 0;
        this.mSubAtomType = mSubAtomType_old;
        this.mSubAromaticity = mSubAromaticity_old;
        this.mCurSubArom = mCurSubArom_old;
        if (anew == null) {
            return -1;
        }
        return SmartsConst.getElementNumber(anew.getSymbol());
    }

    public IBond toBond(IBond b) {
        if (b instanceof SmartsBondExpression) {
            return this.smartsExpressionToBond((SmartsBondExpression)b);
        }
        if (b instanceof SingleOrAromaticBond) {
            Bond bond = new Bond();
            bond.setOrder(IBond.Order.SINGLE);
            this.mFlagConfirmAromaticBond = true;
            return bond;
        }
        if (b instanceof AromaticQueryBond) {
            Bond bond = new Bond();
            bond.setOrder(b.getOrder());
            bond.setFlag(5, true);
            return bond;
        }
        if (b instanceof OrderQueryBond) {
            Bond bond = new Bond();
            bond.setOrder(b.getOrder());
            return bond;
        }
        if (b instanceof SingleNonAromaticBond) {
            Bond bond = new Bond();
            bond.setOrder(IBond.Order.SINGLE);
            return bond;
        }
        if (b instanceof DoubleNonAromaticBond) {
            Bond bond = new Bond();
            bond.setOrder(IBond.Order.DOUBLE);
            return bond;
        }
        if (b instanceof DoubleBondAromaticityNotSpecified) {
            Bond bond = new Bond();
            bond.setOrder(IBond.Order.DOUBLE);
            return bond;
        }
        return null;
    }

    public IBond smartsExpressionToBond(SmartsBondExpression b) {
        Vector<SmartsBondExpression> subs = this.getSubExpressions(b, 1003);
        int boType = -1;
        int isArom = -1;
        boolean FlagAromCorrect = true;
        for (int i = 0; i < subs.size(); ++i) {
            this.analyzeSubExpressionsFromLowAnd(b, subs.get(i));
            System.out.print("  sub-expression " + subs.get(i).toString());
            System.out.println("    mSubBondType = " + this.mSubBondType + "  mSubBoAromaticity = " + this.mSubBoAromaticity);
            if (this.mSubBondType != -1) {
                if (boType == -1) {
                    boType = this.mSubBondType;
                } else if (boType != this.mSubBondType) {
                    boType = -1;
                    break;
                }
            }
            if (!FlagAromCorrect || this.mSubBoAromaticity == -1) continue;
            if (isArom == -1) {
                isArom = this.mSubBoAromaticity;
                continue;
            }
            if (isArom == this.mSubBoAromaticity) continue;
            isArom = -1;
            FlagAromCorrect = false;
        }
        System.out.println("boType = " + boType);
        if (boType != -1) {
            IBond bond = (IBond)SilentChemObjectBuilder.getInstance().newInstance(IBond.class, new Object[0]);
            switch (boType) {
                case 1: {
                    bond.setOrder(IBond.Order.SINGLE);
                    break;
                }
                case 2: {
                    bond.setOrder(IBond.Order.DOUBLE);
                    break;
                }
                case 3: {
                    bond.setOrder(IBond.Order.TRIPLE);
                }
            }
            if (FlagAromCorrect && isArom != -1) {
                if (isArom == 1) {
                    bond.setFlag(5, true);
                } else {
                    bond.setFlag(5, false);
                }
            }
            return bond;
        }
        return null;
    }

    public Vector<SmartsBondExpression> getSubExpressions(SmartsBondExpression b, int separator) {
        Vector<SmartsBondExpression> v = new Vector<SmartsBondExpression>();
        SmartsBondExpression sub = new SmartsBondExpression();
        for (int i = 0; i < b.tokens.size(); ++i) {
            if (b.tokens.get(i) == separator) {
                v.add(sub);
                sub = new SmartsBondExpression();
                continue;
            }
            sub.tokens.add(b.tokens.get(i));
        }
        v.add(sub);
        return v;
    }

    public void analyzeSubExpressionsFromLowAnd(SmartsBondExpression boExp, SmartsBondExpression sub) {
        int i;
        Vector<SmartsBondExpression> sub_subs = this.getSubExpressions(sub, 1002);
        int[] subBoType = new int[sub_subs.size()];
        int[] subArom = new int[sub_subs.size()];
        for (i = 0; i < sub_subs.size(); ++i) {
            subBoType[i] = this.getExpressionBondType(boExp, sub_subs.get(i));
            subArom[i] = this.mCurSubArom;
        }
        this.mSubBondType = subBoType[0];
        for (i = 1; i < subBoType.length; ++i) {
            if (this.mSubBondType == subBoType[i]) continue;
            this.mSubBondType = -1;
            break;
        }
        this.mSubBoAromaticity = subArom[0];
        for (i = 1; i < subBoType.length; ++i) {
            if (this.mSubAromaticity == subArom[i]) continue;
            this.mSubAromaticity = -1;
            break;
        }
    }

    public int getExpressionBondType(SmartsBondExpression boExp, SmartsBondExpression sub) {
        this.mCurSubBoArom = -1;
        int[] pos = new int[sub.tokens.size() + 2];
        pos[0] = -1;
        int n = 0;
        for (int i = 0; i < sub.tokens.size(); ++i) {
            if (sub.tokens.get(i) != 1001) continue;
            pos[++n] = i;
        }
        pos[++n] = sub.tokens.size();
        int expBoType = -1;
        for (int i = 1; i <= n; ++i) {
            boolean FlagNot = false;
            block11: for (int k = pos[i - 1] + 1; k < pos[i]; ++k) {
                int seTok = sub.tokens.get(k);
                if (seTok >= 1000) {
                    if (seTok == 1000) {
                        boolean bl = FlagNot = !FlagNot;
                    }
                    if (seTok != 1001) continue;
                    FlagNot = false;
                    continue;
                }
                switch (seTok) {
                    case 0: {
                        continue block11;
                    }
                    case 1: {
                        if (FlagNot) continue block11;
                        expBoType = 1;
                        continue block11;
                    }
                    case 2: {
                        if (FlagNot) continue block11;
                        expBoType = 2;
                        continue block11;
                    }
                    case 3: {
                        if (FlagNot) continue block11;
                        expBoType = 3;
                        continue block11;
                    }
                    case 4: {
                        if (FlagNot) {
                            this.mCurSubBoArom = 0;
                            continue block11;
                        }
                        this.mCurSubBoArom = 1;
                        continue block11;
                    }
                    case 5: {
                        continue block11;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        if (FlagNot) continue block11;
                        expBoType = 1;
                    }
                }
            }
        }
        return expBoType;
    }

    boolean isRingBond(IBond b, IRingSet ringSet) {
        IRingSet atom0Rings = ringSet.getRings(b.getAtom(0));
        IRingSet atom1Rings = ringSet.getRings(b.getAtom(1));
        for (int i = 0; i < atom0Rings.getAtomContainerCount(); ++i) {
            IAtomContainer c = atom0Rings.getAtomContainer(i);
            for (int k = 0; k < atom1Rings.getAtomContainerCount(); ++k) {
                if (atom1Rings.getAtomContainer(k) != c) continue;
                return true;
            }
        }
        return false;
    }

    IAtom getMarkedAtom() {
        IAtom a = (IAtom)this.builder.newInstance(IAtom.class, new Object[]{"C"});
        a.setProperty((Object)markProperty, (Object)new Integer(1));
        return a;
    }

    IBond getMarkedBond() {
        IBond b = (IBond)this.builder.newInstance(IBond.class, new Object[0]);
        b.setOrder(IBond.Order.SINGLE);
        b.setProperty((Object)markProperty, (Object)new Integer(1));
        return b;
    }

    Vector<IRingSet> getMaxCondensedRingSystems(IRingSet ringSet) {
        Vector<IRingSet> v = new Vector<IRingSet>();
        int n = ringSet.getAtomContainerCount();
        if (n == 0) {
            return v;
        }
        RingSet workRS = new RingSet();
        workRS.add(ringSet);
        while (workRS.getAtomContainerCount() > 0) {
            IAtomContainer ac = workRS.getAtomContainer(0);
            IRingSet rs = this.getCondenzedRingsTo(ac, ringSet);
            v.add(rs);
            for (int i = 0; i < rs.getAtomContainerCount(); ++i) {
                workRS.removeAtomContainer(rs.getAtomContainer(i));
            }
        }
        return v;
    }

    IRingSet getCondenzedRingsTo(IAtomContainer startAC, IRingSet ringSet) {
        IRingSet condRS = (IRingSet)this.builder.newInstance(IRingSet.class, new Object[0]);
        condRS.addAtomContainer(startAC);
        for (int curRing = 0; curRing < condRS.getAtomContainerCount(); ++curRing) {
            IRingSet rsConnected = ringSet.getConnectedRings((IRing)condRS.getAtomContainer(curRing));
            for (int i = 0; i < rsConnected.getAtomContainerCount(); ++i) {
                if (condRS.contains(rsConnected.getAtomContainer(i))) continue;
                condRS.addAtomContainer(rsConnected.getAtomContainer(i));
            }
        }
        return condRS;
    }

    QueryAtomContainer getCondensedFragmentFromRingSets(QueryAtomContainer query, IRingSet rs) {
        QueryAtomContainer qac = new QueryAtomContainer();
        for (int i = 0; i < rs.getAtomContainerCount(); ++i) {
            int k;
            IAtomContainer ac = rs.getAtomContainer(i);
            for (k = 0; k < ac.getAtomCount(); ++k) {
                IAtom a = ac.getAtom(k);
                if (qac.contains(a)) continue;
                qac.addAtom(a);
            }
            for (k = 0; k < ac.getBondCount(); ++k) {
                IBond b = ac.getBond(k);
                if (qac.contains(b)) continue;
                qac.addBond(b);
            }
        }
        return qac;
    }

    IAtomContainer condensedFragmentToContainer(QueryAtomContainer frag) {
        IAtom a;
        int i;
        IMolecule container = (IMolecule)this.builder.newInstance(IMolecule.class, new Object[0]);
        Vector<IAtom> atoms = new Vector<IAtom>();
        for (i = 0; i < frag.getAtomCount(); ++i) {
            a = this.toAtom(frag.getAtom(i));
            if (a == null) {
                return null;
            }
            if (a.getFlag(5)) {
                return null;
            }
            atoms.add(a);
        }
        for (i = 0; i < atoms.size(); ++i) {
            a = (IAtom)atoms.get(i);
            container.addAtom(a);
        }
        for (i = 0; i < frag.getBondCount(); ++i) {
            this.mFlagConfirmAromaticBond = false;
            IBond b = this.toBond(frag.getBond(i));
            if (b == null) continue;
            IAtom[] ats = new IAtom[2];
            int atNum = frag.getAtomNumber(frag.getBond(i).getAtom(0));
            ats[0] = (IAtom)atoms.get(atNum);
            atNum = frag.getAtomNumber(frag.getBond(i).getAtom(1));
            ats[1] = (IAtom)atoms.get(atNum);
            b.setAtoms(ats);
            container.addBond(b);
        }
        return container;
    }
}

