/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import javax.vecmath.Point3d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.PetitjeanShapeIndexDescriptorTest")
public class PaDELPetitjeanShapeIndexDescriptor
implements IMolecularDescriptor {
    private static final String[] names = new String[]{"geomRadius", "geomDiameter", "geomShape"};

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#petitjeanShapeIndex", this.getClass().getName(), "$Id: 0b088508f8c24cb7fa83da021a7457af4f455500 $", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return null;
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
        if (GeometryTools.has3DCoordinates(iAtomContainer)) {
            int n;
            int n2 = iAtomContainer.getAtomCount();
            double[][] dArray = new double[n2][n2];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (i == j) {
                        dArray[i][j] = 0.0;
                        continue;
                    }
                    Point3d point3d = iAtomContainer.getAtom(i).getPoint3d();
                    Point3d point3d2 = iAtomContainer.getAtom(j).getPoint3d();
                    dArray[i][j] = Math.sqrt((point3d.x - point3d2.x) * (point3d.x - point3d2.x) + (point3d.y - point3d2.y) * (point3d.y - point3d2.y) + (point3d.z - point3d2.z) * (point3d.z - point3d2.z));
                }
            }
            double d = 999999.0;
            double d2 = -999999.0;
            double[] dArray2 = new double[n2];
            for (n = 0; n < n2; ++n) {
                double d3 = -99999.0;
                for (int i = 0; i < n2; ++i) {
                    if (!(dArray[n][i] > d3)) continue;
                    d3 = dArray[n][i];
                }
                dArray2[n] = d3;
            }
            for (n = 0; n < n2; ++n) {
                if (dArray2[n] < d) {
                    d = dArray2[n];
                }
                if (!(dArray2[n] > d2)) continue;
                d2 = dArray2[n];
            }
            doubleArrayResult.add(d);
            doubleArrayResult.add(d2);
            doubleArrayResult.add((d2 - d) / d);
        } else {
            doubleArrayResult.add(Double.NaN);
            doubleArrayResult.add(Double.NaN);
            doubleArrayResult.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames());
    }

    @Override
    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(names.length);
    }
}

