/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.ReificationCache;
import com.hp.hpl.jena.db.impl.ReificationStatementMask;
import com.hp.hpl.jena.db.impl.ResultSetReifIterator;
import com.hp.hpl.jena.db.impl.SpecializedGraphReifier_RDB;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.shared.JenaException;

public class ReificationCacheMap {
    private final SpecializedGraphReifier_RDB reifier_RDB;
    protected int cacheSize = 1;
    protected ReificationCache[] cache;
    protected boolean[] inUse;

    ReificationCacheMap(SpecializedGraphReifier_RDB reifier_RDB, int size) {
        this.reifier_RDB = reifier_RDB;
        this.inUse = new boolean[size];
        this.cache = new ReificationCache[size];
        for (int i = 0; i < size; ++i) {
            this.inUse[i] = false;
        }
    }

    ReificationCache lookup(Node stmtURI) {
        for (int i = 0; i < this.cache.length; ++i) {
            if (!this.inUse[i] || !this.cache[i].getStmtURI().equals(stmtURI)) continue;
            return this.cache[i];
        }
        return null;
    }

    public void flushAll() {
        for (int i = 0; i < this.cache.length; ++i) {
            this.inUse[i] = false;
        }
    }

    public void flush(ReificationCache entry) {
        this.flushAll();
    }

    public ReificationCache load(Node stmtURI) {
        ReificationCache entry = this.lookup(stmtURI);
        if (entry != null) {
            return entry;
        }
        return this.load(stmtURI, null, null, null);
    }

    public ReificationCache load(Node stmtURI, Triple s, ReificationStatementMask sm, ReificationStatementMask dm) {
        this.flushAll();
        ReificationStatementMask m = new ReificationStatementMask();
        boolean checkSame = sm != null;
        int cnt = 0;
        ResultSetReifIterator it = this.reifier_RDB.m_reif.findReifStmt(stmtURI, false, this.reifier_RDB.my_GID, false);
        while (it.hasNext()) {
            boolean hasObj;
            boolean hasPred;
            boolean hasSubj;
            ++cnt;
            Triple db = (Triple)it.next();
            ReificationStatementMask n = new ReificationStatementMask();
            boolean bl = hasSubj = !db.getSubject().equals(Node.NULL);
            if (hasSubj && checkSame) {
                if (db.getSubject().equals(s.getSubject())) {
                    sm.setHasSubj();
                } else {
                    dm.setHasSubj();
                }
            }
            boolean bl2 = hasPred = !db.getPredicate().equals(Node.NULL);
            if (hasPred && checkSame) {
                if (db.getPredicate().equals(s.getPredicate())) {
                    sm.setHasPred();
                } else {
                    dm.setHasPred();
                }
            }
            boolean bl3 = hasObj = !db.getObject().equals(Node.NULL);
            if (hasObj && checkSame) {
                if (db.getObject().equals(s.getObject())) {
                    sm.setHasObj();
                } else {
                    dm.setHasObj();
                }
            }
            boolean hasType = it.getHasType();
            n.setMask(hasSubj, hasPred, hasObj, hasType);
            if (n.hasNada()) {
                throw new JenaException("Fragment has no data");
            }
            m.setMerge(n);
        }
        if (cnt == 0) {
            return null;
        }
        if (m.hasSPOT() && cnt == 1) {
            m.setIsStmt();
        }
        this.inUse[0] = true;
        this.cache[0] = new ReificationCache(stmtURI, m, cnt);
        return this.cache[0];
    }
}

