/*
 * Decompiled with CFR 0.152.
 */
package ambit2.base.data;

import ambit2.base.data.Property;
import ambit2.base.data.TypedListModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class PropertiesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -4031712164231916058L;
    protected List<Property> visibleFields = new ArrayList<Property>();
    protected boolean visibility = true;
    protected int columns = 1;

    public PropertiesTableModel(TypedListModel<Property> typedListModel, boolean bl, int n) {
        this.visibility = bl;
        this.columns = n;
        this.setFields(typedListModel);
    }

    @Override
    public int getColumnCount() {
        return this.columns;
    }

    @Override
    public int getRowCount() {
        return this.visibleFields.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.visibleFields.get(n);
            }
            case 1: {
                return this.visibleFields.get(n).getLabel();
            }
        }
        return "";
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Field name";
            }
            case 1: {
                return "Field label";
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 1: {
                this.visibleFields.get(n).setLabel(object.toString());
                break;
            }
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 > 0;
    }

    public void setFields(TypedListModel<Property> typedListModel) {
        this.visibleFields.clear();
        if (typedListModel != null) {
            for (int i = 0; i < typedListModel.getSize(); ++i) {
                Property property = typedListModel.getElementAt(i);
                if (this.visibility ^ property.isEnabled()) continue;
                this.visibleFields.add(property);
            }
            Collections.sort(this.visibleFields, new Comparator<Property>(){

                @Override
                public int compare(Property property, Property property2) {
                    return property.getOrder() - property2.getOrder();
                }
            });
        }
        this.fireTableStructureChanged();
    }
}

