/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.color.CDK2DAtomColors;
import org.openscience.cdk.renderer.color.IAtomColorer;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.TextElement;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.parameter.AbstractGeneratorParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.renderer.generators.AtomNumberGeneratorTest")
public class AtomNumberGenerator
implements IGenerator<IAtomContainer> {
    private IGeneratorParameter<Color> textColor = new AtomNumberTextColor();
    private WillDrawAtomNumbers willDrawAtomNumbers = new WillDrawAtomNumbers();
    private IGeneratorParameter<IAtomColorer> atomColorer = new AtomColorer();
    private IGeneratorParameter<Boolean> colorByType = new ColorByType();
    private Offset offset = new Offset();

    @Override
    @TestMethod(value="testEmptyContainer")
    public IRenderingElement generate(IAtomContainer container, RendererModel model) {
        ElementGroup numbers = new ElementGroup();
        if (!((Boolean)model.getParameter(WillDrawAtomNumbers.class).getValue()).booleanValue()) {
            return numbers;
        }
        Vector2d offset = new Vector2d(((Vector2d)this.offset.getValue()).x, -((Vector2d)this.offset.getValue()).y);
        offset.scale(1.0 / (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue());
        int number = 1;
        for (IAtom atom : container.atoms()) {
            Point2d point = new Point2d(atom.getPoint2d());
            point.add(offset);
            numbers.add(new TextElement(point.x, point.y, String.valueOf(number), this.colorByType.getValue() != false ? this.atomColorer.getValue().getAtomColor(atom) : this.textColor.getValue()));
            ++number;
        }
        return numbers;
    }

    @Override
    @TestMethod(value="testGetParameters")
    public List<IGeneratorParameter<?>> getParameters() {
        return Arrays.asList(this.textColor, this.willDrawAtomNumbers, this.offset, this.atomColorer, this.colorByType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Offset
    extends AbstractGeneratorParameter<Vector2d> {
        @Override
        public Vector2d getDefault() {
            return new Vector2d();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ColorByType
    extends AbstractGeneratorParameter<Boolean> {
        @Override
        public Boolean getDefault() {
            return Boolean.FALSE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AtomColorer
    extends AbstractGeneratorParameter<IAtomColorer> {
        @Override
        public IAtomColorer getDefault() {
            return new CDK2DAtomColors();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WillDrawAtomNumbers
    extends AbstractGeneratorParameter<Boolean> {
        @Override
        public Boolean getDefault() {
            return Boolean.TRUE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AtomNumberTextColor
    extends AbstractGeneratorParameter<Color> {
        @Override
        public Color getDefault() {
            return Color.BLACK;
        }
    }
}

