/*
 * Decompiled with CFR 0.152.
 */
package signature.chemistry;

import signature.AbstractVertexSignature;
import signature.chemistry.Molecule;

public class AtomSignature
extends AbstractVertexSignature {
    private Molecule molecule;

    public AtomSignature(Molecule molecule, int atomNumber) {
        this.molecule = molecule;
        this.createMaximumHeight(atomNumber, molecule.getAtomCount());
    }

    public AtomSignature(Molecule molecule, int atomNumber, int height) {
        this.molecule = molecule;
        this.create(atomNumber, molecule.getAtomCount(), height);
    }

    public AtomSignature(Molecule molecule, int atomNumber, int height, AbstractVertexSignature.InvariantType invariantType) {
        super(invariantType);
        this.molecule = molecule;
        this.create(atomNumber, molecule.getAtomCount(), height);
    }

    public int getIntLabel(int vertexIndex) {
        String symbol = this.getVertexSymbol(vertexIndex);
        if (symbol.equals("H")) {
            return 1;
        }
        if (symbol.equals("C")) {
            return 12;
        }
        if (symbol.equals("O")) {
            return 16;
        }
        return -1;
    }

    public int[] getConnected(int vertexIndex) {
        return this.molecule.getConnected(vertexIndex);
    }

    public String getEdgeLabel(int vertexIndex, int otherVertexIndex) {
        int bondOrder = this.molecule.getBondOrder(vertexIndex, otherVertexIndex);
        switch (bondOrder) {
            case 1: {
                return "";
            }
            case 2: {
                return "=";
            }
            case 3: {
                return "#";
            }
        }
        return "";
    }

    public String getVertexSymbol(int vertexIndex) {
        return this.molecule.getSymbolFor(vertexIndex);
    }
}

