/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.lang.constant.Constable;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.charges.GasteigerMarsiliPartialCharges;
import org.openscience.cdk.charges.Polarizability;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.graph.matrix.AdjacencyMatrix;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.LonePairElectronChecker;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.BCUTDescriptorTest")
public class BCUTDescriptor
implements IMolecularDescriptor {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(BCUTDescriptor.class);
    private int nhigh = 1;
    private int nlow = 1;
    private boolean checkAromaticity = true;

    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#BCUT", this.getClass().getName(), "$Id: 0ed0ec071708e230c314e0f7f5cc6a9258da654b $", "The Chemistry Development Kit");
    }

    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
        if (params.length != 3) {
            throw new CDKException("BCUTDescriptor requires 3 parameters");
        }
        if (!(params[0] instanceof Integer) || !(params[1] instanceof Integer)) {
            throw new CDKException("Parameters must be of type Integer");
        }
        if (!(params[2] instanceof Boolean)) {
            throw new CDKException("The third parameter must be of type Boolean");
        }
        this.nhigh = (Integer)params[0];
        this.nlow = (Integer)params[1];
        this.checkAromaticity = (Boolean)params[2];
        if (this.nhigh < 0 || this.nlow < 0) {
            throw new CDKException("Number of eigenvalues to return must be zero or more");
        }
    }

    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        Object[] params = new Object[]{this.nhigh, this.nlow, this.checkAromaticity};
        return params;
    }

    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        String[] suffix = new String[]{"w", "c", "p"};
        String[] names = new String[3 * this.nhigh + 3 * this.nlow];
        int counter = 0;
        for (String aSuffix : suffix) {
            int i;
            for (i = 0; i < this.nhigh; ++i) {
                names[counter++] = "BCUT" + aSuffix + "-" + (i + 1) + "l";
            }
            for (i = 0; i < this.nlow; ++i) {
                names[counter++] = "BCUT" + aSuffix + "-" + (i + 1) + "h";
            }
        }
        return names;
    }

    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        String[] params = new String[]{"nhigh", "nlow", "checkAromaticity"};
        return params;
    }

    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        Constable object = null;
        if (name.equals("nhigh")) {
            object = 1;
        }
        if (name.equals("nlow")) {
            object = 1;
        }
        if (name.equals("checkAromaticity")) {
            object = Boolean.valueOf(true);
        }
        return object;
    }

    private boolean hasUndefined(double[][] m) {
        for (double[] aM : m) {
            for (int j = 0; j < m[0].length; ++j) {
                if (!Double.isNaN(aM[j]) && !Double.isInfinite(aM[j])) continue;
                return true;
            }
        }
        return false;
    }

    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer container) {
        int i;
        int enhigh;
        int lnhigh;
        int enlow;
        int lnlow;
        IAtomContainer molecule;
        try {
            molecule = container.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.debug("Error during clone");
            return this.getDummyDescriptorValue(new CDKException("Error occured during clone " + e));
        }
        try {
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(molecule);
            CDKHydrogenAdder hAdder = CDKHydrogenAdder.getInstance(molecule.getBuilder());
            hAdder.addImplicitHydrogens(molecule);
            AtomContainerManipulator.convertImplicitToExplicitHydrogens(molecule);
        }
        catch (Exception e) {
            return this.getDummyDescriptorValue(new CDKException("Could not add hydrogens: " + e.getMessage(), e));
        }
        if (this.checkAromaticity) {
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(molecule);
            }
            catch (CDKException e) {
                return this.getDummyDescriptorValue(new CDKException("Error in atom typing: " + e.getMessage(), e));
            }
            try {
                CDKHueckelAromaticityDetector.detectAromaticity(molecule);
            }
            catch (CDKException e) {
                return this.getDummyDescriptorValue(new CDKException("Error in aromaticity perception: " + e.getMessage()));
            }
        }
        int nheavy = 0;
        for (int i2 = 0; i2 < molecule.getAtomCount(); ++i2) {
            if (molecule.getAtom(i2).getSymbol().equals("H")) continue;
            ++nheavy;
        }
        if (nheavy == 0) {
            return this.getDummyDescriptorValue(new CDKException("No heavy atoms in the molecule"));
        }
        double[] diagvalue = new double[nheavy];
        int counter = 0;
        try {
            for (int i3 = 0; i3 < molecule.getAtomCount(); ++i3) {
                if (molecule.getAtom(i3).getSymbol().equals("H")) continue;
                diagvalue[counter] = IsotopeFactory.getInstance(molecule.getBuilder()).getMajorIsotope(molecule.getAtom(i3).getSymbol()).getExactMass();
                ++counter;
            }
        }
        catch (Exception e) {
            return this.getDummyDescriptorValue(new CDKException("Could not calculate weight: " + e.getMessage(), e));
        }
        double[][] burdenMatrix = BurdenMatrix.evalMatrix(molecule, diagvalue);
        if (this.hasUndefined(burdenMatrix)) {
            return this.getDummyDescriptorValue(new CDKException("Burden matrix has undefined values"));
        }
        Matrix matrix = new Matrix(burdenMatrix);
        EigenvalueDecomposition eigenDecomposition = new EigenvalueDecomposition(matrix);
        double[] eval1 = eigenDecomposition.getRealEigenvalues();
        LonePairElectronChecker lpcheck = new LonePairElectronChecker();
        try {
            int i4;
            lpcheck.saturate(molecule);
            double[] charges = new double[molecule.getAtomCount()];
            GasteigerMarsiliPartialCharges peoe = new GasteigerMarsiliPartialCharges();
            peoe.assignGasteigerMarsiliSigmaPartialCharges(molecule, true);
            for (i4 = 0; i4 < molecule.getAtomCount(); ++i4) {
                int n = i4;
                charges[n] = charges[n] + molecule.getAtom(i4).getCharge();
            }
            for (i4 = 0; i4 < molecule.getAtomCount(); ++i4) {
                molecule.getAtom(i4).setCharge(charges[i4]);
            }
        }
        catch (Exception e) {
            return this.getDummyDescriptorValue(new CDKException("Could not calculate partial charges: " + e.getMessage(), e));
        }
        counter = 0;
        for (int i5 = 0; i5 < molecule.getAtomCount(); ++i5) {
            if (molecule.getAtom(i5).getSymbol().equals("H")) continue;
            diagvalue[counter] = molecule.getAtom(i5).getCharge();
            ++counter;
        }
        burdenMatrix = BurdenMatrix.evalMatrix(molecule, diagvalue);
        if (this.hasUndefined(burdenMatrix)) {
            return this.getDummyDescriptorValue(new CDKException("Burden matrix has undefined values"));
        }
        matrix = new Matrix(burdenMatrix);
        eigenDecomposition = new EigenvalueDecomposition(matrix);
        double[] eval2 = eigenDecomposition.getRealEigenvalues();
        int[][] topoDistance = PathTools.computeFloydAPSP(AdjacencyMatrix.getMatrix(molecule));
        Polarizability pol = new Polarizability();
        counter = 0;
        for (int i6 = 0; i6 < molecule.getAtomCount(); ++i6) {
            if (molecule.getAtom(i6).getSymbol().equals("H")) continue;
            diagvalue[counter] = pol.calculateGHEffectiveAtomPolarizability(molecule, molecule.getAtom(i6), false, topoDistance);
            ++counter;
        }
        burdenMatrix = BurdenMatrix.evalMatrix(molecule, diagvalue);
        if (this.hasUndefined(burdenMatrix)) {
            return this.getDummyDescriptorValue(new CDKException("Burden matrix has undefined values"));
        }
        matrix = new Matrix(burdenMatrix);
        eigenDecomposition = new EigenvalueDecomposition(matrix);
        double[] eval3 = eigenDecomposition.getRealEigenvalues();
        String[] suffix = new String[]{"w", "c", "p"};
        if (this.nlow > nheavy) {
            lnlow = nheavy;
            enlow = this.nlow - nheavy;
        } else {
            lnlow = this.nlow;
            enlow = 0;
        }
        if (this.nhigh > nheavy) {
            lnhigh = nheavy;
            enhigh = this.nhigh - nheavy;
        } else {
            lnhigh = this.nhigh;
            enhigh = 0;
        }
        DoubleArrayResult retval = new DoubleArrayResult((lnlow + enlow + lnhigh + enhigh) * 3);
        for (i = 0; i < lnlow; ++i) {
            retval.add(eval1[i]);
        }
        for (i = 0; i < enlow; ++i) {
            retval.add(Double.NaN);
        }
        for (i = 0; i < lnhigh; ++i) {
            retval.add(eval1[eval1.length - i - 1]);
        }
        for (i = 0; i < enhigh; ++i) {
            retval.add(Double.NaN);
        }
        for (i = 0; i < lnlow; ++i) {
            retval.add(eval2[i]);
        }
        for (i = 0; i < enlow; ++i) {
            retval.add(Double.NaN);
        }
        for (i = 0; i < lnhigh; ++i) {
            retval.add(eval2[eval2.length - i - 1]);
        }
        for (i = 0; i < enhigh; ++i) {
            retval.add(Double.NaN);
        }
        for (i = 0; i < lnlow; ++i) {
            retval.add(eval3[i]);
        }
        for (i = 0; i < enlow; ++i) {
            retval.add(Double.NaN);
        }
        for (i = 0; i < lnhigh; ++i) {
            retval.add(eval3[eval3.length - i - 1]);
        }
        for (i = 0; i < enhigh; ++i) {
            retval.add(Double.NaN);
        }
        String[] names = new String[3 * this.nhigh + 3 * this.nlow];
        counter = 0;
        for (String aSuffix : suffix) {
            int i7;
            for (i7 = 0; i7 < this.nhigh; ++i7) {
                names[counter++] = "BCUT" + aSuffix + "-" + (i7 + 1) + "l";
            }
            for (i7 = 0; i7 < this.nlow; ++i7) {
                names[counter++] = "BCUT" + aSuffix + "-" + (i7 + 1) + "h";
            }
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), retval, this.getDescriptorNames());
    }

    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(6);
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        DoubleArrayResult results = new DoubleArrayResult(6);
        for (int i = 0; i < 6; ++i) {
            results.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), results, this.getDescriptorNames(), e);
    }

    private static class BurdenMatrix {
        private BurdenMatrix() {
        }

        static double[][] evalMatrix(IAtomContainer atomContainer, double[] vsd) {
            int j;
            int i;
            IAtomContainer local = AtomContainerManipulator.removeHydrogens(atomContainer);
            int natom = local.getAtomCount();
            double[][] matrix = new double[natom][natom];
            for (i = 0; i < natom; ++i) {
                for (j = 0; j < natom; ++j) {
                    matrix[i][j] = 0.0;
                }
            }
            for (i = 0; i < natom - 1; ++i) {
                for (j = i + 1; j < natom; ++j) {
                    for (int k = 0; k < local.getBondCount(); ++k) {
                        IBond bond = local.getBond(k);
                        if (bond.contains(local.getAtom(i)) && bond.contains(local.getAtom(j))) {
                            if (bond.getFlag(5)) {
                                matrix[i][j] = 0.15;
                            } else if (bond.getOrder() == CDKConstants.BONDORDER_SINGLE) {
                                matrix[i][j] = 0.1;
                            } else if (bond.getOrder() == CDKConstants.BONDORDER_DOUBLE) {
                                matrix[i][j] = 0.2;
                            } else if (bond.getOrder() == CDKConstants.BONDORDER_TRIPLE) {
                                matrix[i][j] = 0.3;
                            }
                            if (local.getConnectedBondsCount(i) == 1 || local.getConnectedBondsCount(j) == 1) {
                                double[] dArray = matrix[i];
                                int n = j;
                                dArray[n] = dArray[n] + 0.01;
                            }
                            matrix[j][i] = matrix[i][j];
                            continue;
                        }
                        matrix[i][j] = 0.001;
                        matrix[j][i] = 0.001;
                    }
                }
            }
            for (i = 0; i < natom; ++i) {
                matrix[i][i] = vsd != null ? vsd[i] : 0.0;
            }
            return matrix;
        }
    }
}

