/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers.smarts;

import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.isomorphism.matchers.smarts.SMARTSAtom;

public class HybridizationNumberAtom
extends SMARTSAtom {
    IAtomType.Hybridization hybridization;

    public HybridizationNumberAtom(int hybridizationNumber) {
        switch (hybridizationNumber) {
            case 1: {
                this.hybridization = IAtomType.Hybridization.SP1;
                break;
            }
            case 2: {
                this.hybridization = IAtomType.Hybridization.SP2;
                break;
            }
            case 3: {
                this.hybridization = IAtomType.Hybridization.SP3;
                break;
            }
            case 4: {
                this.hybridization = IAtomType.Hybridization.SP3D1;
                break;
            }
            case 5: {
                this.hybridization = IAtomType.Hybridization.SP3D2;
                break;
            }
            case 6: {
                this.hybridization = IAtomType.Hybridization.SP3D3;
                break;
            }
            case 7: {
                this.hybridization = IAtomType.Hybridization.SP3D4;
                break;
            }
            case 8: {
                this.hybridization = IAtomType.Hybridization.SP3D5;
            }
        }
    }

    public boolean matches(IAtom atom) {
        return this.hybridization == atom.getHybridization();
    }

    public String toString() {
        return "HybridizationNumberAtom(" + this.hybridization.toString() + ")";
    }
}

