/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import java.util.Map;
import org.openscience.cdk.AtomType;
import org.openscience.cdk.debug.DebugChemObjectBuilder;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugAtomType
extends AtomType
implements IAtomType {
    private static final long serialVersionUID = 1427549696666679540L;
    ILoggingTool logger = LoggingToolFactory.createLoggingTool(DebugAtomType.class);

    public DebugAtomType(String elementSymbol) {
        super(elementSymbol);
        this.logger.debug("Instantiated a DebugAtomType: symbol= ", elementSymbol);
    }

    public DebugAtomType(String identifier, String elementSymbol) {
        super(elementSymbol);
        this.logger.debug("Instantiated a DebugAtomType: identifier= " + identifier + " symbol= ", elementSymbol);
        this.setSymbol(elementSymbol);
        this.setAtomTypeName(identifier);
    }

    public DebugAtomType(IElement element) {
        super(element);
        this.logger.debug("Instantiated a DebugAtomType: element= ", element);
    }

    @Override
    public Integer getAtomicNumber() {
        this.logger.debug("Getting atomic number: ", super.getAtomicNumber());
        return super.getAtomicNumber();
    }

    @Override
    public void setAtomicNumber(Integer atomicNumber) {
        this.logger.debug("Setting atomic number: ", atomicNumber);
        super.setAtomicNumber(atomicNumber);
    }

    @Override
    public String getSymbol() {
        this.logger.debug("Getting symbol: ", super.getSymbol());
        return super.getSymbol();
    }

    @Override
    public void setSymbol(String symbol) {
        this.logger.debug("Setting symbol: ", symbol);
        super.setSymbol(symbol);
    }

    @Override
    public void addListener(IChemObjectListener col) {
        this.logger.debug("Adding listener: ", col);
        super.addListener(col);
    }

    @Override
    public int getListenerCount() {
        this.logger.debug("Getting listener count: ", super.getListenerCount());
        return super.getListenerCount();
    }

    @Override
    public void removeListener(IChemObjectListener col) {
        this.logger.debug("Removing listener: ", col);
        super.removeListener(col);
    }

    @Override
    public void notifyChanged() {
        this.logger.debug("Notifying changed");
        super.notifyChanged();
    }

    @Override
    public void notifyChanged(IChemObjectChangeEvent evt) {
        this.logger.debug("Notifying changed event: ", evt);
        super.notifyChanged(evt);
    }

    @Override
    public void setProperty(Object description, Object property) {
        this.logger.debug("Setting property: ", description + "=" + property);
        super.setProperty(description, property);
    }

    @Override
    public void removeProperty(Object description) {
        this.logger.debug("Removing property: ", description);
        super.removeProperty(description);
    }

    @Override
    public Object getProperty(Object description) {
        this.logger.debug("Getting property: ", description + "=" + super.getProperty(description));
        return super.getProperty(description);
    }

    @Override
    public Map<Object, Object> getProperties() {
        this.logger.debug("Getting properties");
        return super.getProperties();
    }

    @Override
    public String getID() {
        this.logger.debug("Getting ID: ", super.getID());
        return super.getID();
    }

    @Override
    public void setID(String identifier) {
        this.logger.debug("Setting ID: ", identifier);
        super.setID(identifier);
    }

    @Override
    public void setFlag(int flag_type, boolean flag_value) {
        this.logger.debug("Setting flag: ", flag_type + "=" + flag_value);
        super.setFlag(flag_type, flag_value);
    }

    @Override
    public boolean getFlag(int flag_type) {
        this.logger.debug("Setting flag: ", flag_type + "=" + super.getFlag(flag_type));
        return super.getFlag(flag_type);
    }

    @Override
    public void setProperties(Map<Object, Object> properties) {
        this.logger.debug("Setting properties: ", properties);
        super.setProperties(properties);
    }

    @Override
    public void setFlags(boolean[] flagsNew) {
        this.logger.debug("Setting flags:", flagsNew.length);
        super.setFlags(flagsNew);
    }

    @Override
    public boolean[] getFlags() {
        this.logger.debug("Getting flags:", super.getFlags().length);
        return super.getFlags();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (Exception exception) {
            this.logger.error("Could not clone DebugAtom: " + exception.getMessage(), exception);
            this.logger.debug(exception);
        }
        return clone;
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return DebugChemObjectBuilder.getInstance();
    }

    @Override
    public void setNaturalAbundance(Double naturalAbundance) {
        this.logger.debug("Setting natural abundance: ", naturalAbundance);
        super.setNaturalAbundance(naturalAbundance);
    }

    @Override
    public void setExactMass(Double exactMass) {
        this.logger.debug("Setting exact mass: ", exactMass);
        super.setExactMass(exactMass);
    }

    @Override
    public Double getNaturalAbundance() {
        this.logger.debug("Getting natural abundance: ", super.getNaturalAbundance());
        return super.getNaturalAbundance();
    }

    @Override
    public Double getExactMass() {
        this.logger.debug("Getting exact mass: ", super.getExactMass());
        return super.getExactMass();
    }

    @Override
    public Integer getMassNumber() {
        this.logger.debug("Getting mass number: ", super.getMassNumber());
        return super.getMassNumber();
    }

    @Override
    public void setMassNumber(Integer massNumber) {
        this.logger.debug("Setting mass number: ", massNumber);
        super.setMassNumber(massNumber);
    }

    @Override
    public void setAtomTypeName(String identifier) {
        this.logger.debug("Setting atom type name: ", identifier);
        super.setAtomTypeName(identifier);
    }

    @Override
    public void setMaxBondOrder(IBond.Order maxBondOrder) {
        this.logger.debug("Setting max bond order: ", new Object[]{maxBondOrder});
        super.setMaxBondOrder(maxBondOrder);
    }

    @Override
    public void setBondOrderSum(Double bondOrderSum) {
        this.logger.debug("Setting bond order sum: ", bondOrderSum);
        super.setBondOrderSum(bondOrderSum);
    }

    @Override
    public String getAtomTypeName() {
        this.logger.debug("Getting atom type name: ", super.getAtomTypeName());
        return super.getAtomTypeName();
    }

    @Override
    public IBond.Order getMaxBondOrder() {
        this.logger.debug("Getting max bond order: ", new Object[]{super.getMaxBondOrder()});
        return super.getMaxBondOrder();
    }

    @Override
    public Double getBondOrderSum() {
        this.logger.debug("Getting bond order sum: ", super.getBondOrderSum());
        return super.getBondOrderSum();
    }

    @Override
    public void setFormalCharge(Integer charge) {
        this.logger.debug("Setting formal charge: ", charge);
        super.setFormalCharge(charge);
    }

    @Override
    public Integer getFormalCharge() {
        this.logger.debug("Getting formal charge: ", super.getFormalCharge());
        return super.getFormalCharge();
    }

    @Override
    public void setFormalNeighbourCount(Integer count) {
        this.logger.debug("Setting forml neighbour count: ", count);
        super.setFormalNeighbourCount(count);
    }

    @Override
    public Integer getFormalNeighbourCount() {
        this.logger.debug("Getting formal neighbour count: ", super.getFormalNeighbourCount());
        return super.getFormalNeighbourCount();
    }

    @Override
    public void setHybridization(IAtomType.Hybridization hybridization) {
        this.logger.debug("Setting hybridization: ", new Object[]{hybridization});
        super.setHybridization(hybridization);
    }

    @Override
    public IAtomType.Hybridization getHybridization() {
        this.logger.debug("Getting hybridization: ", new Object[]{super.getHybridization()});
        return super.getHybridization();
    }

    @Override
    public void setCovalentRadius(Double radius) {
        this.logger.debug("Setting covalent radius: ", radius);
        super.setCovalentRadius(radius);
    }

    @Override
    public Double getCovalentRadius() {
        this.logger.debug("Getting covalent radius: ", super.getCovalentRadius());
        return super.getCovalentRadius();
    }

    @Override
    public void setValency(Integer valency) {
        this.logger.debug("Setting valency: ", valency);
        super.setValency(valency);
    }

    @Override
    public Integer getValency() {
        this.logger.debug("Getting valency: ", super.getValency());
        return super.getValency();
    }
}

