/*
 * Decompiled with CFR 0.152.
 */
package ambit2.smarts;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

public class EquivalenceTester {
    public IAtomContainer target;
    public int[] atomClasses;
    public int nClasses;

    public void setTarget(IAtomContainer t) {
        this.target = t;
        this.atomClasses = new int[this.target.getAtomCount()];
        this.nClasses = 0;
        for (int i = 0; i < this.atomClasses.length; ++i) {
            this.atomClasses[i] = 0;
        }
    }

    public void quickFindEquivalentTerminalHAtoms() {
        for (int i = 0; i < this.target.getAtomCount(); ++i) {
            IAtom a;
            int k;
            IAtom at = this.target.getAtom(i);
            if (at.getSymbol().equals("H")) continue;
            List list = this.target.getConnectedAtomsList(at);
            ArrayList<IAtom> hlist = new ArrayList<IAtom>();
            for (k = 0; k < list.size(); ++k) {
                a = (IAtom)list.get(k);
                if (!a.getSymbol().equals("H")) continue;
                hlist.add(a);
            }
            if (hlist.isEmpty()) continue;
            ++this.nClasses;
            for (k = 0; k < hlist.size(); ++k) {
                a = (IAtom)hlist.get(k);
                int index = this.target.getAtomNumber(a);
                this.atomClasses[index] = this.nClasses;
            }
        }
    }

    public boolean equivalentMaps(Vector<IAtom> map1, Vector<IAtom> map2) {
        if (map1.size() != map2.size()) {
            return false;
        }
        for (int i = 0; i < map1.size(); ++i) {
            if (map1.get(i) == map2.get(i) || this.equivalentAtoms(map1.get(i), map2.get(i))) continue;
            return false;
        }
        return true;
    }

    public Vector<Vector<IAtom>> filterEquivalentMappings(Vector<Vector<IAtom>> maps) {
        if (maps.size() == 0) {
            return maps;
        }
        Vector<Vector<IAtom>> res = new Vector<Vector<IAtom>>();
        res.add(maps.get(0));
        for (int i = 1; i < maps.size(); ++i) {
            boolean FlagEquivalent = false;
            for (int k = 0; k < res.size(); ++k) {
                if (!this.equivalentMaps(maps.get(i), res.get(k))) continue;
                FlagEquivalent = true;
                break;
            }
            if (FlagEquivalent) continue;
            res.add(maps.get(i));
        }
        return res;
    }

    public boolean equivalentAtoms(IAtom a1, IAtom a2) {
        int a1_ind = this.target.getAtomNumber(a1);
        int a2_ind = this.target.getAtomNumber(a2);
        return this.atomClasses[a1_ind] > 0 && this.atomClasses[a2_ind] > 0 && this.atomClasses[a1_ind] == this.atomClasses[a2_ind];
    }
}

