/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.util.List;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.NoSuchAtomException;
import org.openscience.cdk.graph.SpanningTree;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.BondManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.RotatableBondsCountDescriptorTest")
public class PaDELRotatableBondsCountDescriptor
implements IMolecularDescriptor {
    private static final String[] names = new String[]{"nRotB", "RotBFrac", "nRotBt", "RotBtFrac"};

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#rotatableBondsCount", this.getClass().getName(), "$Id: 75ae921845de8bd2afa9094077b54a7f8a79e4c1 $", "The Chemistry Development Kit");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        IRingSet iRingSet;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            iRingSet = new SpanningTree(iAtomContainer).getBasicRings();
        }
        catch (NoSuchAtomException noSuchAtomException) {
            DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
            doubleArrayResult.add(Double.NaN);
            doubleArrayResult.add(Double.NaN);
            doubleArrayResult.add(Double.NaN);
            doubleArrayResult.add(Double.NaN);
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, names);
        }
        for (IBond iBond : iAtomContainer.bonds()) {
            if (iRingSet.getRings(iBond).getAtomContainerCount() <= 0) continue;
            iBond.setFlag(1, true);
        }
        for (IBond iBond : iAtomContainer.bonds()) {
            IAtom iAtom = iBond.getAtom(0);
            IAtom iAtom2 = iBond.getAtom(1);
            if (iAtom.getSymbol().equals("H") || iAtom2.getSymbol().equals("H")) continue;
            ++n3;
            if (iBond.getOrder() != CDKConstants.BONDORDER_SINGLE || !BondManipulator.isLowerOrder(iAtomContainer.getMaximumBondOrder(iAtom), IBond.Order.TRIPLE) || !BondManipulator.isLowerOrder(iAtomContainer.getMaximumBondOrder(iAtom2), IBond.Order.TRIPLE) || iBond.getFlag(1)) continue;
            ++n2;
            int n4 = iAtomContainer.getConnectedBondsCount(iAtom) - this.getConnectedHCount(iAtomContainer, iAtom);
            int n5 = iAtomContainer.getConnectedBondsCount(iAtom2) - this.getConnectedHCount(iAtomContainer, iAtom2);
            if (n4 == 1 || n5 == 1) continue;
            ++n;
        }
        double d = 0.0;
        double d2 = 0.0;
        if (n3 > 0) {
            d = (double)n / (double)n3;
            d2 = (double)n2 / (double)n3;
        }
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
        doubleArrayResult.add(n);
        doubleArrayResult.add(d);
        doubleArrayResult.add(n2);
        doubleArrayResult.add(d2);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, names);
    }

    private int getConnectedHCount(IAtomContainer iAtomContainer, IAtom iAtom) {
        List<IAtom> list = iAtomContainer.getConnectedAtomsList(iAtom);
        int n = 0;
        for (IAtom iAtom2 : list) {
            if (!iAtom2.getSymbol().equals("H")) continue;
            ++n;
        }
        return n;
    }

    @Override
    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(names.length);
    }
}

