/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import libpadeldescriptor.KierHallElectronegativityDescriptor;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

@TestClass(value="org.openscience.cdk.qsar.descriptors.atomic.hydrogenEStateDescriptorTest")
public class HydrogenEStateDescriptor
implements IAtomicDescriptor {
    private static final String[] names = new String[]{"HydrogenEState"};

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("hydrogenEState", this.getClass().getName(), "$Id: ElectrotopologicalStateDescriptor.java 1 2008-06-10 10:12:38Z yapchunwei $", "PaDEL");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception exception) {
        int n = this.getDescriptorNames().length;
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult(n);
        for (int i = 0; i < n; ++i) {
            doubleArrayResult.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames(), exception);
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtom iAtom, IAtomContainer iAtomContainer) {
        try {
            KierHallElectronegativityDescriptor kierHallElectronegativityDescriptor = new KierHallElectronegativityDescriptor();
            double d = 0.0;
            int n = PeriodicTable.getAtomicNumber(iAtom.getSymbol());
            if (n != 1) {
                double d2 = ((DoubleResult)kierHallElectronegativityDescriptor.calculate(iAtom, iAtomContainer).getValue()).doubleValue();
                double d3 = 0.0;
                for (IAtom iAtom2 : iAtomContainer.atoms()) {
                    if (iAtom2 == iAtom || iAtom2.getSymbol().equals("H")) continue;
                    int n2 = PathTools.getShortestPath(iAtomContainer, iAtom, iAtom2).size();
                    d3 += (d2 - ((DoubleResult)kierHallElectronegativityDescriptor.calculate(iAtom2, iAtomContainer).getValue()).doubleValue()) / (double)(n2 * n2);
                }
                d = d3 - d2;
                if (AtomContainerManipulator.countHydrogens(iAtomContainer, iAtom) > 0) {
                    d += -0.2;
                }
                d = -d;
            }
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(d), names);
        }
        catch (Exception exception) {
            return this.getDummyDescriptorValue(new CDKException("Error in ElementPTFactory: " + exception.getMessage()));
        }
    }

    public DescriptorValue calculate(IAtom iAtom, IAtomContainer iAtomContainer, int[] nArray) {
        try {
            KierHallElectronegativityDescriptor kierHallElectronegativityDescriptor = new KierHallElectronegativityDescriptor();
            double d = 0.0;
            int n = PeriodicTable.getAtomicNumber(iAtom.getSymbol());
            if (n != 1) {
                double d2 = ((DoubleResult)kierHallElectronegativityDescriptor.calculate(iAtom, iAtomContainer).getValue()).doubleValue();
                double d3 = 0.0;
                int n2 = iAtomContainer.getAtomCount();
                for (int i = 0; i < n2; ++i) {
                    IAtom iAtom2 = iAtomContainer.getAtom(i);
                    if (iAtom2 == iAtom || iAtom2.getSymbol().equals("H")) continue;
                    int n3 = nArray[i] + 1;
                    d3 += (d2 - ((DoubleResult)kierHallElectronegativityDescriptor.calculate(iAtom2, iAtomContainer).getValue()).doubleValue()) / (double)(n3 * n3);
                }
                d = d3 - d2;
                if (AtomContainerManipulator.countHydrogens(iAtomContainer, iAtom) > 0) {
                    d += -0.2;
                }
                d = -d;
            }
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(d), names);
        }
        catch (Exception exception) {
            return this.getDummyDescriptorValue(new CDKException("Error in ElementPTFactory: " + exception.getMessage()));
        }
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return new String[0];
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String string) {
        return null;
    }
}

