/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.SSSRFinder;
import org.openscience.cdk.smiles.smarts.SMARTSQueryTool;

public class JOELib2BasicAromaticityTyper {
    private static final boolean DEFAULT_AVOID_INNER_RING_FLAG = true;
    private boolean[] isRoot = null;
    private boolean[] isVisited = null;
    private static final String[] smarts = new String[]{"[#6]", "[#6-]", "[#7]", "[#7]=*", "[#7+]", "[#7]=O", "[#7-]", "[#8]", "[#8+]", "[#16]", "[#16+]", "[#15]", "[#34]"};
    private static final int[] minElectrons = new int[]{1, 2, 1, 1, 1, 1, 2, 2, 1, 2, 1, 2, 2};
    private static final int[] maxElectrons = new int[]{1, 2, 2, 1, 1, 1, 2, 2, 1, 2, 1, 2, 2};
    private int[][] numberOfElectrons = null;
    private boolean[] potentiallyAromatic = null;

    public void assignAromaticFlags(IAtomContainer iAtomContainer) {
        int n;
        int n2 = iAtomContainer.getAtomCount();
        this.potentiallyAromatic = new boolean[n2];
        this.isRoot = new boolean[n2];
        this.isVisited = new boolean[n2];
        this.numberOfElectrons = new int[n2][2];
        this.markPotentiallyAromatic(iAtomContainer);
        this.sanityCheck(iAtomContainer);
        this.propagatePotArom(iAtomContainer);
        this.selectRootAtoms(iAtomContainer, true);
        this.excludeSmallRing(iAtomContainer);
        int n3 = iAtomContainer.getBondCount();
        boolean[] blArray = new boolean[n3];
        int n4 = iAtomContainer.getAtomCount();
        boolean[] blArray2 = new boolean[n4];
        this.checkAromaticity(iAtomContainer, blArray2, blArray);
        int n5 = n4;
        for (n = 0; n < n5; ++n) {
            if (!blArray2[n]) continue;
            iAtomContainer.getAtom(n).setFlag(5, true);
        }
        n5 = n3;
        for (n = 0; n < n5; ++n) {
            if (!blArray[n]) continue;
            iAtomContainer.getBond(n).setFlag(5, true);
        }
    }

    private void checkAromaticity(IAtomContainer iAtomContainer, boolean[] blArray, boolean[] blArray2) {
        IAtom iAtom;
        int n;
        int n2 = iAtomContainer.getAtomCount();
        for (n = 0; n < n2; ++n) {
            iAtom = iAtomContainer.getAtom(n);
            if (!this.isRoot[n]) continue;
            this.checkAromaticity(iAtomContainer, iAtom, 6, blArray, blArray2);
        }
        n2 = iAtomContainer.getAtomCount();
        for (n = 0; n < n2; ++n) {
            iAtom = iAtomContainer.getAtom(n);
            if (!this.isRoot[n]) continue;
            this.checkAromaticity(iAtomContainer, iAtom, 20, blArray, blArray2);
        }
    }

    private void checkAromaticity(IAtomContainer iAtomContainer, IAtom iAtom, int n, boolean[] blArray, boolean[] blArray2) {
        List<IAtom> list = iAtomContainer.getConnectedAtomsList(iAtom);
        for (IAtom iAtom2 : list) {
            int[] nArray;
            IBond iBond = iAtomContainer.getBond(iAtom, iAtom2);
            if (!iAtom.getFlag(1) || !iAtom2.getFlag(1) || blArray2[iAtomContainer.getBondNumber(iBond)] || !this.traverseCycle(iAtomContainer, iAtom, iAtom2, iBond, nArray = this.numberOfElectrons[iAtomContainer.getAtomNumber(iAtom)], n - 1, blArray, blArray2)) continue;
            blArray[iAtomContainer.getAtomNumber((IAtom)iAtom)] = true;
            blArray2[iAtomContainer.getBondNumber((IBond)iBond)] = true;
        }
    }

    private void excludeSmallRing(IAtomContainer iAtomContainer) {
        int n = iAtomContainer.getAtomCount();
        for (int i = 0; i < n; ++i) {
            IAtom iAtom = iAtomContainer.getAtom(i);
            if (!this.isRoot[i]) continue;
            List<IAtom> list = iAtomContainer.getConnectedAtomsList(iAtom);
            for (IAtom iAtom2 : list) {
                IBond iBond = iAtomContainer.getBond(iAtom, iAtom2);
                if (!iAtom.getFlag(1) || !iAtom2.getFlag(1) || !this.potentiallyAromatic[iAtomContainer.getAtomNumber(iAtom2)]) continue;
                List<IAtom> list2 = iAtomContainer.getConnectedAtomsList(iAtom2);
                for (IAtom iAtom3 : list2) {
                    if (iAtom3 == iAtom || !iAtom3.getFlag(1) || !this.potentiallyAromatic[iAtomContainer.getAtomNumber(iAtom3)] || iAtomContainer.getBond(iAtom, iAtom3) == null) continue;
                    this.isRoot[i] = false;
                }
            }
        }
    }

    private void markPotentiallyAromatic(IAtomContainer iAtomContainer) {
        try {
            SMARTSQueryTool sMARTSQueryTool = new SMARTSQueryTool("C");
            int n = 0;
            int n2 = 0;
            while (n2 < smarts.length) {
                String string = smarts[n2];
                sMARTSQueryTool.setSmarts(string);
                if (sMARTSQueryTool.matches(iAtomContainer)) {
                    List<List<Integer>> list = sMARTSQueryTool.getUniqueMatchingAtoms();
                    for (int i = 0; i < list.size(); ++i) {
                        List<Integer> list2 = list.get(i);
                        for (Integer n3 : list2) {
                            this.potentiallyAromatic[n3.intValue()] = true;
                            this.numberOfElectrons[n3.intValue()][0] = minElectrons[n];
                            this.numberOfElectrons[n3.intValue()][1] = maxElectrons[n];
                        }
                    }
                }
                ++n2;
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void printPotentialAromatic(IAtomContainer iAtomContainer, String string) {
        for (int i = 0; i < this.potentiallyAromatic.length; ++i) {
            System.out.println(string + " pot. aromatic (" + i + "_" + iAtomContainer.getAtom(i).getAtomTypeName() + ")=" + this.potentiallyAromatic[i]);
        }
    }

    private void propagatePotArom(IAtomContainer iAtomContainer) {
        int n = iAtomContainer.getAtomCount();
        for (int i = 0; i < n; ++i) {
            IAtom iAtom = iAtomContainer.getAtom(i);
            if (!this.potentiallyAromatic[i]) continue;
            this.propagatePotArom(iAtomContainer, iAtom);
        }
    }

    private void propagatePotArom(IAtomContainer iAtomContainer, IAtom iAtom) {
        int n = 0;
        List<IAtom> list = iAtomContainer.getConnectedAtomsList(iAtom);
        for (IAtom iAtom2 : list) {
            IBond iBond = iAtomContainer.getBond(iAtom, iAtom2);
            if (!iAtom.getFlag(1) || !iAtom2.getFlag(1) || !this.potentiallyAromatic[iAtomContainer.getAtomNumber(iAtom2)]) continue;
            ++n;
        }
        if (n < 2) {
            this.potentiallyAromatic[iAtomContainer.getAtomNumber((IAtom)iAtom)] = false;
            if (n == 1) {
                for (IAtom iAtom2 : list) {
                    if (!iAtom.getFlag(1) || !iAtom2.getFlag(1) || !this.potentiallyAromatic[iAtomContainer.getAtomNumber(iAtom2)]) continue;
                    this.propagatePotArom(iAtomContainer, iAtom2);
                }
            }
        }
    }

    private void sanityCheck(IAtomContainer iAtomContainer) {
        int n = iAtomContainer.getAtomCount();
        block3: for (int i = 0; i < n; ++i) {
            IAtom iAtom = iAtomContainer.getAtom(i);
            if (iAtom.getFormalNeighbourCount() > 3) {
                this.potentiallyAromatic[i] = false;
                continue;
            }
            switch (iAtom.getAtomicNumber()) {
                case 6: {
                    if (iAtom.getHybridization() == IAtomType.Hybridization.SP2) continue block3;
                    this.potentiallyAromatic[i] = false;
                }
            }
        }
    }

    private void selectRootAtoms(IAtomContainer iAtomContainer, boolean bl) {
        IAtom iAtom;
        List<IAtom> list;
        int n;
        SSSRFinder sSSRFinder = new SSSRFinder(iAtomContainer);
        IRingSet iRingSet = sSSRFinder.findEssentialRings();
        IAtom iAtom2 = null;
        ArrayList<IAtom> arrayList = new ArrayList<IAtom>();
        int n2 = iRingSet.getAtomContainerCount();
        for (n = 0; n < n2; ++n) {
            list = iRingSet.getAtomContainer(n);
            iAtom = list.getFirstAtom();
            arrayList.add(list.getFirstAtom());
        }
        n2 = iRingSet.getAtomContainerCount();
        for (n = 0; n < n2; ++n) {
            iAtom = iRingSet.getAtomContainer(n).getFirstAtom();
            this.isRoot[iAtomContainer.getAtomNumber((IAtom)iAtom)] = true;
            if (!bl) continue;
            list = iAtomContainer.getConnectedAtomsList(iAtom);
            int n3 = 0;
            int n4 = 0;
            for (IAtom iAtom3 : list) {
                if (iAtom3.getSymbol().equals("H")) continue;
                ++n4;
                if (!iAtom3.getFlag(1)) continue;
                ++n3;
            }
            iAtom2 = null;
            if (n3 <= 2) continue;
            for (int i = 0; i < iRingSet.getAtomContainerCount(); ++i) {
                Object object;
                int n5;
                IAtomContainer iAtomContainer2 = iRingSet.getAtomContainer(i);
                boolean bl2 = false;
                int n6 = 0;
                for (n5 = 0; n5 < arrayList.size() && (iAtomContainer2.getAtomNumber((IAtom)(object = (IAtom)arrayList.get(n5))) == -1 || ++n6 < 2); ++n5) {
                }
                if (n6 < 2) {
                    for (n5 = 0; n5 < iAtomContainer2.getAtomCount(); ++n5) {
                        if (iAtomContainer2.getAtom(n) == iAtom) {
                            bl2 = true;
                            continue;
                        }
                        if (!this.isRoot[iAtomContainer.getAtomNumber(iAtomContainer2.getAtom(n))]) continue;
                        bl2 = false;
                        break;
                    }
                }
                if (!bl2) continue;
                for (n5 = 0; n5 < iAtomContainer2.getAtomCount(); ++n5) {
                    list = iAtomContainer.getConnectedAtomsList(iAtomContainer2.getAtom(n5));
                    n4 = 0;
                    n3 = 0;
                    object = list.iterator();
                    while (object.hasNext()) {
                        IAtom iAtom4 = (IAtom)object.next();
                        if (iAtom4.getSymbol().equals("H")) continue;
                        ++n4;
                        if (!iAtom4.getFlag(1)) continue;
                        ++n3;
                    }
                    if (n3 > 2 || !iAtomContainer2.getAtom(n5).getFlag(1)) continue;
                    iAtom2 = iAtomContainer2.getAtom(n5);
                }
            }
            if (iAtom2 == null || iAtom == iAtom2) continue;
            this.isRoot[iAtomContainer.getAtomNumber((IAtom)iAtom)] = false;
            this.isRoot[iAtomContainer.getAtomNumber(iAtom2)] = true;
        }
    }

    private boolean traverseCycle(IAtomContainer iAtomContainer, IAtom iAtom, IAtom iAtom2, IBond iBond, int[] nArray, int n, boolean[] blArray, boolean[] blArray2) {
        int n2 = iAtomContainer.getAtomNumber(iAtom2);
        if (iAtom2 == iAtom) {
            for (int i = nArray[0]; i <= nArray[1]; ++i) {
                if (i % 4 != 2 || i <= 2) continue;
                return true;
            }
            return false;
        }
        if (n == 0 || !this.potentiallyAromatic[n2] || this.isVisited[n2]) {
            return false;
        }
        boolean bl = false;
        --n;
        nArray[0] = nArray[0] + this.numberOfElectrons[n2][0];
        nArray[1] = nArray[1] + this.numberOfElectrons[n2][1];
        this.isVisited[n2] = true;
        List<IAtom> list = iAtomContainer.getConnectedAtomsList(iAtom2);
        for (IAtom iAtom3 : list) {
            IBond iBond2 = iAtomContainer.getBond(iAtom2, iAtom3);
            if (iBond2 == iBond || !iAtom2.getFlag(1) || !iAtom3.getFlag(1) || !this.potentiallyAromatic[iAtomContainer.getAtomNumber(iAtom3)] || !this.traverseCycle(iAtomContainer, iAtom, iAtom3, iBond2, nArray, n, blArray, blArray2)) continue;
            bl = true;
            blArray2[iAtomContainer.getBondNumber((IBond)iBond2)] = true;
        }
        this.isVisited[n2] = false;
        if (bl) {
            blArray[n2] = true;
        }
        nArray[0] = nArray[0] - this.numberOfElectrons[n2][0];
        nArray[1] = nArray[1] - this.numberOfElectrons[n2][1];
        return bl;
    }
}

