/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.processors.structure;

import ambit2.base.data.Property;
import ambit2.base.exceptions.AmbitException;
import ambit2.base.interfaces.IStructureRecord;
import ambit2.base.processors.DefaultAmbitProcessor;
import ambit2.core.processors.structure.MoleculeReader;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public abstract class MoleculePairProcessor
extends DefaultAmbitProcessor<IStructureRecord[], IStructureRecord[]> {
    private static final long serialVersionUID = -6601719866474797743L;
    protected MoleculeReader reader = new MoleculeReader();
    protected IAtomContainer[] molecules = new IAtomContainer[]{null, null};
    protected Property smartsProperty = Property.getInstance((String)"SMARTSProp", (String)"SMARTSProp");

    public IStructureRecord[] process(IStructureRecord[] iStructureRecordArray) throws AmbitException {
        try {
            for (int i = 0; i < iStructureRecordArray.length; ++i) {
                this.molecules[i] = this.reader.process(iStructureRecordArray[i]);
                iStructureRecordArray[i].removeProperty(this.smartsProperty);
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)this.molecules[i]);
                CDKHueckelAromaticityDetector.detectAromaticity((IAtomContainer)this.molecules[i]);
            }
            this.process(iStructureRecordArray, this.molecules);
            return iStructureRecordArray;
        }
        catch (AmbitException ambitException) {
            throw ambitException;
        }
        catch (Exception exception) {
            throw new AmbitException((Throwable)exception);
        }
    }

    public abstract IStructureRecord[] process(IStructureRecord[] var1, IAtomContainer[] var2);
}

