/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.processors.structure;

import ambit2.base.exceptions.AmbitException;
import ambit2.base.exceptions.EmptyMoleculeException;
import ambit2.base.log.AmbitLogger;
import ambit2.base.processors.DefaultAmbitProcessor;
import ambit2.core.processors.structure.AtomConfigurator;
import java.util.BitSet;
import org.openscience.cdk.fingerprint.Fingerprinter;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class FingerprintGenerator
extends DefaultAmbitProcessor<IAtomContainer, BitSet> {
    private static final long serialVersionUID = 3905797414723139887L;
    protected static AmbitLogger logger = new AmbitLogger(FingerprintGenerator.class);
    protected int FPLength = 1024;
    protected Fingerprinter fingerprinter;
    protected boolean hydrogens = false;
    protected CDKHydrogenAdder hAdder = null;
    protected AtomConfigurator config = new AtomConfigurator();

    public FingerprintGenerator() {
        this(1024);
    }

    public FingerprintGenerator(int n) {
        this.FPLength = n;
        this.fingerprinter = new Fingerprinter(n);
    }

    public BitSet process(IAtomContainer iAtomContainer) throws AmbitException {
        try {
            if (iAtomContainer == null || iAtomContainer.getAtomCount() == 0) {
                throw new EmptyMoleculeException();
            }
            long l = System.currentTimeMillis();
            IAtomContainer iAtomContainer2 = iAtomContainer;
            if (this.hydrogens) {
                if (this.hAdder == null) {
                    this.hAdder = CDKHydrogenAdder.getInstance((IChemObjectBuilder)SilentChemObjectBuilder.getInstance());
                }
                iAtomContainer2 = (IAtomContainer)iAtomContainer.clone();
                this.hAdder.addImplicitHydrogens(iAtomContainer2);
                AtomContainerManipulator.convertImplicitToExplicitHydrogens((IAtomContainer)iAtomContainer2);
            } else {
                iAtomContainer2 = iAtomContainer.getBondCount() > 1 ? AtomContainerManipulator.removeHydrogensPreserveMultiplyBonded((IAtomContainer)iAtomContainer) : iAtomContainer;
            }
            l = System.currentTimeMillis() - l;
            iAtomContainer.setProperty((Object)"FP_TIME", (Object)new Long(l));
            return this.fingerprinter.getFingerprint(iAtomContainer2);
        }
        catch (AmbitException ambitException) {
            throw ambitException;
        }
        catch (Exception exception) {
            throw new AmbitException("Error generating fingerprint\t", (Throwable)exception);
        }
    }

    public String toString() {
        return "Generates hashed (1024 bits) fingerprints";
    }

    public synchronized int getFPLength() {
        return this.FPLength;
    }

    public synchronized boolean isHydrogens() {
        return this.hydrogens;
    }

    public synchronized void setHydrogens(boolean bl) {
        this.hydrogens = bl;
    }
}

