/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.core.data.MoleculeTools;
import ambit2.core.io.DelimitedFileFormat;
import ambit2.core.io.IteratingDelimitedFileReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.openscience.cdk.MoleculeSet;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.tools.LoggingTool;

public class DelimitedFileReader
extends DefaultChemObjectReader
implements IChemObjectReader {
    protected DelimitedFileFormat format;
    private BufferedReader input = null;
    private static LoggingTool logger = new LoggingTool(DelimitedFileReader.class);

    public DelimitedFileReader(Reader reader, DelimitedFileFormat delimitedFileFormat) {
        logger = new LoggingTool((Object)this);
        this.input = new BufferedReader(reader);
        this.format = delimitedFileFormat;
    }

    public DelimitedFileReader(Reader reader) {
        this(reader, new DelimitedFileFormat());
    }

    public DelimitedFileReader(InputStream inputStream, DelimitedFileFormat delimitedFileFormat) {
        this(new InputStreamReader(inputStream));
        this.format = delimitedFileFormat;
    }

    public DelimitedFileReader(InputStream inputStream) {
        this(new InputStreamReader(inputStream), new DelimitedFileFormat());
    }

    public IChemObject read(IChemObject iChemObject) throws CDKException {
        if (iChemObject instanceof IMoleculeSet) {
            return this.readSetOfMolecules();
        }
        if (iChemObject instanceof IChemFile) {
            IChemFile iChemFile = MoleculeTools.newChemFile(SilentChemObjectBuilder.getInstance());
            IChemSequence iChemSequence = MoleculeTools.newChemSequence(SilentChemObjectBuilder.getInstance());
            IChemModel iChemModel = MoleculeTools.newChemModel(SilentChemObjectBuilder.getInstance());
            iChemModel.setMoleculeSet(this.readSetOfMolecules());
            iChemSequence.addChemModel(iChemModel);
            iChemFile.addChemSequence(iChemSequence);
            return iChemFile;
        }
        throw new CDKException("Only supported is reading of SetOfMolecules objects.");
    }

    private IMoleculeSet readSetOfMolecules() {
        try {
            MoleculeSet moleculeSet = new MoleculeSet();
            IteratingDelimitedFileReader iteratingDelimitedFileReader = new IteratingDelimitedFileReader(this.input, this.format);
            while (iteratingDelimitedFileReader.hasNext()) {
                Object object = iteratingDelimitedFileReader.next();
                if (!(object instanceof IAtomContainer)) continue;
                moleculeSet.addAtomContainer((IAtomContainer)object);
            }
            iteratingDelimitedFileReader.close();
            return moleculeSet;
        }
        catch (Exception exception) {
            logger.error((Object)exception);
            return null;
        }
    }

    public void setReader(Reader reader) throws CDKException {
        this.input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public void setReader(InputStream inputStream) throws CDKException {
        this.setReader(new InputStreamReader(inputStream));
    }

    public IResourceFormat getFormat() {
        return this.format;
    }

    public void close() throws IOException {
        this.input.close();
    }

    public IOSetting[] getIOSettings() {
        return null;
    }

    public String toString() {
        return "Reading compounds from " + this.format.toString();
    }

    public boolean accepts(Class clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (IChemFile.class.equals(classArray[i])) {
                return true;
            }
            if (!IMoleculeSet.class.equals(classArray[i])) continue;
            return true;
        }
        return false;
    }
}

