/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.silent;

import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.silent.AtomContainerSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoleculeSet
extends AtomContainerSet
implements IMoleculeSet,
Cloneable {
    private static final long serialVersionUID = -861287315770869699L;

    @Override
    public void addAtomContainer(IAtomContainer atomContainer) {
        if (!(atomContainer instanceof IMolecule)) {
            throw new IllegalArgumentException("Only IMolecule's can be stored in an IMoleculeSet");
        }
        super.addAtomContainer(atomContainer);
    }

    @Override
    public void addAtomContainer(IAtomContainer atomContainer, double multiplier) {
        if (!(atomContainer instanceof IMolecule)) {
            throw new IllegalArgumentException("Only IMolecule's can be stored in an IMoleculeSet");
        }
        super.addAtomContainer(atomContainer, multiplier);
    }

    @Override
    public void addMolecule(IMolecule molecule) {
        super.addAtomContainer(molecule);
    }

    @Override
    public void add(IMoleculeSet moleculeSet) {
        for (IAtomContainer mol : moleculeSet.molecules()) {
            this.addAtomContainer(mol);
        }
    }

    @Override
    public void setMolecules(IMolecule[] molecules) {
        if (this.atomContainerCount > 0) {
            this.removeAllAtomContainers();
        }
        for (IMolecule molecule : molecules) {
            this.addMolecule(molecule);
        }
    }

    @Override
    public Iterable<IAtomContainer> molecules() {
        return super.atomContainers();
    }

    @Override
    public IMolecule getMolecule(int number) {
        return (IMolecule)super.getAtomContainer(number);
    }

    @Override
    public int getMoleculeCount() {
        return super.getAtomContainerCount();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (MoleculeSet)super.clone();
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("MoleculeSet(");
        buffer.append(super.toString());
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public void stateChanged(IChemObjectChangeEvent event) {
    }
}

