/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.rdf.model.EmptyListException;
import com.hp.hpl.jena.rdf.model.EmptyListUpdateException;
import com.hp.hpl.jena.rdf.model.InvalidListException;
import com.hp.hpl.jena.rdf.model.ListIndexException;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDFListImpl
extends ResourceImpl
implements RDFList {
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                RDFListImpl impl = new RDFListImpl(n, eg);
                if (eg instanceof OntModel) {
                    Profile prof = ((OntModel)((Object)eg)).getProfile();
                    impl.m_listFirst = prof.FIRST();
                    impl.m_listRest = prof.REST();
                    impl.m_listNil = prof.NIL();
                    impl.m_listType = prof.LIST();
                }
                return impl;
            }
            throw new JenaException("Cannot convert node " + n + " to RDFList");
        }

        public boolean canWrap(Node node, EnhGraph eg) {
            Graph g = eg.asGraph();
            Property first = RDF.first;
            Property rest = RDF.rest;
            Resource nil = RDF.nil;
            if (eg instanceof OntModel) {
                Profile prof = ((OntModel)((Object)eg)).getProfile();
                first = prof.FIRST();
                rest = prof.REST();
                nil = prof.NIL();
            }
            return node.equals(nil.asNode()) || g.contains(node, first.asNode(), Node.ANY) || g.contains(node, rest.asNode(), Node.ANY) || g.contains(node, RDF.type.asNode(), RDF.List.asNode());
        }
    };
    protected static boolean s_checkValid = false;
    private static final Logger log = LoggerFactory.getLogger(RDFListImpl.class);
    protected String m_errorMsg = null;
    protected RDFList m_tail = null;
    protected Property m_listFirst = RDF.first;
    protected Property m_listRest = RDF.rest;
    protected Resource m_listNil = RDF.nil;
    protected Resource m_listType = RDF.List;

    public RDFListImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    public Resource listType() {
        return this.m_listType;
    }

    public Resource listNil() {
        return this.m_listNil;
    }

    public Property listFirst() {
        return this.m_listFirst;
    }

    public Property listRest() {
        return this.m_listRest;
    }

    public Class<? extends RDFList> listAbstractionClass() {
        return RDFList.class;
    }

    @Override
    public int size() {
        if (s_checkValid) {
            this.checkValid();
        }
        int size = 0;
        ExtendedIterator<RDFNode> i = this.iterator();
        while (i.hasNext()) {
            ++size;
            i.next();
        }
        return size;
    }

    @Override
    public RDFNode getHead() {
        if (s_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Tried to get the head of an empty list");
        return this.getRequiredProperty(this.listFirst()).getObject();
    }

    @Override
    public RDFNode setHead(RDFNode value) {
        if (s_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Tried to set the head of an empty list");
        Statement current = this.getRequiredProperty(this.listFirst());
        RDFNode n = current.getObject();
        current.remove();
        this.addProperty(this.listFirst(), value);
        return n;
    }

    @Override
    public RDFList getTail() {
        if (s_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Tried to get the tail of an empty list");
        Resource tail = this.getRequiredProperty(this.listRest()).getResource();
        return tail.as(this.listAbstractionClass());
    }

    @Override
    public RDFList setTail(RDFList tail) {
        if (s_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Tried to set the tail of an empty list");
        return RDFListImpl.setTailAux(this, tail, this.listRest()).as(this.listAbstractionClass());
    }

    @Override
    public boolean isEmpty() {
        if (s_checkValid) {
            this.checkValid();
        }
        return this.equals(this.listNil());
    }

    @Override
    public RDFList cons(RDFNode value) {
        if (s_checkValid) {
            this.checkValid();
        }
        return this.newListCell(value, this).as(this.listAbstractionClass());
    }

    @Override
    public void add(RDFNode value) {
        if (s_checkValid) {
            this.checkValid();
        }
        if (this.isEmpty()) {
            throw new EmptyListUpdateException("Attempt to add() to the empty list (rdf:nil)");
        }
        RDFList tail = this.findElement(true, 0);
        RDFListImpl.setTailAux(tail, this.newListCell(value, this.listNil()), this.listRest());
    }

    @Override
    public RDFList with(RDFNode value) {
        if (s_checkValid) {
            this.checkValid();
        }
        if (this.isEmpty()) {
            return this.cons(value);
        }
        RDFList tail = this.findElement(true, 0);
        RDFListImpl.setTailAux(tail, this.newListCell(value, this.listNil()), this.listRest());
        return this;
    }

    @Override
    public RDFNode get(int i) {
        if (s_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Tried to get an element from the empty list");
        return this.findElement(false, i).getHead();
    }

    @Override
    public RDFNode replace(int i, RDFNode value) {
        if (s_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Tried to replace a value in the empty list");
        return this.findElement(false, i).setHead(value);
    }

    @Override
    public boolean contains(RDFNode value) {
        return this.indexOf(value, 0) >= 0;
    }

    @Override
    public int indexOf(RDFNode value) {
        return this.indexOf(value, 0);
    }

    @Override
    public int indexOf(RDFNode value, int start) {
        if (s_checkValid) {
            this.checkValid();
        }
        Resource l = this.findElement(false, start);
        int index = start;
        Property head = this.listFirst();
        Property tail = this.listRest();
        Resource nil = this.listNil();
        boolean found = l.hasProperty(head, value);
        while (!found && !((Object)l).equals(nil)) {
            l = l.getRequiredProperty(tail).getResource();
            ++index;
            found = l.hasProperty(head, value);
        }
        return found ? index : -1;
    }

    @Override
    public RDFList append(Iterator<? extends RDFNode> nodes) {
        return this.append(this.copy(nodes));
    }

    @Override
    public RDFList append(RDFList list) {
        if (s_checkValid) {
            this.checkValid();
        }
        if (this.isEmpty()) {
            return list;
        }
        RDFList copy = this.copy(this.iterator());
        copy.concatenate(list);
        return copy;
    }

    @Override
    public void concatenate(RDFList list) {
        if (s_checkValid) {
            this.checkValid();
        }
        if (this.isEmpty()) {
            throw new EmptyListUpdateException("Tried to concatenate onto the empty list");
        }
        this.findElement(true, 0).setTail(list);
    }

    @Override
    public void concatenate(Iterator<? extends RDFNode> nodes) {
        this.concatenate(this.copy(nodes));
    }

    @Override
    public RDFList copy() {
        if (s_checkValid) {
            this.checkValid();
        }
        return this.copy(this.iterator());
    }

    @Override
    public void apply(RDFList.ApplyFn fn) {
        if (s_checkValid) {
            this.checkValid();
        }
        ExtendedIterator<RDFNode> i = this.iterator();
        while (i.hasNext()) {
            fn.apply((RDFNode)i.next());
        }
    }

    @Override
    public Object reduce(RDFList.ReduceFn fn, Object initial) {
        if (s_checkValid) {
            this.checkValid();
        }
        Object acc = initial;
        ExtendedIterator<RDFNode> i = this.iterator();
        while (i.hasNext()) {
            acc = fn.reduce((RDFNode)i.next(), acc);
        }
        return acc;
    }

    @Override
    public <T> ExtendedIterator<T> mapWith(Map1<RDFNode, T> fn) {
        return this.iterator().mapWith(fn);
    }

    @Override
    public RDFList removeHead() {
        if (s_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Attempted to delete the head of a nil list");
        RDFList tail = this.getTail();
        this.removeProperties();
        return tail;
    }

    @Override
    public RDFList remove(RDFNode val) {
        if (s_checkValid) {
            this.checkValid();
        }
        RDFListImpl prev = null;
        RDFList cell = this;
        boolean searching = true;
        while (searching && !cell.isEmpty()) {
            if (cell.getHead().equals(val)) {
                RDFList tail = cell.getTail();
                if (prev != null) {
                    prev.setTail(tail);
                }
                cell.removeProperties();
                return prev == null ? tail : this;
            }
            prev = cell;
            cell = cell.getTail();
        }
        return this;
    }

    @Override
    @Deprecated
    public void removeAll() {
        this.removeList();
    }

    @Override
    public void removeList() {
        Iterator<Statement> i = this.collectStatements().iterator();
        while (i.hasNext()) {
            i.next().remove();
        }
    }

    public Set<Statement> collectStatements() {
        HashSet<Statement> stmts = new HashSet<Statement>();
        RDFList l = this;
        do {
            StmtIterator i = l.listProperties();
            while (i.hasNext()) {
                stmts.add((Statement)i.next());
            }
        } while (!(l = l.getTail()).isEmpty());
        return stmts;
    }

    @Override
    public ExtendedIterator<RDFNode> iterator() {
        return new RDFListIterator(this);
    }

    @Override
    public List<RDFNode> asJavaList() {
        ArrayList<RDFNode> l = new ArrayList<RDFNode>();
        ExtendedIterator<RDFNode> i = this.iterator();
        while (i.hasNext()) {
            l.add((RDFNode)i.next());
        }
        return l;
    }

    @Override
    public boolean sameListAs(RDFList list) {
        if (s_checkValid) {
            this.checkValid();
        }
        Resource r0 = this;
        Resource r1 = list;
        Property head = this.listFirst();
        Property tail = this.listRest();
        Resource nil = this.listNil();
        while (!((Object)r0).equals(nil) && !r1.equals(nil)) {
            RDFNode n0 = r0.getRequiredProperty(head).getObject();
            RDFNode n1 = r1.getRequiredProperty(head).getObject();
            if (n0 == null || !n0.equals(n1)) {
                return false;
            }
            r0 = r0.getRequiredProperty(tail).getResource();
            r1 = r1.getRequiredProperty(tail).getResource();
        }
        return ((Object)r0).equals(nil) && r1.equals(nil);
    }

    @Override
    public boolean getStrict() {
        return s_checkValid;
    }

    @Override
    public void setStrict(boolean strict) {
        s_checkValid = strict;
    }

    @Override
    public boolean isValid() {
        this.m_errorMsg = null;
        try {
            this.checkValid();
        }
        catch (InvalidListException e) {
            this.m_errorMsg = e.getMessage();
        }
        return this.m_errorMsg == null;
    }

    @Override
    public String getValidityErrorMessage() {
        return this.m_errorMsg;
    }

    public Resource newListCell(RDFNode value, Resource tail) {
        Resource cell = this.getModel().createResource();
        cell.addProperty(this.listFirst(), value);
        cell.addProperty(this.listRest(), tail);
        return cell;
    }

    protected void checkValid() {
        if (!this.equals(this.listNil())) {
            this.checkValidProperty(this.listFirst(), null);
            this.checkValidProperty(this.listRest(), null);
        }
    }

    private void checkValidProperty(Property p, RDFNode expected) {
        int count = 0;
        StmtIterator j = this.getModel().listStatements((Resource)this, p, expected);
        while (j.hasNext()) {
            ++count;
            j.next();
        }
        if (count == 0) {
            if (log.isDebugEnabled()) {
                log.debug("Failed validity check on " + this.toString());
                StmtIterator i = this.listProperties();
                while (i.hasNext()) {
                    log.debug("  this => " + i.next());
                }
                i = this.getModel().listStatements(null, null, this);
                while (i.hasNext()) {
                    log.debug("  => this " + i.next());
                }
            }
            throw new InvalidListException("List node " + this.toString() + " is not valid: it should have property " + p.toString() + (expected == null ? "" : " with value " + expected));
        }
        if (count > 1) {
            throw new InvalidListException("List node " + this.toString() + " is not valid: it has more than one value for " + p.toString());
        }
    }

    protected void checkNotNil(String msg) {
        if (this.isEmpty()) {
            throw new EmptyListException(msg);
        }
    }

    protected RDFList findElement(boolean last, int index) {
        boolean found;
        Property tail = this.listRest();
        Resource nil = this.listNil();
        Resource l = this;
        int i = index;
        boolean bl = found = last && l.hasProperty(tail, nil) || !last && i == 0;
        while (!found && !((Object)l).equals(nil)) {
            l = l.getRequiredProperty(tail).getResource();
            found = last && l.hasProperty(tail, nil) || !last && --i == 0;
        }
        if (!found) {
            if (!last) {
                throw new ListIndexException("Tried to access element " + index + " that is beyond the length of the list");
            }
            throw new InvalidListException("Could not find last element of list (suggests list is not valid)");
        }
        return l.as(this.listAbstractionClass());
    }

    protected RDFList copy(Iterator<? extends RDFNode> i) {
        Resource list = null;
        RDFNode start = null;
        Property head = this.listFirst();
        Property tail = this.listRest();
        Resource cellType = this.listType();
        while (i.hasNext()) {
            Resource cell = this.getModel().createResource(cellType);
            cell.addProperty(head, i.next());
            if (list != null) {
                list.addProperty(tail, cell);
            } else {
                start = cell;
            }
            list = cell;
        }
        list.addProperty(tail, this.listNil());
        return start.as(this.listAbstractionClass());
    }

    protected static Resource setTailAux(Resource root, Resource tail, Property pTail) {
        Statement current = root.getRequiredProperty(pTail);
        Resource oldTail = current.getResource();
        current.remove();
        root.addProperty(pTail, tail);
        return oldTail;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RDFListIterator
    extends NiceIterator<RDFNode> {
        protected RDFList m_head;
        protected RDFList m_seen = null;

        protected RDFListIterator(RDFList head) {
            this.m_head = head;
        }

        @Override
        public boolean hasNext() {
            return !this.m_head.isEmpty();
        }

        @Override
        public RDFNode next() {
            this.m_seen = this.m_head;
            this.m_head = this.m_head.getTail();
            return this.m_seen.getHead();
        }

        @Override
        public void remove() {
            if (this.m_seen == null) {
                throw new IllegalStateException("Illegal remove from list operator");
            }
            this.m_seen.removeProperties();
            this.m_seen = null;
        }
    }
}

