/*
 * Decompiled with CFR 0.152.
 */
package ambit2.smarts.query;

import ambit2.smarts.query.FastSmartsMatcher;
import ambit2.smarts.query.ISmartsPattern;
import ambit2.smarts.query.ISmartsPatternFactory;
import ambit2.smarts.query.SMARTSException;
import ambit2.smarts.query.SmartsPatternAmbit;
import ambit2.smarts.query.SmartsPatternCDK;
import org.openscience.cdk.silent.SilentChemObjectBuilder;

public class SmartsPatternFactory
implements ISmartsPatternFactory {
    protected SmartsParser parserType;

    public SmartsPatternFactory() {
        this.setParserType(SmartsParser.smarts_joelib);
    }

    @Override
    public ISmartsPattern createSmartsPattern(String smarts, boolean negate) throws SMARTSException {
        return SmartsPatternFactory.createSmartsPattern(this.parserType, smarts, negate);
    }

    public static ISmartsPattern createSmartsPattern(SmartsParser parser, String smarts, boolean negate) throws SMARTSException {
        switch (parser) {
            case smarts_cdk: {
                return new SmartsPatternCDK(smarts, negate);
            }
            case smarts_fast: {
                return new FastSmartsMatcher(smarts, negate);
            }
        }
        return new SmartsPatternAmbit(smarts, negate, SilentChemObjectBuilder.getInstance());
    }

    public SmartsParser getParserType() {
        return this.parserType;
    }

    public void setParserType(SmartsParser parserType) {
        this.parserType = parserType;
    }

    public static enum SmartsParser {
        smarts_joelib,
        smarts_cdk,
        smarts_nk,
        smarts_fast;

    }
}

