/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.processors.structure.key;

import ambit2.base.data.Property;
import ambit2.base.exceptions.AmbitException;
import ambit2.base.interfaces.IStructureRecord;
import ambit2.core.data.EINECS;
import ambit2.core.processors.structure.key.PropertyKey;

public class EINECSKey
extends PropertyKey<String> {
    private static final long serialVersionUID = -9098011521397491242L;

    @Override
    protected boolean isValid(Object object, Object object2) {
        return EINECS.isValidFormat(object2.toString());
    }

    @Override
    public boolean isKeyValid(Property property) {
        return property.isEINECS();
    }

    @Override
    public Class getType() {
        return String.class;
    }

    @Override
    public String process(IStructureRecord iStructureRecord) throws AmbitException {
        if (iStructureRecord == null) {
            throw new AmbitException("Empty molecule!");
        }
        if (this.key == null || iStructureRecord.getProperty(this.key) == null) {
            for (Property property : iStructureRecord.getProperties()) {
                Object object;
                if (property.getName().contains("RELATED") || (object = iStructureRecord.getProperty(property)) == null || !this.isKeyValid(property) || !EINECS.isValid(object.toString())) continue;
                this.key = property;
                return object.toString();
            }
        }
        if (this.key == null) {
            throw new AmbitException("EINECS tag not defined");
        }
        Object object = iStructureRecord.getProperty(this.key);
        if (object == null) {
            return null;
        }
        if (EINECS.isValidFormat(object.toString())) {
            return object.toString();
        }
        return null;
    }
}

