/*
 * Decompiled with CFR 0.152.
 */
package signature.chemistry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import signature.AbstractQuotientGraph;
import signature.SymmetryClass;
import signature.chemistry.Molecule;
import signature.chemistry.MoleculeSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoleculeQuotientGraph
extends AbstractQuotientGraph {
    private Molecule molecule;

    public MoleculeQuotientGraph(Molecule molecule) {
        this.molecule = molecule;
        MoleculeSignature molSig = new MoleculeSignature(molecule);
        super.construct(molSig.getSymmetryClasses());
    }

    public MoleculeQuotientGraph(Molecule molecule, List<String> sigStrings) {
        this.molecule = molecule;
        HashMap signatureCounts = new HashMap();
        int i = 0;
        for (String sig : sigStrings) {
            if (!signatureCounts.containsKey(sig)) {
                signatureCounts.put(sig, new ArrayList());
            }
            ((List)signatureCounts.get(sig)).add(i);
            ++i;
        }
        ArrayList<SymmetryClass> symmetryClasses = new ArrayList<SymmetryClass>();
        for (String sig : signatureCounts.keySet()) {
            SymmetryClass symmetryClass = new SymmetryClass(sig);
            Iterator iterator = ((List)signatureCounts.get(sig)).iterator();
            while (iterator.hasNext()) {
                int v = (Integer)iterator.next();
                symmetryClass.addIndex(v);
            }
            symmetryClasses.add(symmetryClass);
        }
        super.construct(symmetryClasses);
    }

    @Override
    public boolean isConnected(int i, int j) {
        return this.molecule.isConnected(i, j);
    }
}

