/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import org.apache.log4j.Logger;
import org.xmlcml.cml.attribute.DelimiterAttribute;
import org.xmlcml.cml.attribute.NamespaceRefAttribute;
import org.xmlcml.cml.base.CMLAttribute;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLType;
import org.xmlcml.cml.base.CMLUtil;
import org.xmlcml.cml.element.AbstractArray;
import org.xmlcml.cml.interfacex.HasArraySize;
import org.xmlcml.cml.interfacex.HasDataType;
import org.xmlcml.cml.interfacex.HasUnits;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.IntArray;
import org.xmlcml.euclid.RealArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMLArray
extends AbstractArray
implements HasUnits,
HasArraySize,
HasDataType {
    static Logger logger = Logger.getLogger(CMLArray.class);
    public static final String NS = "cml:array";
    private DelimiterAttribute delimiterAttribute = null;

    public CMLArray() {
        this.init();
    }

    private void init() {
        this.ensureDelimiterAttribute(DelimiterAttribute.Action.RESET);
    }

    public CMLArray(CMLArray old) {
        super(old);
        this.init();
    }

    @Override
    public Node copy() {
        return new CMLArray(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLArray();
    }

    @Override
    public void finishMakingElement(Element parent) {
        String dataType;
        this.delimiterAttribute = null;
        this.delimiterAttribute = (DelimiterAttribute)this.getDelimiterAttribute();
        int ll = -1;
        int size = -1;
        if (this.getSizeAttribute() != null) {
            String aa = super.getAttributeValue("size");
            size = Integer.parseInt(aa);
        }
        if ((dataType = this.getDataType()).equals("xsd:string")) {
            String[] ss = this.getStrings();
            ll = ss.length;
        } else if ("xsd:double".equals(CMLType.getNormalizedValue(dataType))) {
            try {
                double[] ss = this.getDoubles();
                ll = ss.length;
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Fault in XML: " + this.getXMLContent(), e);
            }
        } else if (dataType.equals("xsd:integer")) {
            try {
                int[] ss = this.getInts();
                ll = ss.length;
            }
            catch (RuntimeException e) {
                throw new RuntimeException("cannot parse as ints: " + this.getXMLContent());
            }
        } else if (dataType.equals("dataTypeType")) {
            String[] ss = this.getStrings();
            ll = ss.length;
        } else if (dataType.equals("namespaceRefType")) {
            String[] ss = this.getStrings();
            ll = ss.length;
        } else if (dataType.equals("unitsType")) {
            String[] ss = this.getStrings();
            ll = ss.length;
        } else {
            throw new RuntimeException("array does  not support dataType: " + dataType);
        }
        if (size != -1 && ll != size) {
            throw new RuntimeException("Size attribute: " + size + " incompatible with content: " + ll);
        }
        if (size != -1) {
            this.resetSize(ll);
        } else {
            this.removeAttribute("size");
        }
    }

    public void ensureDelimiterAttribute(DelimiterAttribute.Action action) {
        if (action.equals((Object)DelimiterAttribute.Action.RESET)) {
            this.delimiterAttribute = null;
        }
        this.delimiterAttribute = (DelimiterAttribute)this.getDelimiterAttribute();
        if (this.delimiterAttribute == null) {
            this.delimiterAttribute = new DelimiterAttribute(" ");
            super.setDelimiter(" ");
        }
    }

    @Override
    public CMLAttribute getDelimiterAttribute() {
        this.delimiterAttribute = (DelimiterAttribute)super.getDelimiterAttribute();
        return this.delimiterAttribute;
    }

    public CMLArray(String[] array) throws RuntimeException {
        this.setArray(array);
    }

    public CMLArray(String[] array, String delimiter) throws RuntimeException {
        this.setDelimiter(delimiter);
        this.setArray(array);
    }

    public CMLArray(double[] array) {
        this.setArray(array);
    }

    public CMLArray(double[] array, String delimiter) throws RuntimeException {
        this.setDelimiter(delimiter);
        this.setArray(array);
    }

    public CMLArray(int[] array) {
        this.setArray(array);
    }

    public CMLArray(int[] array, String delimiter) {
        this.setDelimiter(delimiter);
        this.setArray(array);
    }

    @Override
    public int getArraySize() {
        return this.getSize();
    }

    public Object getPrimitiveArray() {
        Object[] primitiveArray = null;
        primitiveArray = "xsd:double".equals(this.getDataType()) ? this.getDoubles() : ("xsd:integer".equals(this.getDataType()) ? (Object[])this.getInts() : ("xsd:string".equals(this.getDataType()) ? (Object[])this.getStrings() : (Object[])this.getStrings()));
        return primitiveArray;
    }

    public String[] getStrings() {
        String[] ss = null;
        if (this.getDataType().equals("xsd:string")) {
            ss = this.getSplitContent();
        }
        return ss;
    }

    private String[] getSplitContent() throws RuntimeException {
        String[] ss = new String[]{};
        String content = this.getXMLContent();
        if (content != null) {
            content = content.trim();
            this.ensureDelimiterAttribute(DelimiterAttribute.Action.PRESERVE);
            ss = this.delimiterAttribute.getSplitContent(content);
            int size = -1;
            if (this.getSizeAttribute() == null) {
                size = ss.length;
                this.setSize(size);
            } else {
                size = super.getSize();
                if (ss.length != size) {
                    // empty if block
                }
            }
        }
        return ss;
    }

    @Override
    public double[] getDoubles() throws RuntimeException {
        double[] dd = null;
        String dataType = this.getDataType();
        if (dataType != null && "xsd:double".equals(CMLType.getNormalizedValue(dataType))) {
            String[] ss = this.getSplitContent();
            dd = new double[ss.length];
            for (int i = 0; i < dd.length; ++i) {
                try {
                    dd[i] = CMLUtil.parseFlexibleDouble(ss[i]);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new RuntimeException("Bad double :" + ss[i] + " at position: " + i, nfe);
                }
                catch (ParseException e) {
                    throw new RuntimeException("Bad double : " + ss[i] + "at position " + i, e);
                }
            }
        }
        return dd;
    }

    @Override
    public int[] getInts() throws RuntimeException {
        int[] ii = null;
        String dataType = this.getDataType();
        if ("xsd:integer".equals(dataType)) {
            String[] ss = this.getSplitContent();
            ii = new int[ss.length];
            for (int i = 0; i < ii.length; ++i) {
                try {
                    ii[i] = new Integer(ss[i]);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new RuntimeException("Bad int (" + ss[i] + ") at position: " + i);
                }
            }
        }
        return ii;
    }

    @Override
    public List<String> getStringValues() {
        ArrayList<String> values;
        block4: {
            double[] doubles;
            String dataType;
            block5: {
                int[] ints;
                block3: {
                    String[] strings;
                    values = new ArrayList<String>();
                    dataType = this.getDataType();
                    if (dataType != null && !dataType.equals("xsd:string")) break block3;
                    for (String s : strings = this.getStrings()) {
                        values.add(s);
                    }
                    break block4;
                }
                if (!"xsd:integer".equals(dataType)) break block5;
                for (int i : ints = this.getInts()) {
                    values.add("" + i);
                }
                break block4;
            }
            if (!"xsd:double".equals(dataType)) break block4;
            for (double d : doubles = this.getDoubles()) {
                values.add("" + d);
            }
        }
        return values;
    }

    public void setArray(String[] array) throws RuntimeException {
        this.resetDataType("xsd:string");
        this.ensureDelimiterAttribute(DelimiterAttribute.Action.PRESERVE);
        for (String s : array) {
            this.delimiterAttribute.checkDelimiter(s);
        }
        this.setXMLContent(this.delimiterAttribute.getDelimitedXMLContent(array));
        this.resetSize(array.length);
    }

    private void resetDataType(String type) {
        Attribute a = this.getAttribute("dataType");
        if (a != null) {
            this.removeAttribute(a);
        }
        super.setDataType(type);
    }

    private void resetSize(int size) {
        Attribute a = this.getAttribute("size");
        if (a != null) {
            this.removeAttribute(a);
        }
        super.setSize(size);
    }

    public void setArray(double[] array) {
        this.resetDataType("xsd:double");
        this.ensureDelimiterAttribute(DelimiterAttribute.Action.PRESERVE);
        this.setXMLContent(this.delimiterAttribute.getDelimitedXMLContent(array));
        this.resetSize(array.length);
    }

    public void setArray(int[] array) {
        this.resetDataType("xsd:integer");
        this.ensureDelimiterAttribute(DelimiterAttribute.Action.PRESERVE);
        this.setXMLContent(this.delimiterAttribute.getDelimitedXMLContent(array));
        this.resetSize(array.length);
    }

    @Override
    public int getSize() {
        int size = -1;
        if (this.getSizeAttribute() != null) {
            size = super.getSize();
        } else {
            String[] array = this.getSplitContent();
            size = array.length;
        }
        return size;
    }

    @Override
    public String getDelimiter() {
        String delimiter = super.getDelimiter();
        if (delimiter == null) {
            this.ensureDelimiterAttribute(DelimiterAttribute.Action.RESET);
            delimiter = this.delimiterAttribute.getValue();
        }
        return delimiter;
    }

    @Override
    public void setDelimiter(String value) {
        this.ensureDelimiterAttribute(DelimiterAttribute.Action.RESET);
        super.setDelimiter(value);
        this.delimiterAttribute = (DelimiterAttribute)this.getDelimiterAttribute();
    }

    @Override
    public String getDataType() {
        String dataType = super.getDataType();
        if (dataType == null) {
            dataType = "xsd:string";
            super.setDataType(dataType);
        }
        return CMLType.getNormalizedValue(dataType);
    }

    @Override
    public void setDataType(String dType) {
        if (this.getDataTypeAttribute() != null) {
            throw new RuntimeException("Cannot reset dataType");
        }
        super.setDataType(dType);
    }

    @Override
    public void setSize(int s) {
        if (this.getSizeAttribute() != null) {
            throw new RuntimeException("user cannot reset size");
        }
        super.setSize(s);
    }

    public void checkNumericConformability(CMLArray array) {
        if (this.getDataType().equals("xsd:string") || !this.getDataType().equals(array.getDataType()) || this.getSize() != array.getSize()) {
            throw new RuntimeException("Unsuitable dataTypes for numeric operations / " + this.getDataType() + "/" + this.getSize() + "/" + array.getDataType() + "/" + array.getSize());
        }
    }

    public CMLArray subtract(CMLArray array) {
        this.checkNumericConformability(array);
        CMLArray resultArray = null;
        try {
            if (this.getDataType().equals("xsd:double")) {
                RealArray result = new RealArray(array.getDoubles()).subtract(new RealArray(this.getDoubles()));
                resultArray = new CMLArray(result.getArray());
            } else if (this.getDataType().equals("xsd:integer")) {
                IntArray result = new IntArray(array.getInts()).subtract(new IntArray(this.getInts()));
                resultArray = new CMLArray(result.getArray());
            }
        }
        catch (EuclidRuntimeException je) {
            throw new RuntimeException("" + je);
        }
        return resultArray;
    }

    public CMLArray plus(CMLArray array) {
        this.checkNumericConformability(array);
        CMLArray resultArray = null;
        try {
            if (this.getDataType().equals("xsd:double")) {
                RealArray result = new RealArray(this.getDoubles()).plus(new RealArray(array.getDoubles()));
                resultArray = new CMLArray(result.getArray());
            } else if (this.getDataType().equals("xsd:integer")) {
                IntArray result = new IntArray(this.getInts()).plus(new IntArray(array.getInts()));
                resultArray = new CMLArray(result.getArray());
            }
        }
        catch (EuclidRuntimeException je) {
            throw new RuntimeException("" + je);
        }
        return resultArray;
    }

    public void append(String s) throws RuntimeException {
        String dataType = this.getDataType();
        if (!"xsd:string".equals(dataType)) {
            throw new RuntimeException("Cannot add string (" + s + ") to array of: " + dataType);
        }
        this.appendXML(s);
    }

    public void append(double d) throws RuntimeException {
        String dataType = this.getDataType();
        if (!"xsd:double".equals(dataType)) {
            throw new RuntimeException("Cannot add double to array of: " + dataType);
        }
        this.appendXML("" + d);
    }

    public void append(int i) throws RuntimeException {
        String dataType = this.getDataType();
        if (!"xsd:integer".equals(dataType)) {
            throw new RuntimeException("Cannot add int to array of: " + dataType);
        }
        this.appendXML("" + i);
    }

    private void appendXML(String s) {
        int size = this.getSizeAttribute() == null ? 0 : this.getSize();
        this.ensureDelimiterAttribute(DelimiterAttribute.Action.PRESERVE);
        this.delimiterAttribute.checkDelimiter(s);
        String xmlContent = this.getXMLContent();
        String delimitedContent = this.delimiterAttribute.appendXMLContent(xmlContent, s);
        this.setXMLContent(delimitedContent);
        this.resetSize(size + 1);
    }

    @Override
    public void setUnits(String prefix, String id, String namespaceURI) {
        NamespaceRefAttribute.setUnits(this, prefix, id, namespaceURI);
    }
}

