/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.CrystalGeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.CIFFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.io.CIFReaderTest")
public class CIFReader
extends DefaultChemObjectReader {
    private BufferedReader input;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(CIFReader.class);
    private ICrystal crystal = null;
    private double a = 0.0;
    private double b = 0.0;
    private double c = 0.0;
    private double alpha = 0.0;
    private double beta = 0.0;
    private double gamma = 0.0;

    public CIFReader(Reader input) {
        this.input = new BufferedReader(input);
    }

    public CIFReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public CIFReader() {
        this(new StringReader(""));
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return CIFFormat.getInstance();
    }

    @Override
    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader reader) throws CDKException {
        this.input = new BufferedReader(this.input);
    }

    @Override
    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class testClass) {
        if (IChemFile.class.equals((Object)testClass)) {
            return true;
        }
        Class<?>[] interfaces = testClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!IChemFile.class.equals(interfaces[i])) continue;
            return true;
        }
        Class superClass = testClass.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IChemFile) {
            IChemFile cf = (IChemFile)object;
            try {
                cf = this.readChemFile(cf);
            }
            catch (IOException e) {
                logger.error("Input/Output error while reading from input.");
            }
            return (T)cf;
        }
        throw new CDKException("Only supported is reading of ChemFile.");
    }

    private IChemFile readChemFile(IChemFile file) throws IOException {
        IChemSequence seq = file.getBuilder().newInstance(IChemSequence.class, new Object[0]);
        IChemModel model = file.getBuilder().newInstance(IChemModel.class, new Object[0]);
        this.crystal = file.getBuilder().newInstance(ICrystal.class, new Object[0]);
        String line = this.input.readLine();
        boolean end_found = false;
        while (this.input.ready() && line != null && !end_found) {
            if (line.startsWith("#")) {
                logger.warn("Skipping comment: " + line);
            } else if (line.length() == 0) {
                logger.debug("Skipping empty line");
            } else if (!line.startsWith("_") && !line.startsWith("loop_")) {
                logger.warn("Skipping unrecognized line: " + line);
            } else {
                String command;
                block18: {
                    command = "";
                    int spaceIndex = line.indexOf(" ");
                    if (spaceIndex != -1) {
                        try {
                            command = new String(line.substring(0, spaceIndex));
                            break block18;
                        }
                        catch (StringIndexOutOfBoundsException sioobe) {
                            break;
                        }
                    }
                    command = line;
                }
                logger.debug("command: " + command);
                if (command.startsWith("_cell")) {
                    this.processCellParameter(command, line);
                } else if (command.equals("loop_")) {
                    this.processLoopBlock();
                } else if (command.equals("_symmetry_space_group_name_H-M")) {
                    String value = line.substring(29).trim();
                    this.crystal.setSpaceGroup(value);
                } else {
                    logger.warn("Skipping command: " + command);
                    line = this.input.readLine();
                    if (line.startsWith(";")) {
                        logger.debug("Skipping block content");
                        line = this.input.readLine().trim();
                        while (!line.equals(";")) {
                            line = this.input.readLine().trim();
                            logger.debug("Skipping block line: " + line);
                        }
                        line = this.input.readLine();
                    }
                }
            }
            line = this.input.readLine();
        }
        logger.info("Adding crystal to file with #atoms: " + this.crystal.getAtomCount());
        model.setCrystal(this.crystal);
        seq.addChemModel(model);
        file.addChemSequence(seq);
        return file;
    }

    private void processCellParameter(String command, String line) {
        if ((command = command.substring(6)).equals("length_a")) {
            String value = line.substring(14).trim();
            this.a = this.parseIntoDouble(value);
            this.possiblySetCellParams(this.a, this.b, this.c, this.alpha, this.beta, this.gamma);
        } else if (command.equals("length_b")) {
            String value = line.substring(14).trim();
            this.b = this.parseIntoDouble(value);
            this.possiblySetCellParams(this.a, this.b, this.c, this.alpha, this.beta, this.gamma);
        } else if (command.equals("length_c")) {
            String value = line.substring(14).trim();
            this.c = this.parseIntoDouble(value);
            this.possiblySetCellParams(this.a, this.b, this.c, this.alpha, this.beta, this.gamma);
        } else if (command.equals("angle_alpha")) {
            String value = line.substring(17).trim();
            this.alpha = this.parseIntoDouble(value);
            this.possiblySetCellParams(this.a, this.b, this.c, this.alpha, this.beta, this.gamma);
        } else if (command.equals("angle_beta")) {
            String value = line.substring(16).trim();
            this.beta = this.parseIntoDouble(value);
            this.possiblySetCellParams(this.a, this.b, this.c, this.alpha, this.beta, this.gamma);
        } else if (command.equals("angle_gamma")) {
            String value = line.substring(17).trim();
            this.gamma = this.parseIntoDouble(value);
            this.possiblySetCellParams(this.a, this.b, this.c, this.alpha, this.beta, this.gamma);
        }
    }

    private void possiblySetCellParams(double a, double b, double c, double alpha, double beta, double gamma) {
        if (a != 0.0 && b != 0.0 && c != 0.0 && alpha != 0.0 && beta != 0.0 && gamma != 0.0) {
            logger.info("Found and set crystal cell parameters");
            Vector3d[] axes = CrystalGeometryTools.notionalToCartesian(a, b, c, alpha, beta, gamma);
            this.crystal.setA(axes[0]);
            this.crystal.setB(axes[1]);
            this.crystal.setC(axes[2]);
        }
    }

    private void processLoopBlock() throws IOException {
        String line = this.input.readLine().trim();
        if (line.startsWith("_atom")) {
            logger.info("Found atom loop block");
            this.processAtomLoopBlock(line);
        } else {
            logger.warn("Skipping loop block");
            this.skipUntilEmptyOrCommentLine(line);
        }
    }

    private void skipUntilEmptyOrCommentLine(String line) throws IOException {
        while (line != null && line.length() > 0 && line.charAt(0) != '#') {
            line = this.input.readLine().trim();
        }
    }

    private void processAtomLoopBlock(String firstLine) throws IOException {
        int atomLabel = -1;
        int atomSymbol = -1;
        int atomFractX = -1;
        int atomFractY = -1;
        int atomFractZ = -1;
        int atomRealX = -1;
        int atomRealY = -1;
        int atomRealZ = -1;
        String line = firstLine.trim();
        int headerCount = 0;
        boolean hasParsableInformation = false;
        while (line != null && line.charAt(0) == '_') {
            ++headerCount;
            if (line.equals("_atom_site_label") || line.equals("_atom_site_label_atom_id")) {
                atomLabel = headerCount;
                hasParsableInformation = true;
                logger.info("label found in col: " + atomLabel);
            } else if (line.startsWith("_atom_site_fract_x")) {
                atomFractX = headerCount;
                hasParsableInformation = true;
                logger.info("frac x found in col: " + atomFractX);
            } else if (line.startsWith("_atom_site_fract_y")) {
                atomFractY = headerCount;
                hasParsableInformation = true;
                logger.info("frac y found in col: " + atomFractY);
            } else if (line.startsWith("_atom_site_fract_z")) {
                atomFractZ = headerCount;
                hasParsableInformation = true;
                logger.info("frac z found in col: " + atomFractZ);
            } else if (line.equals("_atom_site.Cartn_x")) {
                atomRealX = headerCount;
                hasParsableInformation = true;
                logger.info("cart x found in col: " + atomRealX);
            } else if (line.equals("_atom_site.Cartn_y")) {
                atomRealY = headerCount;
                hasParsableInformation = true;
                logger.info("cart y found in col: " + atomRealY);
            } else if (line.equals("_atom_site.Cartn_z")) {
                atomRealZ = headerCount;
                hasParsableInformation = true;
                logger.info("cart z found in col: " + atomRealZ);
            } else if (line.equals("_atom_site.type_symbol")) {
                atomSymbol = headerCount;
                hasParsableInformation = true;
                logger.info("type_symbol found in col: " + atomSymbol);
            } else {
                logger.warn("Ignoring atom loop block field: " + line);
            }
            line = this.input.readLine().trim();
        }
        if (!hasParsableInformation) {
            logger.info("No parsable info found");
            this.skipUntilEmptyOrCommentLine(line);
        } else {
            while (line != null && line.length() > 0 && line.charAt(0) != '#') {
                logger.debug("new row");
                StringTokenizer tokenizer = new StringTokenizer(line);
                if (tokenizer.countTokens() < headerCount) {
                    logger.warn("Column count mismatch; assuming continued on next line");
                    logger.debug("Found #expected, #found: " + headerCount + ", " + tokenizer.countTokens());
                    tokenizer = new StringTokenizer(line + this.input.readLine());
                }
                int colIndex = 0;
                IAtom atom = this.crystal.getBuilder().newInstance(IAtom.class, "C");
                Point3d frac = new Point3d();
                Point3d real = new Point3d();
                boolean hasFractional = false;
                boolean hasCartesian = false;
                while (tokenizer.hasMoreTokens()) {
                    String field = tokenizer.nextToken();
                    logger.debug("Parsing col,token: " + ++colIndex + "=" + field);
                    if (colIndex == atomLabel) {
                        if (atomSymbol == -1) {
                            String element = this.extractFirstLetters(field);
                            atom.setSymbol(element);
                        }
                        atom.setID(field);
                        continue;
                    }
                    if (colIndex == atomFractX) {
                        hasFractional = true;
                        frac.x = this.parseIntoDouble(field);
                        continue;
                    }
                    if (colIndex == atomFractY) {
                        hasFractional = true;
                        frac.y = this.parseIntoDouble(field);
                        continue;
                    }
                    if (colIndex == atomFractZ) {
                        hasFractional = true;
                        frac.z = this.parseIntoDouble(field);
                        continue;
                    }
                    if (colIndex == atomSymbol) {
                        atom.setSymbol(field);
                        continue;
                    }
                    if (colIndex == atomRealX) {
                        hasCartesian = true;
                        logger.debug("Adding x3: " + this.parseIntoDouble(field));
                        real.x = this.parseIntoDouble(field);
                        continue;
                    }
                    if (colIndex == atomRealY) {
                        hasCartesian = true;
                        logger.debug("Adding y3: " + this.parseIntoDouble(field));
                        real.y = this.parseIntoDouble(field);
                        continue;
                    }
                    if (colIndex != atomRealZ) continue;
                    hasCartesian = true;
                    logger.debug("Adding x3: " + this.parseIntoDouble(field));
                    real.z = this.parseIntoDouble(field);
                }
                if (hasCartesian) {
                    Vector3d a = this.crystal.getA();
                    Vector3d b = this.crystal.getB();
                    Vector3d c = this.crystal.getC();
                    frac = CrystalGeometryTools.cartesianToFractional(a, b, c, real);
                    atom.setFractionalPoint3d(frac);
                }
                if (hasFractional) {
                    atom.setFractionalPoint3d(frac);
                }
                logger.debug("Adding atom: " + atom);
                this.crystal.addAtom(atom);
                line = this.input.readLine().trim();
            }
        }
    }

    private double parseIntoDouble(String value) {
        int bracketIndex;
        double returnVal = 0.0;
        if (value.charAt(0) == '.') {
            value = "0" + value;
        }
        if ((bracketIndex = value.indexOf("(")) != -1) {
            value = value.substring(0, bracketIndex);
        }
        try {
            returnVal = Double.parseDouble(value);
        }
        catch (Exception exception) {
            logger.error("Could not parse double string: " + value);
        }
        return returnVal;
    }

    private String extractFirstLetters(String value) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < value.length() && !Character.isDigit(value.charAt(i)); ++i) {
            result.append(value.charAt(i));
        }
        return result.toString();
    }

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.input.close();
    }
}

