/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.listener;

import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.ReaderEvent;
import org.openscience.cdk.io.listener.IReaderListener;
import org.openscience.cdk.io.listener.IWriterListener;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.io.setting.OptionIOSetting;
import org.openscience.cdk.io.setting.StringIOSetting;

public class SwingGUIListener
implements IReaderListener,
IWriterListener {
    private Component frame = null;
    private int level = 0;

    public SwingGUIListener(Component frame, int level) {
        this.level = level;
        this.frame = frame;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void frameRead(ReaderEvent event) {
    }

    public void processIOSettingQuestion(IOSetting setting) {
        if (setting.getLevel() < this.level) {
            String answer = setting.getSetting();
            if (setting instanceof BooleanIOSetting) {
                int n = JOptionPane.showConfirmDialog(this.frame, setting.getQuestion(), setting.getName(), 0);
                if (n == 0) {
                    answer = "true";
                } else if (n == 1) {
                    answer = "false";
                }
            } else if (setting instanceof OptionIOSetting) {
                OptionIOSetting optionSetting = (OptionIOSetting)setting;
                List<String> settings = optionSetting.getOptions();
                Iterator<String> elements = settings.iterator();
                Object[] options = new Object[settings.size()];
                for (int i = 0; i < options.length; ++i) {
                    options[i] = elements.next();
                }
                int n = JOptionPane.showOptionDialog(this.frame, setting.getQuestion(), setting.getName(), -1, 3, null, options, setting.getSetting());
                answer = (String)options[n];
            } else {
                answer = setting instanceof StringIOSetting ? JOptionPane.showInputDialog(this.frame, setting.getQuestion(), setting.getName(), 3, null, null, setting.getSetting()).toString() : JOptionPane.showInputDialog(this.frame, setting.getQuestion(), setting.getName(), 3, null, null, setting.getSetting()).toString();
            }
            try {
                setting.setSetting(answer);
            }
            catch (CDKException cDKException) {
                // empty catch block
            }
        }
    }
}

