/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.processors.structure.key;

import ambit2.base.exceptions.AmbitException;
import ambit2.base.processors.DefaultAmbitProcessor;
import ambit2.core.processors.structure.InchiProcessor;
import ambit2.core.processors.structure.key.IStructureKey;
import java.util.Iterator;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;

public class InchiKey
extends DefaultAmbitProcessor<IAtomContainer, String>
implements IStructureKey<IAtomContainer, String> {
    private static final long serialVersionUID = -4957862884677389524L;
    protected InchiProcessor inchi = new InchiProcessor();
    protected Object key;

    @Override
    public Object getKey() {
        return this.key;
    }

    public void setKey(Object object) {
        this.key = object;
    }

    public String process(IAtomContainer iAtomContainer) throws AmbitException {
        if (iAtomContainer.getAtomCount() > 0) {
            try {
                return this.inchi.process(iAtomContainer).getInchi();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Iterator iterator = iAtomContainer.getProperties().keySet().iterator();
        while (iterator.hasNext()) {
            Object v = iAtomContainer.getProperties().get(iterator.next());
            if (!v.toString().startsWith("InChI=")) continue;
            return v.toString();
        }
        return null;
    }

    @Override
    public Object getQueryKey() {
        return "inchi";
    }

    @Override
    public Class getType() {
        return String.class;
    }
}

