/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.smiles.smarts.SMARTSQueryTool;

public class CrippenDescriptor
implements IMolecularDescriptor {
    public static final String[] names = new String[]{"CrippenLogP", "CrippenMR"};
    private static String[] fragments = new String[]{"[$([CH4]),$([CH3]C),$([CH2](C)C)]", "[$([CH](C)(C)C),$([C](C)(C)(C)C)]", "[$([CH3][N,O,S,F,Cl,Br,I]),$([CH2X4][N,O,S,F,Cl,Br,I])]", "[$([CH1X4][N,O,S,F,Cl,Br,I]),$([CH0X4][N,O,S,F,Cl,Br,I])]", "[C]=[!C;A;!#1]", "[C;A]=C", "[CX2]#[A;!#1]", "[CH3]c", "[CH3]a", "[CH2X4]a", "[CHX4]a", "[CH0X4]a", "[cH0]-[A;!C;!N;!O;!S;!F;!Cl;!Br;!I;!H]", "[c][#9]", "[c][#17]", "[c][#35]", "[c][#53]", "[cH]", "[c](:a)(:a):a", "[c](:a)(:a)-a", "[c](:a)(:a)-C", "[c](:a)(:a)-N", "[c](:a)(:a)-O", "[c](:a)(:a)-S", "[c](:a)(:a)=[C,N,O]", "[$([C](=C)(a)[A;!#1]),$([C](=C)(c)a),$([C](=C)a),$([C]=c)]", "[CX4][A;!C;!N;!O;!S;!F;!Cl;!Br;!I;!#1]", "[#6]", "[#1][#6,#1]", "[$([#1]O[CX4,c]),$([#1]O[!C;!N;!O;!S]),$([#1][!C;!N;!O])]", "[$([#1][#7]),$([#1]O[#7])]", "[$([#1]OC=[#6,#7,O,S]),$([#1]O[O,S])]", "[#1]", "[NH2+0][A;!#1]", "[NH+0]([A;!#1])[A;!#1]", "[NH2+0]a", "[NH1+0]([!#1;A,a])a", "[NH+0]=[!#1;A,a]", "[N+0](=[!#1;A,a])[!#1;A,a]", "[N+0]([A;!#1])([A;!#1])[A;!#1]", "[$([N+0](a)([!#1;A,a])[A;!#1]),$([N+0](a)(a)a)]", "[N+0]#[A;!#1]", "[NH3,NH2,NH;+,+2,+3]", "[n+0]", "[n;+,+2,+3]", "[$([NH0;+,+2,+3]([A;!#1])([A;!#1])([A;!#1])[A;!#1]),$([NH0;+,+2,+3](=[A;#1])([A;#1])[!#1;A,a]),$([NH0;+,+2,+3](=[#6])=[#7])]", "[$([N;+,+2,+3]#[A;!#1]),$([N;-,-2,-3]),$([N;+,+2,+3](=[N;-,-2,-3])=N)]", "[#7]", "[o]", "[OH,OH2]", "[O]([A;!#1])[A;!#1]", "[O](a)[!#1;A,a]", "[$([O]=[#7,#8]),$([OX1;-,-2,-3][#7])]", "[OX1;-,-2,-2][#16]", "[O-]C(=O)", "[OX1;-,-2,-3][!#1;!N;!S]", "[O]=c", "[$([O]=[CH]C),$([O]=C(C)([A;!#1])),$([O]=[CH][N,O]),$([O]=[CH2]),$([O]=[CX2]=O)]", "[$([O]=[CH]c),$([O]=C([C,c])[a;!#1]),$([O]=C(c)[A;!#1])]", "[O]=C([!#1;!#6])[!#1;!#6]", "[#8]", "[#9-0]", "[#17-0]", "[#35-0]", "[#53-0]", "[$([#9,#17,#35,#53;-]),$([#53;+,+2,+3]),$([+;#3,#11,#19,#37,#55])]", "[#15]", "[S;-,-2,-3,-4,+1,+2,+3,+5,+6]", "[S;A]", "[s;a]", "[#3,#11,#19,#37,#55,#4,#12,#20,#38,#56,#5,#13,#31,#49,#81,#14,#32,#50,#82,#33,#51,#83,#34,#52,#84]", "[#21,#22,#23,#24,#25,#26,#27,#28,#29,#30,#39,#40,#41,#42,#43,#44,#45,#46,#47,#48,#72,#73,#74,#75,#76,#77,#78,#79,#80]"};
    private static double[] logp = new double[]{0.1441, 0.0, -0.2035, -0.2051, -0.2783, 0.1551, 0.0017, 0.08452, -0.1444, -0.0516, 0.1193, -0.0967, -0.5443, 0.0, 0.245, 0.198, 0.0, 0.1581, 0.2955, 0.2713, 0.136, 0.4619, 0.5437, 0.1893, -0.8186, 0.264, 0.2148, 0.08129, 0.123, -0.2677, 0.2142, 0.298, 0.1125, -1.019, -0.7096, -1.027, -0.5188, 0.08387, 0.1836, -0.3187, -0.4458, 0.01508, -1.95, -0.3239, -1.119, -0.3396, 0.2887, -0.4806, 0.1552, -0.2893, -0.0684, -0.4195, 0.0335, -0.3339, -1.326, -1.189, 0.1788, -0.1526, 0.1129, 0.4833, -0.1188, 0.4202, 0.6895, 0.8456, 0.8857, -2.996, 0.8612, -0.0024, 0.6482, 0.6237, -0.3808, -0.0025};
    private static double[] mr = new double[]{2.503, 2.433, 2.753, 2.731, 5.007, 3.513, 3.888, 2.464, 2.412, 2.488, 2.582, 2.576, 4.041, 3.257, 3.564, 3.18, 3.104, 3.35, 4.346, 3.904, 3.509, 4.067, 3.853, 2.673, 3.135, 4.305, 2.693, 3.243, 1.057, 1.395, 0.9627, 1.805, 1.112, 2.262, 2.173, 2.827, 3.0, 1.757, 2.428, 1.839, 2.819, 1.725, 0.0, 2.202, 0.0, 0.2604, 3.359, 2.134, 1.08, 0.8238, 1.085, 1.182, 3.367, 0.7774, 0.0, 0.0, 3.135, 0.0, 0.2215, 0.389, 0.6865, 1.108, 5.853, 8.927, 14.02, 0.0, 6.92, 7.365, 7.591, 6.691, 5.754, 0.0};

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("Crippen", this.getClass().getName(), "$Id: CrippenDescriptor.java 1 2012-03-16 16:00:00Z yapchunwei $", "PaDEL");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception exception) {
        int n = this.getDescriptorNames().length;
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult(n);
        for (int i = 0; i < n; ++i) {
            doubleArrayResult.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames(), exception);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        try {
            int n;
            SMARTSQueryTool sMARTSQueryTool = new SMARTSQueryTool("C");
            int n2 = fragments.length;
            double d = 0.0;
            double d2 = 0.0;
            boolean[] blArray = new boolean[iAtomContainer.getAtomCount()];
            int n3 = iAtomContainer.getAtomCount();
            for (n = 0; n < n3; ++n) {
                blArray[n] = false;
            }
            for (n = 0; n < n2; ++n) {
                sMARTSQueryTool.setSmarts(fragments[n]);
                if (sMARTSQueryTool.matches(iAtomContainer)) {
                    List<List<Integer>> list = sMARTSQueryTool.getUniqueMatchingAtoms();
                    for (List<Integer> list2 : list) {
                        boolean bl = false;
                        for (Integer n4 : list2) {
                            if (blArray[n4]) continue;
                            blArray[n4.intValue()] = true;
                            bl = true;
                            break;
                        }
                        if (!bl) continue;
                        d += logp[n];
                        d2 += mr[n];
                    }
                }
                n3 = 1;
                int n5 = iAtomContainer.getAtomCount();
                for (int i = 0; i < n5; ++i) {
                    if (blArray[i]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 != 0) break;
            }
            DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
            doubleArrayResult.add(d);
            doubleArrayResult.add(d2);
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, names);
        }
        catch (Exception exception) {
            return this.getDummyDescriptorValue(new CDKException("Error in SMARTSQueryTool: " + exception.getMessage()));
        }
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(names.length);
    }
}

