/*
 * Decompiled with CFR 0.152.
 */
package signature.simple;

import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import signature.display.TreeDrawer;
import signature.simple.SimpleGraph;
import signature.simple.SimpleGraphFactory;
import signature.simple.SimpleQuotientGraph;

public class SimpleQuotientGraphTest {
    public void draw(SimpleQuotientGraph quotientGraph) {
        String directoryPath = "tmp4";
        List<String> signatureStrings = quotientGraph.getVertexSignatureStrings();
        int w = 1200;
        int h = 400;
        TreeDrawer.makeTreeImages(signatureStrings, directoryPath, w, h);
    }

    public void check3Regularity(SimpleGraph graph) {
        System.out.println(graph);
        int i = 0;
        while (i < graph.getVertexCount()) {
            Assert.assertEquals((String)("failed for " + i), (int)3, (int)graph.degree(i));
            ++i;
        }
    }

    public void check4Regularity(SimpleGraph graph) {
        System.out.println(graph);
        int i = 0;
        while (i < graph.getVertexCount()) {
            Assert.assertEquals((String)("failed for " + i), (int)4, (int)graph.degree(i));
            ++i;
        }
    }

    public void checkParameters(SimpleQuotientGraph qGraph, int expectedVertexCount, int expectedEdgeCount, int expectedLoopEdgeCount) {
        System.out.println(qGraph);
        Assert.assertEquals((int)expectedVertexCount, (int)qGraph.getVertexCount());
        Assert.assertEquals((int)expectedEdgeCount, (int)qGraph.getEdgeCount());
        Assert.assertEquals((int)expectedLoopEdgeCount, (int)qGraph.numberOfLoopEdges());
    }

    @Test
    public void fourRegularExampleTest() {
        SimpleGraph fourRegular = SimpleGraphFactory.makeFourRegularExample();
        this.check4Regularity(fourRegular);
        SimpleQuotientGraph qgraph = new SimpleQuotientGraph(fourRegular);
        this.checkParameters(qgraph, 1, 1, 1);
    }

    @Test
    public void petersensGraphTest() {
        SimpleGraph petersens = SimpleGraphFactory.makePetersensGraph();
        SimpleQuotientGraph quotientGraph = new SimpleQuotientGraph(petersens);
        this.checkParameters(quotientGraph, 1, 1, 1);
    }

    @Test
    public void pappusGraphTest() {
        SimpleGraph pappus = SimpleGraphFactory.makePappusGraph();
        SimpleQuotientGraph quotientGraph = new SimpleQuotientGraph(pappus);
        this.checkParameters(quotientGraph, 1, 1, 1);
    }

    @Test
    public void triangularPrismTest() {
        SimpleGraph pentaprism = SimpleGraphFactory.makePrism(3);
        SimpleQuotientGraph quotientGraph = new SimpleQuotientGraph(pentaprism);
        this.checkParameters(quotientGraph, 1, 1, 1);
    }

    @Test
    public void cubeTest() {
        SimpleGraph cube = SimpleGraphFactory.makePrism(4);
        SimpleQuotientGraph quotientGraph = new SimpleQuotientGraph(cube);
        this.checkParameters(quotientGraph, 1, 1, 1);
    }

    @Test
    public void pentagonalPrismTest() {
        SimpleGraph pentaprism = SimpleGraphFactory.makePrism(5);
        SimpleQuotientGraph quotientGraph = new SimpleQuotientGraph(pentaprism);
        this.checkParameters(quotientGraph, 1, 1, 1);
    }

    @Test
    public void truncatedTetrahedronTest() {
        SimpleGraph truncatedTetrahedron = SimpleGraphFactory.makeTruncatedTetrahedron();
        SimpleQuotientGraph quotientGraph = new SimpleQuotientGraph(truncatedTetrahedron);
        this.checkParameters(quotientGraph, 1, 1, 1);
    }

    @Test
    public void adamantaneTest() {
        SimpleGraph adamantane = SimpleGraphFactory.makeAdamantane();
        SimpleQuotientGraph quotientGraph = new SimpleQuotientGraph(adamantane);
        this.checkParameters(quotientGraph, 2, 1, 0);
    }

    @Test
    public void triangleSandwichTest() {
        SimpleGraph triangle = SimpleGraphFactory.makeSandwich(3);
        SimpleQuotientGraph quotientGraph = new SimpleQuotientGraph(triangle);
        this.checkParameters(quotientGraph, 2, 2, 1);
    }

    @Test
    public void squareSandwichTest() {
        SimpleGraph square = SimpleGraphFactory.makeSandwich(4);
        SimpleQuotientGraph quotientGraph = new SimpleQuotientGraph(square);
        this.checkParameters(quotientGraph, 2, 2, 1);
    }

    @Test
    public void pentagonalSandwichTest() {
        SimpleGraph pentagon = SimpleGraphFactory.makeSandwich(5);
        SimpleQuotientGraph quotientGraph = new SimpleQuotientGraph(pentagon);
        this.checkParameters(quotientGraph, 2, 2, 1);
    }

    @Test
    public void hexagonalSandwichTest() {
        SimpleGraph hexagon = SimpleGraphFactory.makeSandwich(6);
        SimpleQuotientGraph quotientGraph = new SimpleQuotientGraph(hexagon);
        this.checkParameters(quotientGraph, 2, 2, 1);
    }

    @Test
    public void spiroPentagonTest() {
        SimpleGraph spiroPentagons = SimpleGraphFactory.makeSpiroPentagons();
        SimpleQuotientGraph quotientGraph = new SimpleQuotientGraph(spiroPentagons);
        this.checkParameters(quotientGraph, 3, 3, 1);
    }

    @Test
    public void threeFourFiveTwistedGraphTest() {
        SimpleGraph threeFourFive = SimpleGraphFactory.makeThreeFourFiveTwisted();
        SimpleQuotientGraph quotientGraph = new SimpleQuotientGraph(threeFourFive);
        this.checkParameters(quotientGraph, 3, 3, 1);
    }

    @Test
    public void twistaneTest() {
        SimpleGraph twistane = SimpleGraphFactory.makeTwistane();
        SimpleQuotientGraph quotientGraph = new SimpleQuotientGraph(twistane);
        this.checkParameters(quotientGraph, 3, 4, 2);
    }

    @Test
    public void napthaleneTest() {
        SimpleGraph napthalene = SimpleGraphFactory.makeNapthalene();
        SimpleQuotientGraph quotientGraph = new SimpleQuotientGraph(napthalene);
        this.checkParameters(quotientGraph, 3, 4, 2);
    }

    @Test
    public void tietzesGraphTest() {
        SimpleGraph tietzes = SimpleGraphFactory.makeTietzesGraph();
        SimpleQuotientGraph quotientGraph = new SimpleQuotientGraph(tietzes);
        this.checkParameters(quotientGraph, 3, 4, 2);
    }

    @Test
    public void cuneaneTest() {
        SimpleGraph cuneane = SimpleGraphFactory.makeCuneane();
        SimpleQuotientGraph quotientGraph = new SimpleQuotientGraph(cuneane);
        this.checkParameters(quotientGraph, 3, 5, 3);
    }

    @Test
    public void squareQuotientGraphTest() {
        SimpleGraph squareQuotientGraph = SimpleGraphFactory.makeSquareQuotientGraph();
        SimpleQuotientGraph quotientGraph = new SimpleQuotientGraph(squareQuotientGraph);
        this.checkParameters(quotientGraph, 4, 4, 0);
    }

    @Test
    public void doubleBridgedPentagonTest() {
        SimpleGraph g = SimpleGraphFactory.makeDoubleBridgedPentagon();
        SimpleQuotientGraph quotientGraph = new SimpleQuotientGraph(g);
        this.checkParameters(quotientGraph, 4, 5, 1);
    }

    @Test
    public void bowtieaneQuotientGraphTest() {
        SimpleGraph bowtieane = SimpleGraphFactory.makeBowtieane();
        SimpleQuotientGraph quotientGraph = new SimpleQuotientGraph(bowtieane);
        this.checkParameters(quotientGraph, 4, 5, 2);
    }

    @Test
    public void fullerene26Test() {
        SimpleGraph fullerene26 = SimpleGraphFactory.make26Fullerene();
        this.check3Regularity(fullerene26);
        SimpleQuotientGraph quotientGraph = new SimpleQuotientGraph(fullerene26);
        this.checkParameters(quotientGraph, 4, 5, 2);
    }

    @Test
    public void diSpiroOctaneQuotientGraphTest() {
        SimpleGraph diSpiroOctane = SimpleGraphFactory.makeDiSpiroOctane();
        SimpleQuotientGraph quotientGraph = new SimpleQuotientGraph(diSpiroOctane);
        this.checkParameters(quotientGraph, 5, 6, 1);
    }

    @Test
    public void tricycloPropaIndeneQuotientGraphTest() {
        SimpleGraph tricycloPropaIndene = SimpleGraphFactory.makeTricycloPropaIndene();
        SimpleQuotientGraph quotientGraph = new SimpleQuotientGraph(tricycloPropaIndene);
        this.checkParameters(quotientGraph, 6, 8, 2);
    }
}

