/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import libpadeldescriptor.PaDELLogFile;
import libpadeldescriptor.libPaDELDescriptorJob;
import libpadeldescriptor.libPaDELDescriptorType;
import libpadeldescriptor.libPaDELDescriptorWorker;
import libpadeljobs.Master;
import org.openscience.cdk.interfaces.IAtomContainer;

public class libPaDELDescriptorMasterGeneral
extends Master<libPaDELDescriptorJob, libPaDELDescriptorWorker> {
    private ArrayList<IAtomContainer> mols;
    private boolean compute2D = false;
    private boolean compute3D = false;
    private boolean computeFingerprints = false;
    private boolean removeSalt = true;
    private boolean detectAromaticity = true;
    private boolean standardizeTautomers = true;
    private boolean standardizeNitro = true;
    private boolean retain3D = false;
    private boolean convertTo3D = false;
    private ArrayList<List<String>> results;
    private String logFile;
    private String forcefield = "mm2";
    private String[] tautomerList;
    private boolean logResults = false;
    private long maxRunTime = -1L;
    private int curMolIndex = -1;
    private int molProcessed = 0;
    private PaDELLogFile log;
    private long startTime;
    private long endTime;
    private int maxMolecules = -1;
    private List<String> descriptorNames;
    private Set<String> descriptorTypes;
    private String molName;
    private IAtomContainer molStructure;

    public libPaDELDescriptorMasterGeneral(ArrayList<IAtomContainer> arrayList, ArrayList<List<String>> arrayList2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, String string) {
        this.mols = arrayList;
        this.results = arrayList2;
        this.compute2D = bl;
        this.compute3D = bl2;
        this.computeFingerprints = bl3;
        this.removeSalt = bl4;
        this.detectAromaticity = bl5;
        this.standardizeTautomers = bl6;
        this.standardizeNitro = bl7;
        this.retain3D = bl8;
        this.convertTo3D = bl9;
        this.logFile = string;
        this.descriptorNames = new ArrayList<String>();
        this.log = new PaDELLogFile();
    }

    public void SetDescriptorTypes(String string) throws Exception {
        this.descriptorTypes = libPaDELDescriptorType.GetActiveDescriptorTypes(string, this.compute2D, this.compute3D, this.computeFingerprints);
        libPaDELDescriptorType.SetDescriptorTypes(this.descriptorTypes, this.descriptorNames, null, null, null);
    }

    public void SetDescriptorTypes(InputStream inputStream) throws Exception {
        this.descriptorTypes = libPaDELDescriptorType.GetActiveDescriptorTypes(inputStream, this.compute2D, this.compute3D, this.computeFingerprints);
        libPaDELDescriptorType.SetDescriptorTypes(this.descriptorTypes, this.descriptorNames, null, null, null);
    }

    public void SetDescriptorTypes(Set<String> set) {
        this.descriptorTypes = set;
        libPaDELDescriptorType.SetDescriptorTypes(set, this.descriptorNames, null, null, null);
    }

    public void setTautomerList(String[] stringArray) {
        this.tautomerList = stringArray;
    }

    public void setForcefield(String string) {
        this.forcefield = string;
    }

    public void setLogResults(boolean bl) {
        this.logResults = bl;
    }

    public void setMaxRunTime(long l) {
        this.maxRunTime = l;
    }

    public String Initialize() {
        int n;
        super.Initialize();
        this.startTime = System.nanoTime();
        this.maxMolecules = this.mols.size();
        String string = this.log.Open(this.logFile, this.logResults);
        if (string != null) {
            return string;
        }
        this.results.clear();
        this.results.add(this.descriptorNames);
        ArrayList arrayList = new ArrayList();
        int n2 = this.maxMolecules;
        for (n = 0; n < n2; ++n) {
            this.results.add(arrayList);
        }
        this.curMolIndex = -1;
        this.molProcessed = 0;
        for (n = 0; n < this.maxThreads; ++n) {
            libPaDELDescriptorWorker libPaDELDescriptorWorker2 = new libPaDELDescriptorWorker(this, n, (LinkedBlockingQueue<libPaDELDescriptorJob>)this.jobsWaiting, (LinkedBlockingQueue<libPaDELDescriptorJob>)this.jobsRunning, (LinkedBlockingQueue<libPaDELDescriptorJob>)this.jobsCompleted, this.descriptorTypes);
            libPaDELDescriptorWorker2.start();
            this.workers.add(libPaDELDescriptorWorker2);
        }
        return null;
    }

    private boolean hasNextJob() {
        if (++this.curMolIndex < this.maxMolecules) {
            this.molName = (String)this.mols.get(this.curMolIndex).getProperty("cdk:Title");
            this.molStructure = this.mols.get(this.curMolIndex);
            return true;
        }
        return false;
    }

    private libPaDELDescriptorJob nextJob() {
        libPaDELDescriptorJob libPaDELDescriptorJob2 = new libPaDELDescriptorJob(this.curMolIndex + 1, null, this.molName, this.molStructure, this.removeSalt, this.detectAromaticity, this.standardizeTautomers, this.tautomerList, this.standardizeNitro, this.retain3D, this.convertTo3D, this.forcefield, this.maxRunTime);
        return libPaDELDescriptorJob2;
    }

    public void AddJobsToQueue() {
        int n = this.maxJobsWaiting - this.jobsWaiting.size();
        libPaDELDescriptorJob libPaDELDescriptorJob2 = new libPaDELDescriptorJob(NO_MORE_JOBS);
        for (int i = 0; i < n; ++i) {
            try {
                if (this.hasNextJob()) {
                    libPaDELDescriptorJob2 = this.nextJob();
                    this.jobsWaiting.put(libPaDELDescriptorJob2);
                    continue;
                }
                for (int j = 0; j < this.workers.size() * 2; ++j) {
                    this.jobsWaiting.offer(new libPaDELDescriptorJob(NO_MORE_JOBS));
                }
                break;
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger("global").log(Level.SEVERE, Integer.toString(libPaDELDescriptorJob2.getId()), interruptedException);
            }
        }
    }

    public void ProcessRunningJobs() {
        this.status = this.clearMessages();
        if (!this.status.isEmpty()) {
            this.log.Write(this.status);
        }
    }

    public void ProcessCompletedJobs() {
        libPaDELDescriptorJob libPaDELDescriptorJob2;
        while ((libPaDELDescriptorJob2 = (libPaDELDescriptorJob)((Object)this.jobsCompleted.poll())) != null) {
            ++this.molProcessed;
            this.results.set(libPaDELDescriptorJob2.getId(), libPaDELDescriptorJob2.getDescriptors());
            if (this.jobsWaiting.size() >= this.maxJobsWaiting / 10 || this.curMolIndex >= this.maxMolecules) continue;
            return;
        }
        boolean bl = true;
        for (libPaDELDescriptorWorker libPaDELDescriptorWorker2 : this.workers) {
            if (!libPaDELDescriptorWorker2.isAlive()) continue;
            bl = false;
        }
        if (this.molProcessed == this.maxMolecules) {
            this.endTime = System.nanoTime();
            long l = this.endTime - this.startTime;
            String string = this.TimeTaken(this.startTime, this.endTime);
            double d = (double)l / 1.0E9 / (double)this.molProcessed;
            this.status = "Descriptor calculation completed in " + string + ". Average speed: " + new DecimalFormat("#0.00").format(d) + " s/mol.";
            this.log.Write(this.status + "\n");
            this.log.Close();
            this.hasWork = false;
            this.StopAllWorkers();
        } else if (bl) {
            this.endTime = System.nanoTime();
            this.status = "All workers stopped for unknown reason.";
            this.log.Write(this.status + "\n");
            this.log.Close();
            this.hasWork = false;
        } else if (this.jobsCompleted.isEmpty()) {
            try {
                libPaDELDescriptorJob2 = (libPaDELDescriptorJob)((Object)this.jobsCompleted.poll(1L, TimeUnit.SECONDS));
                if (libPaDELDescriptorJob2 != null) {
                    ++this.molProcessed;
                    this.results.set(libPaDELDescriptorJob2.getId(), libPaDELDescriptorJob2.getDescriptors());
                }
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger("global").log(Level.SEVERE, Integer.toString(libPaDELDescriptorJob2.getId()), interruptedException);
            }
        }
    }

    public void StopAllWorkers() {
        super.StopAllWorkers();
        if (this.workers == null || this.jobsWaiting == null) {
            return;
        }
        for (int i = 0; i < this.workers.size() * 2; ++i) {
            this.jobsWaiting.offer(new libPaDELDescriptorJob(NO_MORE_JOBS));
        }
    }

    public List<String> getDescriptorNames() {
        return this.descriptorNames;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public int getMolProcessed() {
        return this.molProcessed;
    }

    public int GetMaxMolecules() {
        if (this.maxMolecules == -1) {
            this.maxMolecules = this.mols.size();
        }
        return this.maxMolecules;
    }

    private String TimeTaken(long l, long l2) {
        long l3 = l2 - l;
        int n = (int)(((double)l3 / 1.0E9 - (double)((int)((double)l3 / 1.0E9))) * 1000.0);
        int n2 = (int)((double)l3 / 1.0E9 % 60.0);
        int n3 = (int)((double)l3 / 1.0E9 / 60.0 % 60.0);
        int n4 = (int)((double)l3 / 1.0E9 / 60.0 / 60.0 % 24.0);
        int n5 = (int)((double)l3 / 1.0E9 / 60.0 / 60.0 / 24.0 % 7.0);
        int n6 = (int)((double)l3 / 1.0E9 / 60.0 / 60.0 / 24.0 / 7.0);
        StringBuffer stringBuffer = new StringBuffer();
        if (n6 > 0) {
            stringBuffer.append(n6 + " weeks ");
        }
        if (n5 > 0) {
            stringBuffer.append(n5 + " days ");
        }
        if (n4 > 0) {
            stringBuffer.append(n4 + " hours ");
        }
        if (n3 > 0) {
            stringBuffer.append(n3 + " mins ");
        }
        stringBuffer.append(n2 + "." + n + " secs ");
        return stringBuffer.toString();
    }
}

