/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.StandardSubstructureSets;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.smiles.smarts.SMARTSQueryTool;

public class SubstructureFingerprintCount
implements IMolecularDescriptor {
    private String[] names;
    private String[] smarts;

    public SubstructureFingerprintCount() {
        try {
            this.smarts = StandardSubstructureSets.getFunctionalGroupSMARTS();
        }
        catch (Exception exception) {
            this.smarts = null;
        }
    }

    public SubstructureFingerprintCount(String[] stringArray) {
        this.smarts = stringArray;
    }

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("SubstructureCount", this.getClass().getName(), "$Id: SubstructureCountDescriptor.java 1 2010-05-01 22:05:01Z yapchunwei $", "PaDEL");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return this.names;
    }

    public void setDescriptorNames(String[] stringArray) {
        this.names = stringArray;
    }

    private DescriptorValue getDummyDescriptorValue(Exception exception) {
        int n = this.getDescriptorNames().length;
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult(n);
        for (int i = 0; i < n; ++i) {
            doubleArrayResult.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames(), exception);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        if (this.smarts == null) {
            return this.getDummyDescriptorValue(new CDKException("No substructures were defined"));
        }
        try {
            DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
            SMARTSQueryTool sMARTSQueryTool = new SMARTSQueryTool("C");
            for (int i = 0; i < this.smarts.length; ++i) {
                String string = this.smarts[i];
                sMARTSQueryTool.setSmarts(string);
                if (sMARTSQueryTool.matches(iAtomContainer)) {
                    doubleArrayResult.add(sMARTSQueryTool.getUniqueMatchingAtoms().size());
                    continue;
                }
                doubleArrayResult.add(0.0);
            }
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.names);
        }
        catch (Exception exception) {
            return this.getDummyDescriptorValue(new CDKException("Error in SMARTSQueryTool: " + exception.getMessage()));
        }
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(this.names.length);
    }
}

