/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import nu.xom.DocType;
import nu.xom.Element;
import nu.xom.IllegalAddException;
import nu.xom.MultipleParentException;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.WellformednessException;

public class Document
extends ParentNode {
    public Document(Element root) {
        this._insertChild(root, 0);
    }

    public Document(Document doc) {
        this.insertChild(doc.getRootElement().copy(), 0);
        int count = doc.getChildCount();
        for (int i = 0; i < count; ++i) {
            Node child = doc.getChild(i);
            if (child.isElement()) continue;
            this.insertChild(child.copy(), i);
        }
        this.actualBaseURI = doc.actualBaseURI;
    }

    final void insertionAllowed(Node child, int position) {
        if (child == null) {
            throw new NullPointerException("Tried to insert a null child in the document");
        }
        if (child.getParent() != null) {
            throw new MultipleParentException("Child already has a parent.");
        }
        if (child.isComment() || child.isProcessingInstruction()) {
            return;
        }
        if (child.isDocType()) {
            if (position <= this.getRootPosition()) {
                DocType oldDocType = this.getDocType();
                if (oldDocType != null) {
                    throw new IllegalAddException("Tried to insert a second DOCTYPE");
                }
                return;
            }
            throw new IllegalAddException("Cannot add a document type declaration after the root element");
        }
        if (child.isElement()) {
            if (this.getChildCount() == 0) {
                return;
            }
            throw new IllegalAddException("Cannot add a second root element to a Document.");
        }
        throw new IllegalAddException("Cannot add a " + child.getClass().getName() + " to a Document.");
    }

    private int getRootPosition() {
        int i = 0;
        Node child;
        while (!(child = this.getChild(i)).isElement()) {
            ++i;
        }
        return i;
    }

    public final DocType getDocType() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Node child = this.getChild(i);
            if (!child.isDocType()) continue;
            return (DocType)child;
        }
        return null;
    }

    public void setDocType(DocType doctype) {
        DocType oldDocType = this.getDocType();
        if (doctype == null) {
            throw new NullPointerException("Null DocType");
        }
        if (doctype == oldDocType) {
            return;
        }
        if (doctype.getParent() != null) {
            throw new MultipleParentException("DocType belongs to another document");
        }
        if (oldDocType == null) {
            this.insertChild(doctype, 0);
        } else {
            int position = this.indexOf(oldDocType);
            super.removeChild(position);
            this.fastInsertChild(doctype, position);
            oldDocType.setParent(null);
            doctype.setParent(this);
        }
    }

    public final Element getRootElement() {
        int i = 0;
        Node child;
        while (!(child = this.getChild(i)).isElement()) {
            ++i;
        }
        return (Element)child;
    }

    public void setRootElement(Element root) {
        Element oldRoot = this.getRootElement();
        if (root == oldRoot) {
            return;
        }
        if (root == null) {
            throw new NullPointerException("Root element cannot be null");
        }
        if (root.getParent() != null) {
            throw new MultipleParentException(root.getQualifiedName() + " already has a parent");
        }
        this.fillInBaseURI(oldRoot);
        int index = this.indexOf(oldRoot);
        oldRoot.setParent(null);
        this.children[index] = root;
        root.setParent(this);
    }

    public void setBaseURI(String URI) {
        this.setActualBaseURI(URI);
    }

    public final String getBaseURI() {
        return this.getActualBaseURI();
    }

    public Node removeChild(int position) {
        if (position == this.getRootPosition()) {
            throw new WellformednessException("Cannot remove the root element");
        }
        return super.removeChild(position);
    }

    public Node removeChild(Node child) {
        if (child == this.getRootElement()) {
            throw new WellformednessException("Cannot remove the root element");
        }
        return super.removeChild(child);
    }

    public void replaceChild(Node oldChild, Node newChild) {
        if (oldChild == this.getRootElement() && newChild != null && newChild.isElement()) {
            this.setRootElement((Element)newChild);
        } else if (oldChild == this.getDocType() && newChild != null && newChild.isDocType()) {
            this.setDocType((DocType)newChild);
        } else {
            super.replaceChild(oldChild, newChild);
        }
    }

    public final String getValue() {
        return this.getRootElement().getValue();
    }

    public final String toXML() {
        StringBuffer result = new StringBuffer();
        result.append("<?xml version=\"1.0\"?>\n");
        for (int i = 0; i < this.getChildCount(); ++i) {
            result.append(this.getChild(i).toXML());
            result.append("\n");
        }
        return result.toString();
    }

    public Node copy() {
        return new Document(this);
    }

    boolean isDocument() {
        return true;
    }

    public final String toString() {
        return "[" + this.getClass().getName() + ": " + this.getRootElement().getQualifiedName() + "]";
    }
}

