/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

class SimpleTokenizer {
    private String delimiter;
    private boolean singleDelimiter;
    private char maxDelimiter;
    private List tokens;
    protected String text;
    protected int position;
    protected int maxPosition;

    public SimpleTokenizer(String string, String string2) {
        this(string, string2, false);
    }

    public SimpleTokenizer(String string, String string2, boolean bl) {
        this.setText(string);
        this.setDelimiter(string2);
        this.singleDelimiter = bl;
    }

    public void setText(String string) {
        this.text = string;
        this.position = 0;
        this.maxPosition = string.length();
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
        this.maxDelimiter = '\u0000';
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (this.maxDelimiter >= c) continue;
            this.maxDelimiter = c;
        }
    }

    public boolean hasMoreTokens() {
        return this.position <= this.maxPosition;
    }

    public String nextToken() {
        if (this.position > this.maxPosition) {
            throw new NoSuchElementException();
        }
        if (this.position == this.maxPosition) {
            ++this.position;
            return "";
        }
        return this.parseToken();
    }

    protected String parseToken() {
        if (this.singleDelimiter || this.delimiter.length() == 1) {
            return this.parseUsingSingleDelimiter();
        }
        return this.parseUsingMultipleDelimiters();
    }

    private String parseUsingSingleDelimiter() {
        String string = null;
        int n = 0;
        n = this.delimiter.length() == 1 ? this.text.indexOf(this.delimiter.charAt(0), this.position) : this.text.indexOf(this.delimiter, this.position);
        if (n == -1) {
            string = this.text.substring(this.position, this.maxPosition);
            this.position = this.maxPosition + 1;
        } else {
            string = this.text.substring(this.position, n);
            this.position = n + this.delimiter.length();
        }
        return string;
    }

    private String parseUsingMultipleDelimiters() {
        String string = null;
        int n = this.position;
        boolean bl = true;
        while (this.position < this.maxPosition) {
            char c = this.text.charAt(this.position);
            if (c <= this.maxDelimiter && this.delimiter.indexOf(c) >= 0) {
                bl = false;
                break;
            }
            ++this.position;
        }
        if (bl) {
            string = this.text.substring(n, this.maxPosition);
            this.position = this.maxPosition + 1;
        } else {
            string = this.text.substring(n, this.position);
            ++this.position;
        }
        return string;
    }

    public String nextToken(int n) {
        while (--n > 0) {
            this.nextToken();
        }
        return this.nextToken();
    }

    public String getRemainder() {
        return this.hasMoreTokens() ? this.text.substring(this.position) : "";
    }

    public List getAllTokens() {
        this.tokens = new ArrayList();
        while (this.hasMoreTokens()) {
            this.tokens.add(this.nextToken());
        }
        return this.tokens;
    }

    public static void main(String[] stringArray) {
        SimpleTokenizer simpleTokenizer = new SimpleTokenizer(stringArray[1], stringArray[0], true);
        while (simpleTokenizer.hasMoreTokens()) {
            System.out.print(":");
            System.out.print(simpleTokenizer.nextToken());
            System.out.println(":");
        }
    }
}

