/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.GraphAdd;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.FragmentTripleIterator;
import com.hp.hpl.jena.graph.impl.Fragments;
import com.hp.hpl.jena.graph.impl.GraphAddList;
import com.hp.hpl.jena.graph.impl.ReifierFragmentHandler;
import com.hp.hpl.jena.graph.impl.ReifierFragmentsMap;
import com.hp.hpl.jena.graph.impl.SimpleReifierFragmentHandler;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleReifierFragmentsMap
implements ReifierFragmentsMap {
    protected Map<Node, Fragments> forwardMap = CollectionFactory.createHashedMap();
    protected static final Fragments.GetSlot TYPES_index = new Fragments.GetSlot(){

        @Override
        public Set<Node> get(Fragments f) {
            return f.types;
        }
    };
    protected static final Fragments.GetSlot SUBJECTS_index = new Fragments.GetSlot(){

        @Override
        public Set<Node> get(Fragments f) {
            return f.subjects;
        }
    };
    protected static final Fragments.GetSlot OBJECTS_index = new Fragments.GetSlot(){

        @Override
        public Set<Node> get(Fragments f) {
            return f.objects;
        }
    };
    protected static final Fragments.GetSlot PREDICATES_index = new Fragments.GetSlot(){

        @Override
        public Set<Node> get(Fragments f) {
            return f.predicates;
        }
    };
    protected final ReifierFragmentHandler TYPES = new SimpleReifierFragmentHandler(this, TYPES_index){

        public boolean clashesWith(ReifierFragmentsMap map, Node n, Triple reified) {
            return false;
        }
    };
    protected final ReifierFragmentHandler SUBJECTS = new SimpleReifierFragmentHandler(this, SUBJECTS_index){

        public boolean clashesWith(ReifierFragmentsMap map, Node n, Triple reified) {
            return !n.equals(reified.getSubject());
        }
    };
    protected final ReifierFragmentHandler PREDICATES = new SimpleReifierFragmentHandler(this, PREDICATES_index){

        public boolean clashesWith(ReifierFragmentsMap map, Node n, Triple reified) {
            return !n.equals(reified.getPredicate());
        }
    };
    protected final ReifierFragmentHandler OBJECTS = new SimpleReifierFragmentHandler(this, OBJECTS_index){

        public boolean clashesWith(ReifierFragmentsMap map, Node n, Triple reified) {
            return !n.equals(reified.getObject());
        }
    };
    public final Map<Node, ReifierFragmentHandler> selectors = this.makeSelectors();

    protected Fragments getFragments(Node tag) {
        return this.forwardMap.get(tag);
    }

    protected void removeFragments(Node key) {
        this.forwardMap.remove(key);
    }

    @Override
    public void clear() {
        this.forwardMap.clear();
    }

    protected Fragments putFragments(Node key, Fragments value) {
        this.forwardMap.put(key, value);
        return value;
    }

    protected ExtendedIterator<Triple> allTriples(TripleMatch tm) {
        if (this.forwardMap.isEmpty()) {
            return NullIterator.instance();
        }
        Triple t = tm.asTriple();
        Node subject = t.getSubject();
        if (subject.isConcrete()) {
            Fragments x = this.forwardMap.get(subject);
            return x == null ? NullIterator.instance() : this.explodeFragments(t, subject, x);
        }
        Iterator<Map.Entry<Node, Fragments>> it = this.forwardMap.entrySet().iterator();
        return new FragmentTripleIterator<Fragments>(t, it){

            @Override
            public void fill(GraphAdd ga, Node n, Fragments fragmentsObject) {
                fragmentsObject.includeInto(ga);
            }
        };
    }

    protected ExtendedIterator<Triple> explodeFragments(Triple t, Node subject, Fragments x) {
        GraphAddList L = new GraphAddList(t);
        x.includeInto(L);
        return WrappedIterator.create(L.iterator());
    }

    @Override
    public ExtendedIterator<Triple> find(TripleMatch m) {
        return this.allTriples(m);
    }

    @Override
    public int size() {
        int result = 0;
        for (Map.Entry<Node, Fragments> e : this.forwardMap.entrySet()) {
            result += e.getValue().size();
        }
        return result;
    }

    @Override
    public ReifierFragmentHandler getFragmentHandler(Triple t) {
        Node p = t.getPredicate();
        ReifierFragmentHandler x = this.selectors.get(p);
        if (x == null || p.equals(RDF.Nodes.type) && !t.getObject().equals(RDF.Nodes.Statement)) {
            return null;
        }
        return x;
    }

    public void putAugmentedTriple(SimpleReifierFragmentHandler s, Node tag, Node object, Triple reified) {
        Fragments partial = new Fragments(tag, reified);
        partial.add(s, object);
        this.putFragments(tag, partial);
    }

    protected Triple reifyCompleteQuad(SimpleReifierFragmentHandler s, Triple fragment, Node tag, Node object) {
        Fragments partial = this.getFragments(tag);
        if (partial == null) {
            partial = new Fragments(tag);
            this.putFragments(tag, partial);
        }
        partial.add(s, object);
        if (partial.isComplete()) {
            this.removeFragments(fragment.getSubject());
            return partial.asTriple();
        }
        return null;
    }

    protected Triple removeFragment(SimpleReifierFragmentHandler s, Node tag, Triple already, Triple fragment) {
        Fragments partial = this.getFragments(tag);
        Fragments fs = already != null ? this.explode(tag, already) : (partial == null ? this.putFragments(tag, new Fragments(tag)) : partial);
        fs.remove(s, fragment.getObject());
        if (fs.isComplete()) {
            Triple result = fs.asTriple();
            this.removeFragments(tag);
            return result;
        }
        if (fs.isEmpty()) {
            this.removeFragments(tag);
        }
        return null;
    }

    protected Fragments explode(Node s, Triple t) {
        return this.putFragments(s, new Fragments(s, t));
    }

    @Override
    public boolean hasFragments(Node tag) {
        return this.getFragments(tag) != null;
    }

    protected Map<Node, ReifierFragmentHandler> makeSelectors() {
        Map<Node, ReifierFragmentHandler> result = CollectionFactory.createHashedMap();
        result.put(RDF.Nodes.subject, this.SUBJECTS);
        result.put(RDF.Nodes.predicate, this.PREDICATES);
        result.put(RDF.Nodes.object, this.OBJECTS);
        result.put(RDF.Nodes.type, this.TYPES);
        return result;
    }
}

