/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.labelling;

import java.util.Random;

public class Permutor {
    private int currentRank = 0;
    private int maxRank;
    private int size;
    private Random random;

    public Permutor(int size) {
        this.size = size;
        this.maxRank = this.calculateMaxRank();
        this.random = new Random();
    }

    public boolean hasNext() {
        return this.currentRank < this.maxRank;
    }

    public void setRank(int rank) {
        this.currentRank = rank;
    }

    public int getRank() {
        return this.currentRank;
    }

    public void setPermutation(int[] permutation) {
        this.currentRank = this.rankPermutationLexicographically(permutation) - 1;
    }

    public int[] getRandomNextPermutation() {
        int d = this.maxRank - this.currentRank;
        int r = this.random.nextInt(d);
        this.currentRank += Math.max(1, r);
        return this.getCurrentPermutation();
    }

    public int[] getNextPermutation() {
        ++this.currentRank;
        return this.getCurrentPermutation();
    }

    public int[] getCurrentPermutation() {
        return this.unrankPermutationLexicographically(this.currentRank, this.size);
    }

    public int calculateMaxRank() {
        return this.factorial(this.size) - 1;
    }

    private int factorial(int i) {
        if (i > 0) {
            return i * this.factorial(i - 1);
        }
        return 1;
    }

    private int rankPermutationLexicographically(int[] permutation) {
        int rank = 0;
        int n = permutation.length;
        int[] counter = new int[n + 1];
        System.arraycopy(permutation, 0, counter, 1, n);
        for (int j = 1; j <= n; ++j) {
            rank += (counter[j] - 1) * this.factorial(n - j);
            for (int i = j + 1; i < n; ++i) {
                if (counter[i] <= counter[j]) continue;
                int n2 = i;
                counter[n2] = counter[n2] - 1;
            }
        }
        return rank;
    }

    private int[] unrankPermutationLexicographically(int rank, int size) {
        int[] permutation = new int[size + 1];
        permutation[size] = 1;
        for (int j = 1; j < size; ++j) {
            int d = rank % this.factorial(j + 1) / this.factorial(j);
            rank -= d * this.factorial(j);
            permutation[size - j] = d + 1;
            for (int i = size - j + 1; i <= size; ++i) {
                if (permutation[i] <= d) continue;
                int n = i;
                permutation[n] = permutation[n] + 1;
            }
        }
        int[] shiftedPermutation = new int[size];
        for (int i = 1; i < permutation.length; ++i) {
            shiftedPermutation[i - 1] = permutation[i] - 1;
        }
        return shiftedPermutation;
    }
}

