/*
 * Decompiled with CFR 0.152.
 */
package ambit2.smarts;

import ambit2.smarts.ChemObjectFactory;
import ambit2.smarts.ChemObjectToSmiles;
import ambit2.smarts.IsomorphismTester;
import ambit2.smarts.SmartsParser;
import ambit2.smarts.SmartsToChemObject;
import java.util.Vector;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;

public class StructureSetAnalyzer {
    public Vector<IAtomContainer> structures = new Vector();
    public double factor = 0.5;
    public Vector<CharStructInfo> charStructInfo = new Vector();
    public int hitListSize = 100;
    public int maxSizeOfSequence = 0;
    public int maxHitStructSize = 0;
    SmartsParser sp = new SmartsParser();
    IsomorphismTester isoTester = new IsomorphismTester();
    ChemObjectToSmiles cots = new ChemObjectToSmiles();
    ChemObjectFactory cof;
    SmartsToChemObject stco;
    int maxStructSize;
    double minSQI;
    int minSQIPos;

    public StructureSetAnalyzer(IChemObjectBuilder builder) {
        this.stco = new SmartsToChemObject(builder);
        this.cof = new ChemObjectFactory(builder);
    }

    void setMaxStructSize() {
        this.maxStructSize = 0;
        for (int i = 0; i < this.structures.size(); ++i) {
            int curSize = this.structures.get(i).getAtomCount();
            if (this.maxStructSize >= curSize) continue;
            this.maxStructSize = curSize;
        }
    }

    public void mcsAnalysis() {
        this.charStructInfo.clear();
        for (int i = 0; i < this.structures.size() - 1; ++i) {
            for (int j = i + 1; j < this.structures.size(); ++j) {
            }
        }
    }

    public void stochasticAnalysis() {
        this.minSQI = 0.0;
        this.minSQIPos = -1;
        this.charStructInfo.clear();
        for (int i = 0; i < this.structures.size(); ++i) {
            System.out.println("Processing str. " + (i + 1) + "       nAtoms = " + this.structures.get(i).getAtomCount());
            this.processStructureStochasticalty(this.structures.get(i));
        }
    }

    void processStructureStochasticalty(IAtomContainer mol) {
        block0: for (int k = 0; k < mol.getAtomCount(); ++k) {
            this.cof.setAtomSequence(mol, mol.getAtom(k));
            int n = this.cof.sequence.size();
            if (this.maxSizeOfSequence > 0 && n > this.maxSizeOfSequence) {
                n = this.maxSizeOfSequence;
            }
            for (int i = 0; i < n; ++i) {
                IAtomContainer struct = this.cof.getFragmentFromSequence(i);
                if (this.maxHitStructSize > 0 && struct.getAtomCount() > this.maxHitStructSize) continue block0;
                String smiles = this.cots.getSMILES(struct);
                if (this.checkForDuplication(smiles)) continue;
                this.registerNewStruct(struct, smiles);
            }
        }
    }

    boolean checkForDuplication(String smarts) {
        QueryAtomContainer query = this.sp.parse(smarts);
        this.sp.setNeededDataFlags();
        this.isoTester.setQuery(query);
        for (int i = 0; i < this.charStructInfo.size(); ++i) {
            CharStructInfo s = this.charStructInfo.get(i);
            if (query.getAtomCount() != s.atomCount || query.getBondCount() != s.bondCount) continue;
            if (smarts.equals(s.smiles)) {
                return true;
            }
            QueryAtomContainer q = this.sp.parse(s.smiles);
            IAtomContainer ac = this.stco.extractAtomContainer(q, null);
            boolean isoRes = this.isoTester.hasIsomorphism(ac);
            if (!isoRes) continue;
            return true;
        }
        return false;
    }

    void registerNewStruct(IAtomContainer struct, String smiles) {
        int freq = this.getFrequency(smiles);
        double SQI = this.getSQI(freq, struct.getAtomCount());
        if (this.charStructInfo.size() < this.hitListSize) {
            CharStructInfo csi = new CharStructInfo();
            csi.atomCount = struct.getAtomCount();
            csi.bondCount = struct.getBondCount();
            csi.frequency = freq;
            csi.smiles = smiles;
            csi.SQI = SQI;
            this.charStructInfo.add(csi);
            if (this.minSQIPos == -1) {
                this.minSQIPos = 0;
                this.minSQI = SQI;
            } else if (this.minSQI > SQI) {
                this.minSQIPos = this.charStructInfo.size() - 1;
                this.minSQI = SQI;
            }
        } else if (this.minSQI < SQI) {
            this.charStructInfo.remove(this.minSQIPos);
            CharStructInfo csi = new CharStructInfo();
            csi.atomCount = struct.getAtomCount();
            csi.bondCount = struct.getBondCount();
            csi.frequency = freq;
            csi.smiles = smiles;
            csi.SQI = SQI;
            this.charStructInfo.add(csi);
            this.setMinSQI();
        }
    }

    double getSQI(int frequency, int strSize) {
        return this.factor * (double)frequency / (double)this.structures.size() + (1.0 - this.factor) * (double)strSize / (double)this.maxStructSize;
    }

    int getFrequency(String smiles) {
        int freq = 0;
        QueryAtomContainer query = this.sp.parse(smiles);
        this.sp.setNeededDataFlags();
        this.isoTester.setQuery(query);
        for (int i = 0; i < this.structures.size(); ++i) {
            IAtomContainer ac = this.structures.get(i);
            boolean isoRes = this.isoTester.hasIsomorphism(ac);
            if (!isoRes) continue;
            ++freq;
        }
        return freq;
    }

    void setMinSQI() {
        this.minSQI = this.charStructInfo.get((int)0).SQI;
        this.minSQIPos = 0;
        for (int i = 1; i < this.charStructInfo.size(); ++i) {
            if (!(this.minSQI > this.charStructInfo.get((int)i).SQI)) continue;
            this.minSQI = this.charStructInfo.get((int)i).SQI;
            this.minSQIPos = i;
        }
    }

    public class CharStructInfo {
        public int atomCount;
        public int bondCount;
        public String smiles;
        public int frequency;
        public double SQI;
    }
}

