/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.structgen;

import java.util.Random;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.SaturationChecker;
import org.openscience.cdk.tools.manipulator.BondManipulator;

public class SingleStructureRandomGenerator {
    ILoggingTool logger = LoggingToolFactory.createLoggingTool(SingleStructureRandomGenerator.class);
    IAtomContainer atomContainer;
    SaturationChecker satCheck = new SaturationChecker();
    Random random = null;

    public SingleStructureRandomGenerator(long seed) throws Exception {
        this.random = new Random(seed);
    }

    public SingleStructureRandomGenerator() throws Exception {
        this(11000L);
    }

    public void setAtomContainer(IAtomContainer ac) {
        this.atomContainer = ac;
    }

    public IMolecule generate() throws CDKException {
        boolean structureFound = false;
        int iteration = 0;
        do {
            boolean bondFormed;
            ++iteration;
            this.atomContainer.removeAllElectronContainers();
            do {
                bondFormed = false;
                for (int f = 0; f < this.atomContainer.getAtomCount(); ++f) {
                    IAtom partner;
                    IAtom atom = this.atomContainer.getAtom(f);
                    if (this.satCheck.isSaturated(atom, this.atomContainer) || (partner = this.getAnotherUnsaturatedNode(atom)) == null) continue;
                    double cmax1 = this.satCheck.getCurrentMaxBondOrder(atom, this.atomContainer);
                    double cmax2 = this.satCheck.getCurrentMaxBondOrder(partner, this.atomContainer);
                    double max = Math.min(cmax1, cmax2);
                    double order = Math.min(Math.max(1.0, (double)this.random.nextInt((int)Math.round(max))), 3.0);
                    this.logger.debug("Forming bond of order ", order);
                    this.atomContainer.addBond(this.atomContainer.getBuilder().newInstance(IBond.class, new Object[]{atom, partner, BondManipulator.createBondOrder(order)}));
                    bondFormed = true;
                }
            } while (bondFormed);
            if (!ConnectivityChecker.isConnected(this.atomContainer) || !this.satCheck.allSaturated(this.atomContainer)) continue;
            structureFound = true;
        } while (!structureFound && iteration < 20);
        this.logger.debug("Structure found after #iterations: ", iteration);
        return this.atomContainer.getBuilder().newInstance(IMolecule.class, this.atomContainer);
    }

    private IAtom getAnotherUnsaturatedNode(IAtom exclusionAtom) throws CDKException {
        IAtom atom;
        int next;
        int f;
        for (f = next = this.random.nextInt(this.atomContainer.getAtomCount()); f < this.atomContainer.getAtomCount(); ++f) {
            atom = this.atomContainer.getAtom(f);
            if (this.satCheck.isSaturated(atom, this.atomContainer) || exclusionAtom == atom || this.atomContainer.getConnectedAtomsList(exclusionAtom).contains(atom)) continue;
            return atom;
        }
        for (f = 0; f < next; ++f) {
            atom = this.atomContainer.getAtom(f);
            if (this.satCheck.isSaturated(atom, this.atomContainer) || exclusionAtom == atom || this.atomContainer.getConnectedAtomsList(exclusionAtom).contains(atom)) continue;
            return atom;
        }
        return null;
    }
}

