/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.color;

import java.awt.Color;
import java.io.Serializable;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.renderer.color.IAtomColorer;

@TestClass(value="org.openscience.cdk.renderer.color.CDK2DAtomColorsTest")
public class CDK2DAtomColors
implements IAtomColorer,
Serializable {
    private static final long serialVersionUID = 6712994043820219426L;
    private static final Color HYDROGEN = Color.black;
    private static final Color CARBON = Color.black;
    private static final Color NITROGEN = Color.blue;
    private static final Color OXYGEN = Color.red;
    private static final Color PHOSPHORUS = Color.green.darker();
    private static final Color SULPHUR = Color.yellow.darker();
    private static final Color DEFAULT = Color.black;

    @TestMethod(value="testGetAtomColor")
    public Color getAtomColor(IAtom atom) {
        return this.getAtomColor(atom, DEFAULT);
    }

    @TestMethod(value="testGetDefaultAtomColor")
    public Color getAtomColor(IAtom atom, Color defaultColor) {
        Color color = defaultColor;
        int atomnumber = 0;
        if (atom.getAtomicNumber() != null) {
            atomnumber = atom.getAtomicNumber();
        }
        if (atomnumber != 0) {
            switch (atomnumber) {
                case 1: {
                    color = HYDROGEN;
                    break;
                }
                case 6: {
                    color = CARBON;
                    break;
                }
                case 7: {
                    color = NITROGEN;
                    break;
                }
                case 8: {
                    color = OXYGEN;
                    break;
                }
                case 15: {
                    color = PHOSPHORUS;
                    break;
                }
                case 16: {
                    color = SULPHUR;
                }
            }
        } else {
            String symbol = atom.getSymbol();
            if (symbol.equals("N")) {
                color = NITROGEN;
            }
            if (symbol.equals("O")) {
                color = OXYGEN;
            }
            if (symbol.equals("P")) {
                color = PHOSPHORUS;
            }
            if (symbol.equals("S")) {
                color = SULPHUR;
            }
        }
        return color;
    }
}

