/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.datatypes;

import com.hp.hpl.jena.datatypes.BaseDatatype;
import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import com.hp.hpl.jena.shared.impl.JenaParameters;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMapper {
    private static TypeMapper theTypeMap = new TypeMapper();
    private HashMap<String, RDFDatatype> uriToDT = new HashMap();
    private HashMap<Class<?>, RDFDatatype> classToDT = new HashMap();

    public static TypeMapper getInstance() {
        return theTypeMap;
    }

    public TypeMapper() {
        this.classToDT.put(Float.TYPE, this.classToDT.get(Float.class));
        this.classToDT.put(Double.TYPE, this.classToDT.get(Double.class));
        this.classToDT.put(Integer.TYPE, this.classToDT.get(Integer.class));
        this.classToDT.put(Long.TYPE, this.classToDT.get(Long.class));
        this.classToDT.put(Short.TYPE, this.classToDT.get(Short.class));
        this.classToDT.put(Byte.TYPE, this.classToDT.get(Byte.class));
        this.classToDT.put(Boolean.TYPE, this.classToDT.get(Boolean.class));
        this.classToDT.put(Character.TYPE, this.classToDT.get(String.class));
        this.classToDT.put(Character.class, this.classToDT.get(String.class));
        this.classToDT.put(URL.class, this.classToDT.get(URI.class));
    }

    public RDFDatatype getSafeTypeByName(String uri) {
        RDFDatatype dtype = this.uriToDT.get(uri);
        if (dtype == null) {
            if (uri == null) {
                return null;
            }
            if (JenaParameters.enableSilentAcceptanceOfUnknownDatatypes) {
                dtype = new BaseDatatype(uri);
                this.registerDatatype(dtype);
            } else {
                throw new DatatypeFormatException("Attempted to created typed literal using an unknown datatype - " + uri);
            }
        }
        return dtype;
    }

    public RDFDatatype getTypeByName(String uri) {
        return this.uriToDT.get(uri);
    }

    public RDFDatatype getTypeByValue(Object value) {
        return this.classToDT.get(value.getClass());
    }

    public Iterator<RDFDatatype> listTypes() {
        return this.uriToDT.values().iterator();
    }

    public RDFDatatype getTypeByClass(Class<?> clazz) {
        return this.classToDT.get(clazz);
    }

    public void registerDatatype(RDFDatatype type) {
        this.uriToDT.put(type.getURI(), type);
        Class<?> jc = type.getJavaClass();
        if (jc != null) {
            this.classToDT.put(jc, type);
        }
    }

    public static void main(String[] args) {
        Iterator<RDFDatatype> iter = theTypeMap.listTypes();
        while (iter.hasNext()) {
            RDFDatatype dt = iter.next();
            System.out.println(" - " + dt);
        }
    }

    static {
        theTypeMap.registerDatatype(XMLLiteralType.theXMLLiteralType);
        XSDDatatype.loadXSDSimpleTypes(theTypeMap);
    }
}

