/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.DBIDInt;
import com.hp.hpl.jena.db.impl.DBPropLSet;
import com.hp.hpl.jena.db.impl.IDBID;
import com.hp.hpl.jena.db.impl.IPSet;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.db.impl.SpecializedGraphBase;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SpecializedGraph_TripleStore
extends SpecializedGraphBase {
    public IPSet m_pset;
    public DBPropLSet m_dbPropLSet;
    public IDBID my_GID = null;

    SpecializedGraph_TripleStore(DBPropLSet lProp, IPSet pSet, Integer dbGraphID) {
        this.m_pset = pSet;
        this.m_dbPropLSet = lProp;
        this.my_GID = new DBIDInt(dbGraphID);
    }

    public SpecializedGraph_TripleStore(IPSet pSet, Integer dbGraphID) {
        this.m_pset = pSet;
        this.my_GID = new DBIDInt(dbGraphID);
    }

    @Override
    public void add(Graph g, SpecializedGraph.CompletionFlag complete) {
        ExtendedIterator<Triple> it = GraphUtil.findAll(g);
        while (it.hasNext()) {
            this.add((Triple)it.next(), complete);
        }
        complete.setDone();
    }

    @Override
    public void add(Triple t, SpecializedGraph.CompletionFlag complete) {
        this.m_pset.storeTriple(t, this.my_GID);
        complete.setDone();
    }

    @Override
    public void add(List<Triple> triples, SpecializedGraph.CompletionFlag complete) {
        this.m_pset.storeTripleList(triples, this.my_GID);
        complete.setDone();
    }

    @Override
    public void delete(Triple t, SpecializedGraph.CompletionFlag complete) {
        this.m_pset.deleteTriple(t, this.my_GID);
        complete.setDone();
    }

    @Override
    public void delete(List<Triple> triples, SpecializedGraph.CompletionFlag complete) {
        this.m_pset.deleteTripleList(triples, this.my_GID);
        complete.setDone();
    }

    @Override
    public int tripleCount() {
        return this.m_pset.tripleCount(this.my_GID);
    }

    @Override
    public boolean contains(Triple t, SpecializedGraph.CompletionFlag complete) {
        complete.setDone();
        return this.m_pset.statementTableContains(this.my_GID, t);
    }

    @Override
    public ExtendedIterator<Triple> find(TripleMatch t, SpecializedGraph.CompletionFlag complete) {
        complete.setDone();
        return this.m_pset.find(t, this.my_GID);
    }

    @Override
    public void close() {
        this.m_pset.close();
    }

    @Override
    public void clear() {
        this.m_pset.removeStatementsFromDB(this.my_GID);
    }

    @Override
    public int getGraphId() {
        return ((DBIDInt)this.my_GID).getIntID();
    }

    @Override
    public IPSet getPSet() {
        return this.m_pset;
    }

    @Override
    public DBPropLSet getDBPropLSet() {
        return this.m_dbPropLSet;
    }
}

