/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.smiles.smarts.SMARTSQueryTool;

public class MLFERDescriptor
implements IMolecularDescriptor {
    public static final String[] names = new String[]{"MLFER_A", "MLFER_BH", "MLFER_BO", "MLFER_S", "MLFER_E", "MLFER_L"};
    private static String[] AFragments = new String[]{"[C][OX2H]", "[c][OX2H]", "[C][NX3;H2]", "[c][NX3;H2;!$(NC=O)]", "[C][NX3;H1;!R][C]", "[C][NX3;H1;R][C]", "[c][NX3;H1;!$(NC=O)][C]", "[c][nX3;H1][c]", "[CX3](=O)[OX1H0-,OX2H1]", "[CX3](=[OX1])[NX3;H2]", "[CX3](=[OX1])[NX3;H1][C]", "[CX3](=[OX1])[NX3;H1][c]", "[$([SX4](=[OX1])(=[OX1])([!O])[NH,NH2,NH3+]),$([SX4+2]([OX1-])([OX1-])([!O])[NH,NH2,NH3+])]", "[NX3;H1]C(=[OX1])[NX3;H1]", "[NX3;H0]C(=[OX1])[NX3;H1]", "[NX3;H1]C(=[OX1])O", "[NX3;H1]C(=N)[NX3;H0]", "[C]#[CH]", "P[OH,O-]", "[CH][F,Cl,Br,I,$([NX3](=O)=O),$([NX3+](=O)[O-]),$(C#N),$([CX4](F)(F)F)]", "[CH]([F,Cl,Br,I,$([NX3](=O)=O),$([NX3+](=O)[O-]),$(C#N),$([CX4](F)(F)F)])[F,Cl,Br,I,$([NX3](=O)=O),$([NX3+](=O)[O-]),$(C#N),$([CX4](F)(F)F)]", "[CX4]([CX3](=O)[OX1H0-,OX2H1])[CX4][CX3](=O)[OX1H0-,OX2H1]", "[CX4]([F,Cl,Br,I,$([NX3](=O)=O),$([NX3+](=O)[O-]),$(C#N),$([CX4](F)(F)F)])[CX3](=O)[OX1H0-,OX2H1]", "[CX4]([F,Cl,Br,I,$([NX3](=O)=O),$([NX3+](=O)[O-]),$(C#N),$([CX4](F)(F)F)])[OH]", "[CX4]([F,Cl,Br,I,$([NX3](=O)=O),$([NX3+](=O)[O-]),$(C#N),$([CX4](F)(F)F)])[CX4][OH]", "[nX3;H1]:n", "[nX3;H1]:c:n", "[OX2;H1]CC[O,N]", "[OX2;H1]C[C,N]=[O,S]", "[OX2;H1]c1ccccc1[O,NX3]", "[OX2;H1]c1ccccc1C=[O,S]", "[OX2;H1]c1ccccc1[$([NX3](=O)=O),$([NX3+](=O)[O-])]", "[NH,NH2,NH3+]CC[O,N]", "[NH,NH2,NH3+]c1ccccc1[O,N]", "[NH,NH2,NH3+]c1ccccc1[C,N]=[O,S]", "[OX2H]c1ccccc1[Cl,Br,I]", "[OX1]=[C,c]~[C,c]C[OH]", "[OH]c1cccc2cccnc12", "[OH]c1cc([F,Cl,Br,I,$([NX3](=O)=O),$([NX3+](=O)[O-]),$(C#N),$([CX4](F)(F)F)])ccc1", "[OH]c1ccc([F,Cl,Br,I,$([NX3](=O)=O),$([NX3+](=O)[O-]),$(C#N),$([CX4](F)(F)F)])cc1", "[NH,NH2,NH3+]c1cc([F,Cl,Br,I,$([NX3](=O)=O),$([NX3+](=O)[O-]),$(C#N),$([CX4](F)(F)F)])ccc1", "[NH,NH2,NH3+]c1ccc([F,Cl,Br,I,$([NX3](=O)=O),$([NX3+](=O)[O-]),$(C#N),$([CX4](F)(F)F)])cc1", "[CX3](=O)([OX1H0-,OX2H1])c1cc([F,Cl,Br,I,$([NX3](=O)=O),$([NX3+](=O)[O-]),$(C#N),$([CX4](F)(F)F)])ccc1", "[CX3](=O)([OX1H0-,OX2H1])c1ccc([F,Cl,Br,I,$([NX3](=O)=O),$([NX3+](=O)[O-]),$(C#N),$([CX4](F)(F)F)])cc1", "[OH]c1c([CX4])cccc1[CX4]", "[NH,NH2,NH3+]c1c([CX4])cccc1[CX4]", "[OH]c1c(C[F,Cl,Br,I,$([NX3](=O)=O),$([NX3+](=O)[O-]),$(C#N),$([CX4](F)(F)F)])cccc1", "[OH]c1cc([CX3](=O)[OX1H0-,OX2H1])ccc1", "[OH]c1ccc([CX3](=O)[OX1H0-,OX2H1])cc1", "[OH]c1cc([$([CH](=O)),$(C(=O)C)])ccc1", "[OH]c1ccc([$([CH](=O)),$(C(=O)C)])cc1"};
    private static String[] BSELFragments = new String[]{"[CX4H3]", "[CX4H2]", "[CX4H1]", "[CX4H0]", "*=[CX3H2]", "[$(*=[CX3H1]),$([cX3H1](a)a)]", "[$(*=[CX3H0]),$([cX3H0](a)(a)A)]", "c(a)(a)a", "*#C", "[C][NX3;H2]", "[c][NX3;H2]", "[C][NX3;H1][C]", "[c][NX3;H1]", "[c][nX3;H1][c]", "[C][NX3;H0](C)[C]", "[c][NX3;H0](C)[C]", "[c][nX3;H0][c]", "*=[Nv3;!R]", "*=[Nv3;R]", "[nX2H0,nX3H1+](a)a", "N#C[A;!#1]", "N#C[a;!#1]", "[$([A;!#1][NX3](=O)=O),$([A;!#1][NX3+](=O)[O-])]", "[$([a;!#1][NX3](=O)=O),$([a;!#1][NX3+](=O)[O-])]", "[$([NX3](=[OX1])(=[OX1])O),$([NX3+]([OX1-])(=[OX1])O)]", "[OH]", "[OX2;H0;!R]", "[OX2;H0;R]", "[oX2](a)a", "*=O", "[SX2](*)*", "[sX2](a)a", "*=[SX1]", "*=[SX3]", "[$([#16X4](=[OX1])(=[OX1])([!#8])[OX2H0]),$([#16X4+2]([OX1-])([OX1-])([!#8])[OX2H0])]", "[S,s]", "[P,p]", "FA", "Fa", "Cl", "Br", "I", "[CX3;!R](=[OX1])[OX2H0]", "[CX3;R](=[OX1])[OX2H0;R]", "P(=[OX1])(O)(O)O", "[CX3](=[OX1])([OX2H0])[OX2H0]", "[CX3](=O)[OX1H0-,OX2H1]", "nC=[OX1]", "[N;!R]C=[OX1]", "[N;R][C;R]=[OX1]", "[$([SX4](=[OX1])(=[OX1])([!O])[NX3]),$([SX4+2]([OX1-])([OX1-])([!O])[NX3])]", "NC(=[OX1])N", "[NX3,NX4+][CX3](=[OX1])[OX2,OX1-]", "[CX3](=[OX1])[NX3][CX3](=[OX1])", "C1(=[OX1])C=CC(=[OX1])C=C1", "[$([CX4]([F,Cl,Br,I,$([NX3](=O)=O),$([NX3+](=O)[O-]),$(C#N),$([CX4](F)(F)F)])[F,Cl,Br,I,$([NX3](=O)=O),$([NX3+](=O)[O-]),$(C#N),$([CX4](F)(F)F)])]", "[CX4]([F,Cl,Br,I,$([NX3](=O)=O),$([NX3+](=O)[O-]),$(C#N),$([CX4](F)(F)F)])[CX4][F,Cl,Br,I,$([NX3](=O)=O),$([NX3+](=O)[O-]),$(C#N),$([CX4](F)(F)F)]", "*1~*2~*(~*3~*(~*~*~*~*3)~*1)~*~*~*1~*2~*~*~*1", "[OX2H]CC[O,N]", "[OX2H]C[C,N]=[O,S]", "[OX2H]c1ccccc1[O,Nv3]", "[OX2H]c1ccccc1C=[O,S]", "[OX2H]c1ccccc1[$([NX3](=O)=O),$([NX3+](=O)[O-])]", "[NH,NH2,NH3+]CC[O,N]", "[NH,NH2,NH3+]c1ccccc1[O,N]", "[NH,NH2,NH3+]c1ccccc1[C,N]=[O,S]", "[OX2H]c1ccccc1[Cl,Br,I]", "[CX4]([OH])[CX4][OH]", "n:n", "o:n", "n:c:n", "o:c:n", "n:c:c:n", "[F,Cl,Br,I,N,O,S]-c:c-[F,Cl,Br,I,N,O,S]", "[F,Cl,Br,I,N,O,S]-c:c:c-[F,Cl,Br,I,N,O,S]", "[F,Cl,Br,I,N,O,S]-c:c:c:c-[F,Cl,Br,I,N,O,S]", "P(=[OX1])N", "Nc:n", "[$(cC[OH]);!$(c[CX3](=O)[OX1H0-,OX2H1])]", "[$([#7+][OX1-]),$([#7v5]=[OX1]);!$([#7](~[O])~[O]);!$([#7]=[#7])]", "[OX2]-c:c-[OX2]"};
    private static double[] coefAFragments = new double[]{0.345, 0.543, 0.177, 0.247, 0.087, 0.321, 0.194, 0.371, 0.243, 0.275, 0.281, -0.091, 0.356, -0.165, -0.119, -0.105, 0.17, 0.082, 0.493, 0.019, 0.05, -0.362, 0.118, 0.1, 0.051, 0.194, 0.042, -0.089, -0.161, -0.251, -0.418, -0.45, -0.155, 0.0, -0.093, -0.11, -0.601, -0.475, 0.119, 0.176, 0.08, 0.084, 0.085, 0.055, -0.162, -0.181, 0.195, -0.203, 0.096, 0.185, 0.203, 0.003};
    private static double[] coefBHFragments = new double[]{0.007, 0.0, 0.011, 0.037, 0.019, 0.011, 0.0, 0.019, 0.028, 0.481, 0.275, 0.541, 0.415, 0.316, 0.653, 0.321, 0.392, 0.2, 0.596, 0.321, 0.242, 0.103, -0.476, -0.525, -0.204, 0.307, 0.211, 0.331, 0.047, 0.334, 0.168, 0.043, 0.071, 0.448, -0.188, 0.0, 1.183, -0.036, 0.0, 0.0, -0.011, 0.0, -0.206, -0.214, -0.394, -0.267, -0.308, -0.095, -0.287, -0.231, -0.446, -0.076, -0.252, -0.148, -0.051, -0.014, 0.013, 0.267, 0.0, -0.068, -0.079, -0.387, -0.126, 0.0, -0.059, -0.045, -0.13, 0.0, -0.132, -0.157, -0.098, -0.17, -0.089, 0.031, -0.035, -0.023, -0.668, -0.042, 0.131, -0.408, -0.216, 0.071};
    private static double[] coefBOFragments = new double[]{0.0, 0.0, 0.02, 0.047, 0.024, 0.012, 0.0, 0.018, 0.032, 0.486, 0.326, 0.543, 0.426, 0.267, 0.655, 0.338, 0.338, 0.202, 0.589, 0.3, 0.245, 0.093, -0.595, -0.533, -0.202, 0.311, 0.226, 0.33, 0.06, 0.339, 0.175, 0.083, 0.069, 0.319, -0.19, 0.0, 1.189, -0.033, 0.0, 0.0, 0.0, 0.0, -0.223, -0.169, -0.408, -0.298, -0.312, -0.038, -0.292, -0.242, -0.443, -0.054, -0.251, -0.149, -0.05, -0.016, 0.01, 0.218, 0.0, -0.09, -0.122, -0.403, -0.12, 0.0, -0.027, -0.069, -0.13, -0.018, -0.094, -0.141, -0.113, -0.184, -0.073, 0.025, -0.033, -0.025, -0.668, -0.057, 0.129, -0.405, -0.218, 0.064};
    private static double[] coefSFragments = new double[]{-0.075, 0.0, 0.036, 0.071, -0.085, 0.05, 0.101, 0.121, 0.034, 0.175, 0.383, 0.265, 0.311, 0.221, 0.323, 0.295, 0.265, 0.125, 0.254, 0.223, 0.694, 0.39, 0.0, -0.231, -0.476, 0.247, 0.185, 0.185, 0.0, 0.37, 0.189, 0.0, 0.618, 1.065, -0.505, 0.643, 0.703, -0.042, 0.0, 0.082, 0.161, 0.198, -0.225, 0.36, -0.24, -0.19, -0.412, -0.076, 0.175, -0.1, -0.569, -0.553, -0.588, -0.51, -0.411, -0.05, 0.0, 1.029, -0.067, -0.095, -0.237, -0.344, -0.276, -0.102, 0.0, -0.14, -0.12, 0.052, 0.024, 0.047, -0.04, 0.087, -0.051, -0.043, -0.038, 0.0, -0.452, 0.098, 0.0, 0.434, 0.38, 0.277};
    private static double[] coefEFragments = new double[]{-0.104, 0.0, 0.089, 0.187, -0.045, 0.068, 0.18, 0.3, 0.04, 0.085, 0.163, 0.138, 0.192, -0.03, 0.22, 0.346, 0.083, 0.117, 0.121, 0.046, 0.0, 0.0, 0.2, 0.21, 0.0, 0.061, 0.014, 0.013, -0.125, -0.041, 0.33, 0.116, 0.364, 0.413, 0.0, 0.465, 0.295, -0.18, -0.23, 0.023, 0.196, 0.533, -0.113, 0.0, -0.1, 0.0, -0.192, 0.221, 0.0, 0.061, -0.111, -0.11, 0.0, 0.0, 0.0, -0.017, 0.012, 0.285, 0.029, 0.0, -0.069, 0.0, 0.0, 0.0, 0.0, 0.0, -0.1, -0.043, 0.092, -0.113, 0.0, 0.052, 0.0, 0.0, 0.0, 0.0, -0.08, 0.185, 0.0, 0.0, 0.0, 0.248};
    private static double[] coefLFragments = new double[]{0.321, 0.499, 0.449, 0.443, 0.244, 0.469, 0.624, 0.744, 0.332, 0.781, 0.949, 0.568, 0.912, 1.25, 0.4, 0.869, 0.794, -0.235, -0.24, 0.574, 0.757, 0.732, 0.278, 0.347, 0.0, 0.672, 0.36, 0.359, 0.057, 0.495, 1.258, 0.848, 0.954, 2.196, 0.0, 0.554, 2.051, -0.143, -0.147, 0.669, 1.097, 1.59, -0.39, 0.406, -0.483, 0.0, -0.369, 0.0, 0.603, 0.583, 0.0, 0.0, 0.0, 0.0, 0.0, -0.111, 0.054, 0.488, -0.072, -0.337, 0.0, -0.303, -0.364, 0.062, 0.0, 0.169, -0.4, 0.1, -0.179, 0.0, 0.042, 0.209, -0.058, -0.081, -0.026, 0.0, 0.0, 0.149, -0.145, 0.0, 0.0, 0.13};

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("MLFER", this.getClass().getName(), "$Id: MLFERDescriptor.java 1 2008-07-07 06:50:01Z yapchunwei $", "PaDEL");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception exception) {
        int n = this.getDescriptorNames().length;
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult(n);
        for (int i = 0; i < n; ++i) {
            doubleArrayResult.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames(), exception);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        try {
            int n;
            SMARTSQueryTool sMARTSQueryTool = new SMARTSQueryTool("C");
            int n2 = AFragments.length;
            double d = 0.0;
            for (n = 0; n < n2; ++n) {
                sMARTSQueryTool.setSmarts(AFragments[n]);
                if (!sMARTSQueryTool.matches(iAtomContainer)) continue;
                d += (double)sMARTSQueryTool.getUniqueMatchingAtoms().size() * coefAFragments[n];
            }
            n = BSELFragments.length;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                sMARTSQueryTool.setSmarts(BSELFragments[i]);
                if (!sMARTSQueryTool.matches(iAtomContainer)) continue;
                int n4 = sMARTSQueryTool.getUniqueMatchingAtoms().size();
                if (30 <= i && i <= 34) {
                    n3 += n4;
                } else if (i == 35) {
                    n4 -= n3;
                }
                d2 += (double)n4 * coefBHFragments[i];
                d3 += (double)n4 * coefBOFragments[i];
                d4 += (double)n4 * coefSFragments[i];
                d5 += (double)n4 * coefEFragments[i];
                d6 += (double)n4 * coefLFragments[i];
            }
            d += coefAFragments[coefAFragments.length - 1];
            d2 += coefBHFragments[coefBHFragments.length - 1];
            d3 += coefBOFragments[coefBOFragments.length - 1];
            d4 += coefSFragments[coefSFragments.length - 1];
            d5 += coefEFragments[coefEFragments.length - 1];
            d6 += coefLFragments[coefLFragments.length - 1];
            DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
            doubleArrayResult.add(d);
            doubleArrayResult.add(d2);
            doubleArrayResult.add(d3);
            doubleArrayResult.add(d4);
            doubleArrayResult.add(d5);
            doubleArrayResult.add(d6);
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, names);
        }
        catch (Exception exception) {
            return this.getDummyDescriptorValue(new CDKException("Error in SMARTSQueryTool: " + exception.getMessage()));
        }
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(names.length);
    }
}

