/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.processors;

import ambit2.base.exceptions.AmbitException;
import ambit2.base.processors.DefaultAmbitProcessor;
import ambit2.base.processors.Reporter;
import ambit2.core.io.FileOutputState;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;

public abstract class ProcessorFileExport<Content>
extends DefaultAmbitProcessor<Content, FileOutputState>
implements Reporter<Content, FileOutputState> {
    private static final long serialVersionUID = -5006607500469902058L;
    protected FileOutputState output;
    protected String licenseURI;

    public String getLicenseURI() {
        return this.licenseURI;
    }

    public void setLicenseURI(String string) {
        this.licenseURI = string;
    }

    public FileOutputState getOutput() {
        return this.output;
    }

    public void setOutput(FileOutputState fileOutputState) {
        this.output = fileOutputState;
    }

    public ProcessorFileExport() {
        this(null);
    }

    public ProcessorFileExport(FileOutputState fileOutputState) {
        this.setOutput(fileOutputState);
    }

    public FileOutputState process(Content Content) throws AmbitException {
        if (Content == null) {
            throw new AmbitException("Workbook not assigned!");
        }
        Document document = new Document(PageSize.A4.rotate());
        try {
            File file = this.getOutput().getFile();
            if (file.getName().endsWith(FileOutputState.extensions[0])) {
                this.writeSDF(Content, new FileOutputStream(file));
                FileOutputState fileOutputState = this.getOutput();
                return fileOutputState;
            }
            if (file.getName().endsWith(FileOutputState.extensions[11])) {
                this.writePDF(document, new FileOutputStream(file));
            } else if (file.getName().endsWith(FileOutputState.extensions[15])) {
                this.writeRTF(document, new FileOutputStream(file));
            } else if (file.getName().endsWith(FileOutputState.extensions[10])) {
                this.writeHTML(document, new FileOutputStream(file));
            } else if (file.getName().endsWith(FileOutputState.extensions[9])) {
                this.writeXLS(Content, new FileOutputStream(file));
                FileOutputState fileOutputState = this.getOutput();
                return fileOutputState;
            }
            document.open();
            this.write(document, Content);
            FileOutputState fileOutputState = this.getOutput();
            return fileOutputState;
        }
        catch (DocumentException documentException) {
            throw new AmbitException((Throwable)documentException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new AmbitException((Throwable)fileNotFoundException);
        }
        finally {
            document.close();
        }
    }

    public String getFileExtension() {
        return null;
    }

    protected abstract void write(Document var1, Content var2) throws DocumentException;

    protected abstract void writePDF(Document var1, OutputStream var2) throws DocumentException;

    protected abstract void writeSDF(Content var1, OutputStream var2) throws AmbitException;

    protected abstract void writeRTF(Document var1, OutputStream var2) throws AmbitException;

    protected abstract void writeHTML(Document var1, OutputStream var2) throws AmbitException;

    protected abstract void writeXLS(Content var1, OutputStream var2) throws AmbitException;
}

