/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.util.BitSet;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Shade3D;
import org.jmol.geodesic.Geodesic;

class Normix3D {
    static final int NORMIX_GEODESIC_LEVEL = 3;
    private static final int normixCount = Geodesic.getVertexCount(3);
    private static final Vector3f[] vertexVectors = Geodesic.getVertexVectors();
    private static final short[] inverseNormixes = new short[normixCount];
    private static final short[][] neighborVertexesArrays = Geodesic.getNeighborVertexesArrays();
    private static final boolean TIMINGS = false;
    public static final short NORMIX_NULL = 9999;
    private final Vector3f[] transformedVectors = new Vector3f[normixCount];
    private final byte[] shadeIndexes;
    private final byte[] shadeIndexes2Sided;
    private static byte nullShadeIndex;

    Normix3D() {
        int n = normixCount;
        while (--n >= 0) {
            this.transformedVectors[n] = new Vector3f();
        }
        this.shadeIndexes = new byte[normixCount];
        this.shadeIndexes2Sided = new byte[normixCount];
    }

    static short getInverseNormix(short s) {
        return inverseNormixes[s];
    }

    static short getNormix(Vector3f vector3f, BitSet bitSet) {
        return Normix3D.getNormix(vector3f.x, vector3f.y, vector3f.z, 3, bitSet);
    }

    static short get2SidedNormix(Vector3f vector3f, BitSet bitSet) {
        return ~Normix3D.getNormix(vector3f.x, vector3f.y, vector3f.z, 3, bitSet);
    }

    static Vector3f getVector(short s) {
        return vertexVectors[s];
    }

    static short getNormix(double d, double d2, double d3, int n, BitSet bitSet) {
        double d4;
        short s;
        if (d3 >= 0.0) {
            s = 0;
            d4 = d3 - 1.0;
        } else {
            s = 11;
            d4 = d3 - -1.0;
        }
        bitSet.clear();
        bitSet.set(s);
        double d5 = d * d + d2 * d2 + d4 * d4;
        for (int i = 0; i <= n; ++i) {
            short[] sArray = neighborVertexesArrays[i];
            int n2 = 6 * s;
            int n3 = n2 + (s < 12 ? 5 : 6);
            while (--n3 >= n2) {
                short s2 = sArray[n3];
                if (bitSet.get(s2)) continue;
                bitSet.set(s2);
                Vector3f vector3f = vertexVectors[s2];
                double d6 = (double)vector3f.x - d;
                double d7 = d6 * d6;
                if (d7 >= d5 || (d7 += (d6 = (double)vector3f.y - d2) * d6) >= d5 || (d7 += (d6 = (double)vector3f.z - d3) * d6) >= d5) continue;
                s = s2;
                d5 = d7;
            }
        }
        return s;
    }

    Vector3f[] getTransformedVectors() {
        return this.transformedVectors;
    }

    boolean isDirectedTowardsCamera(short s) {
        return s < 0 || this.transformedVectors[s].z > 0.0f;
    }

    void setRotationMatrix(Matrix3f matrix3f) {
        int n = normixCount;
        while (--n >= 0) {
            Vector3f vector3f = this.transformedVectors[n];
            matrix3f.transform(vertexVectors[n], vector3f);
            this.shadeIndexes[n] = Shade3D.getShadeIndexNormalized(vector3f.x, -vector3f.y, vector3f.z);
            this.shadeIndexes2Sided[n] = vector3f.z >= 0.0f ? this.shadeIndexes[n] : Shade3D.getShadeIndexNormalized(-vector3f.x, vector3f.y, -vector3f.z);
        }
    }

    int getShadeIndex(short s) {
        return s == -10000 || s == 9999 ? nullShadeIndex : (s < 0 ? this.shadeIndexes2Sided[~s] : this.shadeIndexes[s]);
    }

    static {
        BitSet bitSet = new BitSet();
        int n = normixCount;
        while (--n >= 0) {
            Vector3f vector3f = vertexVectors[n];
            Normix3D.inverseNormixes[n] = Normix3D.getNormix(-vector3f.x, -vector3f.y, -vector3f.z, 3, bitSet);
        }
        nullShadeIndex = (byte)50;
    }
}

