/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.modelset.ModelSet;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

class AnimationManager {
    Viewer viewer;
    int currentModelIndex = 0;
    int backgroundModelIndex = -1;
    private BitSet bsVisibleFrames = new BitSet();
    AnimationThread animationThread;
    boolean inMotion = false;
    int firstModelIndex;
    int lastModelIndex;
    int frameStep;
    int animationDirection = 1;
    int currentDirection = 1;
    int animationFps;
    int animationReplayMode = 0;
    float firstFrameDelay;
    float lastFrameDelay;
    int firstFrameDelayMs;
    int lastFrameDelayMs;
    boolean animationOn = false;
    boolean animationPaused = false;
    int intAnimThread = 0;
    int lastModelPainted;

    AnimationManager(Viewer viewer) {
        this.viewer = viewer;
    }

    void setCurrentModelIndex(int n) {
        this.setCurrentModelIndex(n, true);
    }

    void setCurrentModelIndex(int n, boolean bl) {
        int n2;
        int n3 = this.currentModelIndex;
        ModelSet modelSet = this.viewer.getModelSet();
        int n4 = n2 = modelSet == null ? 0 : modelSet.getModelCount();
        if (n2 == 1) {
            n = 0;
            this.currentModelIndex = 0;
        } else if (n < 0 || n >= n2) {
            n = -1;
        }
        String string = null;
        boolean bl2 = false;
        if (this.currentModelIndex != n) {
            if (n2 > 0) {
                boolean bl3 = this.viewer.isJmolDataFrame(n);
                boolean bl4 = this.viewer.isJmolDataFrame(this.currentModelIndex);
                if (bl4) {
                    this.viewer.setJmolDataFrame(null, -1, this.currentModelIndex);
                }
                if (this.currentModelIndex != -1) {
                    this.viewer.saveModelOrientation();
                }
                if (bl4 || bl3) {
                    string = this.viewer.getJmolFrameType(n) + " " + n + " <-- " + " " + this.currentModelIndex + " " + this.viewer.getJmolFrameType(this.currentModelIndex);
                    bl2 = this.viewer.getJmolDataSourceFrame(n) == this.viewer.getJmolDataSourceFrame(this.currentModelIndex);
                }
            }
            this.currentModelIndex = n;
            if (string != null) {
                if (n >= 0) {
                    this.viewer.restoreModelOrientation(n);
                }
                if (bl2 && string.indexOf("quaternion") >= 0 && string.indexOf("ramachandran") < 0 && string.indexOf(" property ") < 0) {
                    this.viewer.restoreModelRotation(n3);
                }
            }
        }
        this.viewer.setTrajectory(this.currentModelIndex);
        this.viewer.setFrameOffset(this.currentModelIndex);
        if (this.currentModelIndex == -1 && bl) {
            this.setBackgroundModelIndex(-1);
        }
        this.viewer.setTainted(true);
        this.setFrameRangeVisible();
        this.setStatusFrameChanged();
        if (modelSet != null && !this.viewer.getSelectAllModels()) {
            this.viewer.setSelectionSubset(this.viewer.getModelUndeletedAtomsBitSet(this.currentModelIndex));
        }
    }

    private void setStatusFrameChanged() {
        if (this.viewer.getModelSet() != null) {
            this.viewer.setStatusFrameChanged(this.animationOn ? -2 - this.currentModelIndex : this.currentModelIndex);
        }
    }

    void setBackgroundModelIndex(int n) {
        ModelSet modelSet = this.viewer.getModelSet();
        if (modelSet == null || n < 0 || n >= modelSet.getModelCount()) {
            n = -1;
        }
        this.backgroundModelIndex = n;
        if (n >= 0) {
            this.viewer.setTrajectory(n);
        }
        this.viewer.setTainted(true);
        this.setFrameRangeVisible();
    }

    BitSet getVisibleFramesBitSet() {
        return this.bsVisibleFrames;
    }

    private void setFrameRangeVisible() {
        this.bsVisibleFrames.clear();
        if (this.backgroundModelIndex >= 0) {
            this.bsVisibleFrames.set(this.backgroundModelIndex);
        }
        if (this.currentModelIndex >= 0) {
            this.bsVisibleFrames.set(this.currentModelIndex);
            return;
        }
        if (this.frameStep == 0) {
            return;
        }
        int n = 0;
        int n2 = 0;
        for (int i = this.firstModelIndex; i != this.lastModelIndex; i += this.frameStep) {
            if (this.viewer.isJmolDataFrame(i)) continue;
            this.bsVisibleFrames.set(i);
            ++n;
            n2 = i;
        }
        if (this.firstModelIndex == this.lastModelIndex || !this.viewer.isJmolDataFrame(this.lastModelIndex) || n == 0) {
            this.bsVisibleFrames.set(this.lastModelIndex);
            if (n == 0) {
                this.firstModelIndex = this.lastModelIndex;
            }
            n = 0;
        }
        if (n == 1 && this.currentModelIndex < 0) {
            this.setCurrentModelIndex(n2);
        }
    }

    void setInMotion(boolean bl) {
        this.inMotion = bl;
    }

    void initializePointers(int n) {
        this.firstModelIndex = 0;
        int n2 = this.viewer.getModelCount();
        this.lastModelIndex = (n == 0 ? 0 : n2) - 1;
        this.frameStep = n;
        this.viewer.setFrameVariables(this.firstModelIndex, this.lastModelIndex);
    }

    void clear() {
        this.setAnimationOn(false);
        this.setCurrentModelIndex(0);
        this.currentDirection = 1;
        this.setAnimationDirection(1);
        this.setAnimationFps(10);
        this.setAnimationReplayMode(0, 0.0f, 0.0f);
        this.initializePointers(0);
    }

    Hashtable getAnimationInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("firstModelIndex", new Integer(this.firstModelIndex));
        hashtable.put("lastModelIndex", new Integer(this.lastModelIndex));
        hashtable.put("animationDirection", new Integer(this.animationDirection));
        hashtable.put("currentDirection", new Integer(this.currentDirection));
        hashtable.put("displayModelIndex", new Integer(this.currentModelIndex));
        hashtable.put("displayModelNumber", this.viewer.getModelNumberDotted(this.currentModelIndex));
        hashtable.put("displayModelName", this.currentModelIndex >= 0 ? this.viewer.getModelName(this.currentModelIndex) : "");
        hashtable.put("animationFps", new Integer(this.animationFps));
        hashtable.put("animationReplayMode", this.getAnimationModeName());
        hashtable.put("firstFrameDelay", new Float(this.firstFrameDelay));
        hashtable.put("lastFrameDelay", new Float(this.lastFrameDelay));
        hashtable.put("animationOn", this.animationOn);
        hashtable.put("animationPaused", this.animationPaused);
        return hashtable;
    }

    String getState(StringBuffer stringBuffer) {
        BitSet bitSet;
        int n = this.viewer.getModelCount();
        if (n < 2) {
            return "";
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        if (stringBuffer != null) {
            stringBuffer.append("  _setFrameState;\n");
            stringBuffer2.append("function _setFrameState() {\n");
        }
        stringBuffer2.append("# frame state;\n");
        stringBuffer2.append("# modelCount ").append(n).append(";\n# first ").append(this.viewer.getModelNumberDotted(0)).append(";\n# last ").append(this.viewer.getModelNumberDotted(n - 1)).append(";\n");
        if (this.backgroundModelIndex >= 0) {
            StateManager.appendCmd(stringBuffer2, "set backgroundModel " + this.viewer.getModelNumberDotted(this.backgroundModelIndex));
        }
        if ((bitSet = this.viewer.getFrameOffsets()) != null) {
            StateManager.appendCmd(stringBuffer2, "frame align " + Escape.escape(bitSet));
        }
        StateManager.appendCmd(stringBuffer2, "frame RANGE " + this.viewer.getModelNumberDotted(this.firstModelIndex) + " " + this.viewer.getModelNumberDotted(this.lastModelIndex));
        StateManager.appendCmd(stringBuffer2, "animation DIRECTION " + (this.animationDirection == 1 ? "+1" : "-1"));
        StateManager.appendCmd(stringBuffer2, "animation FPS " + this.animationFps);
        StateManager.appendCmd(stringBuffer2, "animation MODE " + this.getAnimationModeName() + " " + this.firstFrameDelay + " " + this.lastFrameDelay);
        StateManager.appendCmd(stringBuffer2, "frame " + this.viewer.getModelNumberDotted(this.currentModelIndex));
        StateManager.appendCmd(stringBuffer2, "animation " + (!this.animationOn ? "OFF" : (this.currentDirection == 1 ? "PLAY" : "PLAYREV")));
        if (this.animationOn && this.animationPaused) {
            StateManager.appendCmd(stringBuffer2, "animation PAUSE");
        }
        if (stringBuffer != null) {
            stringBuffer2.append("}\n\n");
        }
        return stringBuffer2.toString();
    }

    void setAnimationDirection(int n) {
        this.animationDirection = n;
    }

    void setAnimationFps(int n) {
        this.animationFps = n;
    }

    void setAnimationReplayMode(int n, float f, float f2) {
        this.firstFrameDelay = f > 0.0f ? f : 0.0f;
        this.firstFrameDelayMs = (int)(this.firstFrameDelay * 1000.0f);
        this.lastFrameDelay = f2 > 0.0f ? f2 : 0.0f;
        this.lastFrameDelayMs = (int)(this.lastFrameDelay * 1000.0f);
        if (n >= 0 && n <= 2) {
            this.animationReplayMode = n;
        } else {
            Logger.error("invalid animationReplayMode:" + n);
        }
    }

    void setAnimationRange(int n, int n2) {
        int n3 = this.viewer.getModelCount();
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = n3;
        }
        if (n >= n3) {
            n = n3 - 1;
        }
        if (n2 >= n3) {
            n2 = n3 - 1;
        }
        this.firstModelIndex = n;
        this.lastModelIndex = n2;
        this.frameStep = n2 < n ? -1 : 1;
        this.rewindAnimation();
    }

    private void animationOn(boolean bl) {
        this.animationOn = bl;
        this.viewer.setBooleanProperty("_animating", bl);
    }

    void setAnimationOn(boolean bl) {
        if (!bl || !this.viewer.haveModelSet()) {
            this.setAnimationOff(false);
            return;
        }
        if (!this.viewer.getSpinOn()) {
            this.viewer.refresh(3, "Viewer:setAnimationOn");
        }
        this.setAnimationRange(-1, -1);
        this.resumeAnimation();
    }

    void setAnimationOff(boolean bl) {
        if (this.animationThread != null) {
            this.animationThread.interrupt();
            this.animationThread = null;
        }
        this.animationPaused = bl;
        if (!this.viewer.getSpinOn()) {
            this.viewer.refresh(3, "Viewer:setAnimationOff");
        }
        this.animationOn(false);
        this.setStatusFrameChanged();
    }

    void pauseAnimation() {
        this.setAnimationOff(true);
    }

    void reverseAnimation() {
        this.currentDirection = -this.currentDirection;
        if (!this.animationOn) {
            this.resumeAnimation();
        }
    }

    void repaintDone() {
        this.lastModelPainted = this.currentModelIndex;
    }

    void resumeAnimation() {
        if (this.currentModelIndex < 0) {
            this.setAnimationRange(this.firstModelIndex, this.lastModelIndex);
        }
        if (this.viewer.getModelCount() <= 1) {
            this.animationOn(false);
            return;
        }
        this.animationOn(true);
        this.animationPaused = false;
        if (this.animationThread == null) {
            ++this.intAnimThread;
            this.animationThread = new AnimationThread(this.firstModelIndex, this.lastModelIndex, this.intAnimThread);
            this.animationThread.start();
        }
    }

    boolean setAnimationNext() {
        return this.setAnimationRelative(this.animationDirection);
    }

    void setAnimationLast() {
        this.setCurrentModelIndex(this.animationDirection > 0 ? this.lastModelIndex : this.firstModelIndex);
    }

    void rewindAnimation() {
        this.setCurrentModelIndex(this.animationDirection > 0 ? this.firstModelIndex : this.lastModelIndex);
        this.currentDirection = 1;
        this.viewer.setFrameVariables(this.firstModelIndex, this.lastModelIndex);
    }

    boolean setAnimationPrevious() {
        return this.setAnimationRelative(-this.animationDirection);
    }

    boolean setAnimationRelative(int n) {
        boolean bl;
        int n2 = this.frameStep * n * this.currentDirection;
        int n3 = this.currentModelIndex + n2;
        boolean bl2 = bl = n3 > this.firstModelIndex && n3 > this.lastModelIndex || n3 < this.firstModelIndex && n3 < this.lastModelIndex;
        if (bl) {
            switch (this.animationReplayMode) {
                case 0: {
                    return false;
                }
                case 1: {
                    n3 = this.animationDirection == this.currentDirection ? this.firstModelIndex : this.lastModelIndex;
                    break;
                }
                case 2: {
                    this.currentDirection = -this.currentDirection;
                    n3 -= 2 * n2;
                }
            }
        }
        int n4 = this.viewer.getModelCount();
        if (n3 < 0 || n3 >= n4) {
            return false;
        }
        this.setCurrentModelIndex(n3);
        return true;
    }

    String getAnimationModeName() {
        switch (this.animationReplayMode) {
            case 1: {
                return "LOOP";
            }
            case 2: {
                return "PALINDROME";
            }
        }
        return "ONCE";
    }

    class AnimationThread
    extends Thread
    implements Runnable {
        final int framePointer;
        final int framePointer2;
        int intThread;

        AnimationThread(int n, int n2, int n3) {
            this.framePointer = n;
            this.framePointer2 = n2;
            this.setName("AnimationThread");
            this.intThread = n3;
        }

        public void run() {
            long l = System.currentTimeMillis();
            int n = 0;
            if (Logger.debugging) {
                Logger.debug("animation thread " + this.intThread + " running");
            }
            AnimationManager.this.viewer.requestRepaintAndWait();
            try {
                int n2 = n - (int)(System.currentTimeMillis() - l);
                if (n2 > 0) {
                    Thread.sleep(n2);
                }
                boolean bl = true;
                while (!this.isInterrupted() && AnimationManager.this.animationOn) {
                    if (AnimationManager.this.currentModelIndex == this.framePointer && (n2 = (n += AnimationManager.this.firstFrameDelayMs) - (int)(System.currentTimeMillis() - l)) > 0) {
                        Thread.sleep(n2);
                    }
                    if (AnimationManager.this.currentModelIndex == this.framePointer2 && (n2 = (n += AnimationManager.this.lastFrameDelayMs) - (int)(System.currentTimeMillis() - l)) > 0) {
                        Thread.sleep(n2);
                    }
                    if (!bl && AnimationManager.this.lastModelPainted == AnimationManager.this.currentModelIndex && !AnimationManager.this.setAnimationNext()) {
                        Logger.debug("animation thread " + this.intThread + " exiting");
                        AnimationManager.this.setAnimationOff(false);
                        return;
                    }
                    bl = false;
                    n2 = (n += 1000 / AnimationManager.this.animationFps) - (int)(System.currentTimeMillis() - l);
                    while (!this.isInterrupted() && AnimationManager.this.animationOn && !AnimationManager.this.viewer.getRefreshing()) {
                        Thread.sleep(10L);
                    }
                    if (!AnimationManager.this.viewer.getSpinOn()) {
                        AnimationManager.this.viewer.refresh(1, "animationThread");
                    }
                    if ((n2 = n - (int)(System.currentTimeMillis() - l)) <= 0) continue;
                    Thread.sleep(n2);
                }
            }
            catch (InterruptedException interruptedException) {
                Logger.debug("animation thread interrupted!");
                try {
                    AnimationManager.this.setAnimationOn(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

