/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import javax.vecmath.Vector3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class CastepReader
extends AtomSetCollectionReader {
    private String[] tokens;
    private float a;
    private float b;
    private float c;
    private float alpha;
    private float beta;
    private float gamma;
    private Vector3f[] abc = new Vector3f[3];
    private boolean iHaveFractionalCoordinates;
    private static final String[] lengthUnitIds = new String[]{"bohr", "m", "cm", "nm", "ang", "a0"};
    private static final float[] lengthUnitFactors = new float[]{0.5291772f, 1.0E10f, 1.0E8f, 10.0f, 1.0f, 0.5291772f};
    private static final int lengthUnits = lengthUnitIds.length;

    public void initializeReader() throws Exception {
        while (this.tokenizeCastepCell() > 0) {
            if (this.tokens.length < 2 || !this.tokens[0].equalsIgnoreCase("%BLOCK")) continue;
            if (this.tokens[1].equalsIgnoreCase("LATTICE_ABC")) {
                this.readLatticeAbc();
                continue;
            }
            if (this.tokens[1].equalsIgnoreCase("LATTICE_CART")) {
                this.readLatticeCart();
                continue;
            }
            if (this.tokens[1].equalsIgnoreCase("POSITIONS_FRAC")) {
                this.readPositionsFrac();
                this.iHaveFractionalCoordinates = true;
                continue;
            }
            if (!this.tokens[1].equalsIgnoreCase("POSITIONS_ABS")) continue;
            this.readPositionsAbs();
            this.iHaveFractionalCoordinates = false;
        }
        this.continuing = false;
    }

    protected void finalizeReader() throws Exception {
        int n;
        this.doApplySymmetry = true;
        this.setFractionalCoordinates(this.iHaveFractionalCoordinates);
        this.setUnitCell(this.a, this.b, this.c, this.alpha, this.beta, this.gamma);
        float[] fArray = new float[3];
        for (n = 0; n < 3; ++n) {
            this.abc[n].get(fArray);
            this.addPrimitiveLatticeVector(n, fArray, 0);
        }
        n = this.atomSetCollection.getAtomCount();
        for (int i = 0; i < n; ++i) {
            Atom atom = this.atomSetCollection.getAtom(i);
            this.setAtomCoord(atom);
        }
        super.finalizeReader();
    }

    private void readLatticeAbc() throws Exception {
        if (this.tokenizeCastepCell() == 0) {
            return;
        }
        float f = this.readLengthUnit();
        if (this.tokens.length < 3) {
            Logger.warn("error reading a,b,c in %BLOCK LATTICE_ABC in CASTEP .cell file");
            return;
        }
        this.a = this.parseFloat(this.tokens[0]) * f;
        this.b = this.parseFloat(this.tokens[1]) * f;
        this.c = this.parseFloat(this.tokens[2]) * f;
        if (this.tokenizeCastepCell() == 0) {
            return;
        }
        if (this.tokens.length >= 3) {
            this.alpha = this.parseFloat(this.tokens[0]);
            this.beta = this.parseFloat(this.tokens[1]);
            this.gamma = this.parseFloat(this.tokens[2]);
        } else {
            Logger.warn("error reading alpha,beta,gamma in %BLOCK LATTICE_ABC in CASTEP .cell file");
        }
        for (int i = 0; i < 3; ++i) {
            this.abc[i] = new Vector3f(Float.NaN, Float.NaN, Float.NaN);
        }
    }

    private void readLatticeCart() throws Exception {
        if (this.tokenizeCastepCell() == 0) {
            return;
        }
        float f = this.readLengthUnit();
        for (int i = 0; i < 3; ++i) {
            if (this.tokens.length < 3) {
                Logger.warn("error reading coordinates of lattice vector " + Integer.toString(i + 1) + " in %BLOCK LATTICE_CART in CASTEP .cell file");
                return;
            }
            float f2 = this.parseFloat(this.tokens[0]) * f;
            float f3 = this.parseFloat(this.tokens[1]) * f;
            float f4 = this.parseFloat(this.tokens[2]) * f;
            this.abc[i] = new Vector3f(f2, f3, f4);
            if (this.tokenizeCastepCell() != 0) continue;
            return;
        }
        this.a = this.abc[0].length();
        this.b = this.abc[1].length();
        this.c = this.abc[2].length();
        this.alpha = (float)Math.toDegrees(this.abc[1].angle(this.abc[2]));
        this.beta = (float)Math.toDegrees(this.abc[2].angle(this.abc[0]));
        this.gamma = (float)Math.toDegrees(this.abc[0].angle(this.abc[1]));
    }

    private void readPositionsFrac() throws Exception {
        if (this.tokenizeCastepCell() == 0) {
            return;
        }
        this.readAtomData(1.0f);
    }

    private void readPositionsAbs() throws Exception {
        if (this.tokenizeCastepCell() == 0) {
            return;
        }
        float f = this.readLengthUnit();
        this.readAtomData(f);
    }

    private float readLengthUnit() throws Exception {
        float f = 1.0f;
        for (int i = 0; i < lengthUnits; ++i) {
            if (!this.tokens[0].equalsIgnoreCase(lengthUnitIds[i])) continue;
            f = lengthUnitFactors[i];
            this.tokenizeCastepCell();
        }
        return f;
    }

    private void readAtomData(float f) throws Exception {
        while (!this.tokens[0].equalsIgnoreCase("%ENDBLOCK")) {
            if (this.tokens.length >= 4) {
                Atom atom = this.atomSetCollection.addNewAtom();
                float f2 = this.parseFloat(this.tokens[1]) * f;
                float f3 = this.parseFloat(this.tokens[2]) * f;
                float f4 = this.parseFloat(this.tokens[3]) * f;
                atom.set(f2, f3, f4);
                atom.elementSymbol = this.tokens[0];
            } else {
                Logger.warn("cannot read line with CASTEP atom data: " + this.line);
            }
            if (this.tokenizeCastepCell() > 0) continue;
        }
    }

    private int tokenizeCastepCell() throws Exception {
        while (true) {
            if (this.readLine() == null) {
                return 0;
            }
            if (this.line.trim().length() == 0) continue;
            this.tokens = this.getTokens();
            if (!(this.line.startsWith("#") || this.line.startsWith("!") || this.tokens[0].equals("#") || this.tokens[0].equals("!"))) break;
        }
        return this.tokens.length;
    }
}

