/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.data;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import javax.vecmath.Point3f;
import org.jmol.util.MeshSurface;

public class MeshData
extends MeshSurface {
    public static final int MODE_GET_VERTICES = 1;
    public static final int MODE_GET_COLOR_INDEXES = 2;
    public static final int MODE_PUT_SETS = 3;
    public static final int MODE_PUT_VERTICES = 4;
    private boolean setsSuccessful;
    public int vertexIncrement = 1;
    public String polygonColorData;

    public int addVertexCopy(Point3f point3f, float f, int n) {
        if (n < 0) {
            this.vertexIncrement = -n;
        }
        return this.addVertexCopy(point3f, f);
    }

    public BitSet[] getSurfaceSet() {
        return this.surfaceSet == null ? this.getSurfaceSet(0) : this.surfaceSet;
    }

    public BitSet[] getSurfaceSet(int n) {
        int n2;
        int n3;
        if (n == 0) {
            this.surfaceSet = new BitSet[100];
            this.nSets = 0;
        }
        this.setsSuccessful = true;
        for (n3 = 0; n3 < this.polygonCount; ++n3) {
            if (this.polygonIndexes[n3] == null) continue;
            int[] nArray = this.polygonIndexes[n3];
            n2 = this.findSet(nArray[0]);
            int n4 = this.findSet(nArray[1]);
            int n5 = this.findSet(nArray[2]);
            if (n2 < 0 && n4 < 0 && n5 < 0) {
                this.createSet(nArray[0], nArray[1], nArray[2]);
                continue;
            }
            if (n2 == n4 && n4 == n5) continue;
            if (n2 >= 0) {
                this.surfaceSet[n2].set(nArray[1]);
                this.surfaceSet[n2].set(nArray[2]);
                if (n4 >= 0 && n4 != n2) {
                    this.mergeSets(n2, n4);
                }
                if (n5 < 0 || n5 == n2 || n5 == n4) continue;
                this.mergeSets(n2, n5);
                continue;
            }
            if (n4 >= 0) {
                this.surfaceSet[n4].set(nArray[0]);
                this.surfaceSet[n4].set(nArray[2]);
                if (n5 < 0 || n5 == n4) continue;
                this.mergeSets(n4, n5);
                continue;
            }
            this.surfaceSet[n5].set(nArray[0]);
            this.surfaceSet[n5].set(nArray[1]);
        }
        n3 = 0;
        for (int i = 0; i < this.nSets; ++i) {
            if (this.surfaceSet[i] == null) continue;
            ++n3;
        }
        BitSet[] bitSetArray = new BitSet[100];
        n3 = 0;
        for (n2 = 0; n2 < this.nSets; ++n2) {
            if (this.surfaceSet[n2] == null) continue;
            bitSetArray[n3++] = this.surfaceSet[n2];
        }
        this.nSets = n3;
        this.surfaceSet = bitSetArray;
        if (!this.setsSuccessful && n < 2) {
            this.getSurfaceSet(n + 1);
        }
        if (n == 0) {
            this.sortSurfaceSets();
            this.setVertexSets(false);
        }
        return this.surfaceSet;
    }

    private void sortSurfaceSets() {
        int n;
        SSet[] sSetArray = new SSet[this.nSets];
        for (n = 0; n < this.nSets; ++n) {
            sSetArray[n] = new SSet(this.surfaceSet[n]);
        }
        Arrays.sort(sSetArray, new SortSet());
        for (n = 0; n < this.nSets; ++n) {
            this.surfaceSet[n] = sSetArray[n].bs;
        }
    }

    public void setVertexSets(boolean bl) {
        int n;
        if (this.surfaceSet == null) {
            return;
        }
        int n2 = 0;
        for (int i = 0; i < this.nSets; ++i) {
            if (this.surfaceSet[i] != null && this.surfaceSet[i].cardinality() == 0) {
                this.surfaceSet[i] = null;
            }
            if (this.surfaceSet[i] != null) continue;
            ++n2;
        }
        if (n2 > 0) {
            BitSet[] bitSetArray = new BitSet[this.nSets - n2];
            int n3 = 0;
            for (n = 0; n < this.nSets; ++n) {
                if (this.surfaceSet[n] == null) continue;
                bitSetArray[n3++] = this.surfaceSet[n];
            }
            this.surfaceSet = bitSetArray;
            this.nSets -= n2;
        } else if (bl) {
            return;
        }
        this.vertexSets = new int[this.vertexCount];
        for (int i = 0; i < this.nSets; ++i) {
            n = this.surfaceSet[i].nextSetBit(0);
            while (n >= 0) {
                this.vertexSets[n] = i;
                n = this.surfaceSet[i].nextSetBit(n + 1);
            }
        }
    }

    private int findSet(int n) {
        for (int i = 0; i < this.nSets; ++i) {
            if (this.surfaceSet[i] == null || !this.surfaceSet[i].get(n)) continue;
            return i;
        }
        return -1;
    }

    private void createSet(int n, int n2, int n3) {
        int n4;
        for (n4 = 0; n4 < this.nSets && this.surfaceSet[n4] != null; ++n4) {
        }
        if (n4 >= 100) {
            this.setsSuccessful = false;
            return;
        }
        this.surfaceSet[n4] = new BitSet();
        this.surfaceSet[n4].set(n);
        this.surfaceSet[n4].set(n2);
        this.surfaceSet[n4].set(n3);
        if (n4 == this.nSets) {
            ++this.nSets;
        }
    }

    private void mergeSets(int n, int n2) {
        this.surfaceSet[n].or(this.surfaceSet[n2]);
        this.surfaceSet[n2] = null;
    }

    public void invalidateSurfaceSet(int n) {
        int n2 = this.surfaceSet[n].nextSetBit(0);
        while (n2 >= 0) {
            this.vertexValues[n2] = Float.NaN;
            n2 = this.surfaceSet[n].nextSetBit(n2 + 1);
        }
        this.surfaceSet[n] = null;
    }

    public static boolean checkCutoff(int n, int n2, int n3, float[] fArray) {
        if (n < 0 || n2 < 0 || n3 < 0) {
            return false;
        }
        float f = fArray[n];
        float f2 = fArray[n2];
        float f3 = fArray[n3];
        return f >= 0.0f && f2 >= 0.0f && f3 >= 0.0f || f <= 0.0f && f2 <= 0.0f && f3 <= 0.0f;
    }

    public void updateInvalidatedVertices(BitSet bitSet) {
        int n = 0;
        int n2 = 0;
        while (n < this.vertexCount) {
            if (Float.isNaN(this.vertexValues[n])) {
                bitSet.set(n);
            }
            n += this.vertexIncrement;
            ++n2;
        }
    }

    public void invalidateVertices(BitSet bitSet) {
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            this.vertexValues[n] = Float.NaN;
            n = bitSet.nextSetBit(n + 1);
        }
    }

    protected class SortSet
    implements Comparator {
        protected SortSet() {
        }

        public int compare(Object object, Object object2) {
            return ((SSet)object).n > ((SSet)object2).n ? -1 : (((SSet)object).n < ((SSet)object2).n ? 1 : 0);
        }
    }

    private class SSet {
        BitSet bs;
        int n;

        protected SSet(BitSet bitSet) {
            this.bs = bitSet;
            this.n = bitSet.cardinality();
        }
    }
}

