/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelsetbio.Monomer;
import org.jmol.util.Quaternion;

public class PhosphorusMonomer
extends Monomer {
    protected static final byte P = 0;
    private static final byte[] phosphorusOffsets = new byte[]{0};
    private static float MAX_ADJACENT_PHOSPHORUS_DISTANCE = 8.0f;
    protected boolean isPurine;
    protected boolean isPyrimidine;

    public final boolean isNucleic() {
        return true;
    }

    static Monomer validateAndAllocate(Chain chain, String string, int n, int n2, int n3, int[] nArray) {
        if (n2 != n3 || nArray[13] != n2) {
            return null;
        }
        return new PhosphorusMonomer(chain, string, n, n2, n3, phosphorusOffsets);
    }

    protected PhosphorusMonomer(Chain chain, String string, int n, int n2, int n3, byte[] byArray) {
        super(chain, string, n, n2, n3, byArray);
        if (string.indexOf(84) >= 0) {
            chain.setIsDna(true);
        }
        if (string.indexOf(85) + string.indexOf(73) > -2) {
            chain.setIsRna(true);
        }
        this.isPurine = string.indexOf(65) + string.indexOf(71) + string.indexOf(73) > -3;
        this.isPyrimidine = string.indexOf(84) + string.indexOf(67) + string.indexOf(85) > -3;
    }

    Atom getP() {
        return this.getAtomFromOffsetIndex(0);
    }

    boolean isPhosphorusMonomer() {
        return true;
    }

    public boolean isDna() {
        return this.chain.isDna();
    }

    public boolean isRna() {
        return this.chain.isRna();
    }

    public boolean isPurine() {
        return this.isPurine;
    }

    public boolean isPyrimidine() {
        return this.isPyrimidine;
    }

    public Object getStructure() {
        return this.chain;
    }

    public byte getProteinStructureType() {
        return 0;
    }

    boolean isConnectedAfter(Monomer monomer) {
        if (monomer == null) {
            return true;
        }
        if (!(monomer instanceof PhosphorusMonomer)) {
            return false;
        }
        float f = this.getLeadAtom().distance(monomer.getLeadAtom());
        return f <= MAX_ADJACENT_PHOSPHORUS_DISTANCE;
    }

    public Quaternion getQuaternion(char c) {
        int n = this.monomerIndex;
        if (n == 0 || n >= this.bioPolymer.monomerCount - 1) {
            return null;
        }
        Atom atom = this.bioPolymer.monomers[n].getAtomFromOffsetIndex(0);
        Atom atom2 = this.bioPolymer.monomers[n + 1].getAtomFromOffsetIndex(0);
        Atom atom3 = this.bioPolymer.monomers[n - 1].getAtomFromOffsetIndex(0);
        if (atom == null || atom2 == null || atom3 == null) {
            return null;
        }
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        vector3f.sub(atom2, atom);
        vector3f2.sub(atom3, atom);
        return Quaternion.getQuaternionFrame(vector3f, vector3f2, null, false);
    }

    Point3f getQuaternionFrameCenter(char c) {
        return this.getAtomFromOffsetIndex(0);
    }

    public Object getHelixData(int n, char c, int n2) {
        return this.getHelixData2(n, c, n2);
    }
}

