/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.text.NumberFormat;
import javax.vecmath.Point3f;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.BoxInfo;
import org.jmol.shape.CageRenderer;
import org.jmol.shape.Uccage;
import org.jmol.util.TextFormat;

public class UccageRenderer
extends CageRenderer {
    NumberFormat nf;
    byte fid;
    boolean doLocalize;
    final Point3f[] verticesT = new Point3f[8];

    public UccageRenderer() {
        int n = 8;
        while (--n >= 0) {
            this.verticesT[n] = new Point3f();
        }
    }

    protected void setEdges() {
        this.tickEdges = BoxInfo.uccageTickEdges;
    }

    protected void initRenderer() {
        super.initRenderer();
        this.draw000 = false;
    }

    protected void render() {
        this.imageFontScaling = this.viewer.getImageFontScaling();
        this.font3d = this.g3d.getFont3DScaled(((Uccage)this.shape).font3d, this.imageFontScaling);
        int n = this.viewer.getObjectMad(5);
        this.colix = this.viewer.getObjectColix(5);
        if (n == 0 || !this.g3d.setColix(this.colix) || this.viewer.isJmolDataFrame()) {
            return;
        }
        this.doLocalize = this.viewer.getUseNumberLocalization();
        this.render1(n);
    }

    void render1(int n) {
        SymmetryInterface symmetryInterface = this.viewer.getCurrentUnitCell();
        if (symmetryInterface == null || !symmetryInterface.haveUnitCell()) {
            return;
        }
        this.isPolymer = symmetryInterface.isPolymer();
        this.isSlab = symmetryInterface.isSlab();
        Point3f[] point3fArray = symmetryInterface.getUnitCellVertices();
        Point3f point3f = symmetryInterface.getCartesianOffset();
        int n2 = 8;
        while (--n2 >= 0) {
            this.verticesT[n2].add(point3fArray[n2], point3f);
        }
        Point3f[] point3fArray2 = this.viewer.getAxisPoints();
        boolean bl = this.viewer.getObjectMad(1) == 0 || this.viewer.getAxesScale() < 2.0f || point3fArray2 == null;
        this.render(n, this.verticesT, point3fArray2, bl ? 0 : 3);
        if (this.viewer.getDisplayCellParameters() && !this.viewer.isPreviewOnly() && !symmetryInterface.isPeriodic()) {
            this.renderInfo(symmetryInterface);
        }
    }

    private String nfformat(float f) {
        return this.doLocalize && this.nf != null ? this.nf.format(f) : TextFormat.formatDecimal(f, 3);
    }

    private void renderInfo(SymmetryInterface symmetryInterface) {
        if (this.exportType != 0 || !this.g3d.setColix(this.viewer.getColixBackgroundContrast())) {
            return;
        }
        if (this.nf == null) {
            this.nf = NumberFormat.getInstance();
        }
        this.fid = this.g3d.getFontFid("Monospaced", 14.0f * this.imageFontScaling);
        if (this.nf != null) {
            this.nf.setMaximumFractionDigits(3);
            this.nf.setMinimumFractionDigits(3);
        }
        this.g3d.setFont(this.fid);
        int n = (int)(15.0f * this.imageFontScaling);
        int n2 = (int)(5.0f * this.imageFontScaling);
        int n3 = n;
        String string = symmetryInterface.getSpaceGroupName();
        if (this.isPolymer) {
            string = "polymer";
        } else if (this.isSlab) {
            string = "slab";
        }
        if (string != null & !string.equals("-- [--]")) {
            this.g3d.drawStringNoSlab(string, null, n2, n3 += n, 0);
        }
        this.g3d.drawStringNoSlab("a=" + this.nfformat(symmetryInterface.getUnitCellAsArray(0)) + "\u00c5", null, n2, n3 += n, 0);
        if (!this.isPolymer) {
            this.g3d.drawStringNoSlab("b=" + this.nfformat(symmetryInterface.getUnitCellAsArray(1)) + "\u00c5", null, n2, n3 += n, 0);
        }
        if (!this.isPolymer && !this.isSlab) {
            this.g3d.drawStringNoSlab("c=" + this.nfformat(symmetryInterface.getUnitCellAsArray(2)) + "\u00c5", null, n2, n3 += n, 0);
        }
        if (this.nf != null) {
            this.nf.setMaximumFractionDigits(1);
        }
        if (!this.isPolymer) {
            if (!this.isSlab) {
                this.g3d.drawStringNoSlab("\u03b1=" + this.nfformat(symmetryInterface.getUnitCellAsArray(3)) + "\u00b0", null, n2, n3 += n, 0);
                this.g3d.drawStringNoSlab("\u03b2=" + this.nfformat(symmetryInterface.getUnitCellAsArray(4)) + "\u00b0", null, n2, n3 += n, 0);
            }
            this.g3d.drawStringNoSlab("\u03b3=" + this.nfformat(symmetryInterface.getUnitCellAsArray(5)) + "\u00b0", null, n2, n3 += n, 0);
        }
    }
}

