/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class QchemReader
extends MOReader {
    private int calculationNumber = 1;
    private MOInfo[] alphas = null;
    private MOInfo[] betas = null;
    private int nBasis = 0;
    private boolean dFixed = false;
    private boolean fFixed = false;
    private static String DC_LIST = CANONICAL_DC_LIST;
    private static String DS_LIST = "D3    D4    D2    D5    D1";
    private static String FC_LIST = CANONICAL_FC_LIST;
    private static String FS_LIST = "F4    F5    F3    F6    F2    F7    F1";
    String dList = "";
    String fList = "";
    boolean dSpherical = false;
    boolean fSpherical = false;

    protected void initializeReader() {
        this.energyUnits = "au";
    }

    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("Standard Nuclear Orientation") >= 0) {
            this.readAtoms();
            this.moData = null;
            return true;
        }
        if (this.line.indexOf("Requested basis set is") >= 0) {
            this.readCalculationType();
            return true;
        }
        if (this.line.indexOf("VIBRATIONAL FREQUENCIES") >= 0) {
            this.readFrequencies();
            return true;
        }
        if (this.line.indexOf("Mulliken Net Atomic Charges") >= 0) {
            this.readPartialCharges();
            return true;
        }
        if (this.line.startsWith("Job ")) {
            ++this.calculationNumber;
            this.moData = null;
            return true;
        }
        if (this.line.indexOf("Basis set in general basis input format") >= 0) {
            if (this.moData == null) {
                this.readBasis();
            }
            return true;
        }
        if (this.moData == null) {
            return true;
        }
        if (this.line.indexOf("Orbital Energies (a.u.) and Symmetries") >= 0) {
            this.readESym(true);
            return true;
        }
        if (this.line.indexOf("Orbital Energies (a.u.)") >= 0) {
            this.readESym(false);
            return true;
        }
        if (this.line.indexOf("MOLECULAR ORBITAL COEFFICIENTS") >= 0) {
            if (this.filterMO()) {
                this.readQchemMolecularOrbitals();
            }
            return true;
        }
        return this.checkNboLine();
    }

    private void readCalculationType() {
        this.calculationType = this.line.substring(this.line.indexOf("set is") + 6).trim();
    }

    private void readAtoms() throws Exception {
        this.atomSetCollection.newAtomSet();
        this.setMOData(true);
        this.discardLines(2);
        while (this.readLine() != null && !this.line.startsWith(" --")) {
            String string;
            String[] stringArray = this.getTokens();
            if (stringArray.length < 5 || JmolAdapter.getElementNumber(string = stringArray[1]) < 1) continue;
            float f = this.parseFloat(stringArray[2]);
            float f2 = this.parseFloat(stringArray[3]);
            float f3 = this.parseFloat(stringArray[4]);
            if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) continue;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = string;
            atom.set(f, f2, f3);
            this.atomSetCollection.setAtomSetProperty(".PATH", "Calculation " + this.calculationNumber);
        }
    }

    private void readFrequencies() throws Exception, IOException {
        while (this.readLine() != null && this.line.indexOf("STANDARD") < 0) {
            if (!this.line.startsWith(" Frequency:")) {
                this.discardLinesUntilStartsWith(" Frequency:");
            }
            String[] stringArray = this.getTokens();
            int n = stringArray.length - 1;
            boolean[] blArray = new boolean[n];
            int n2 = this.atomSetCollection.getLastAtomSetAtomCount();
            int n3 = this.atomSetCollection.getAtomCount();
            for (int i = 0; i < n; ++i) {
                boolean bl = blArray[i] = !this.doGetVibration(++this.vibrationNumber);
                if (blArray[i]) continue;
                this.atomSetCollection.cloneLastAtomSet();
                this.atomSetCollection.setAtomSetFrequency("Calculation " + this.calculationNumber, null, stringArray[i + 1], null);
            }
            this.discardLinesUntilStartsWith("               X");
            this.fillFrequencyData(n3, n2, n2, blArray, true, 0, 0, null);
            this.discardLinesUntilBlank();
        }
    }

    private void readPartialCharges() throws Exception {
        this.discardLines(3);
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        int n = this.atomSetCollection.getLastAtomSetAtomCount();
        for (int i = 0; i < n && this.readLine() != null; ++i) {
            atomArray[i].partialCharge = this.parseFloat(this.getTokens()[2]);
        }
    }

    private void readBasis() throws Exception {
        int n;
        String[] stringArray;
        this.moData = new Hashtable();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.shells = new ArrayList();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        this.discardLinesUntilStartsWith("$basis");
        this.readLine();
        while (this.readLine() != null) {
            if (this.line.startsWith("****")) {
                ++n2;
                if (this.readLine() == null || !this.line.startsWith("$end")) continue;
                break;
            }
            ++n3;
            int[] nArray = new int[4];
            stringArray = QchemReader.getTokens(this.line);
            nArray[0] = n2;
            nArray[1] = JmolAdapter.getQuantumShellTagID(stringArray[0]);
            nArray[2] = n4;
            nArray[3] = n = this.parseInt(stringArray[1]);
            this.shells.add(nArray);
            n4 += n;
            for (int i = 0; i < n; ++i) {
                arrayList.add(QchemReader.getTokens(this.readLine()));
            }
        }
        this.gaussians = new float[n4][];
        for (int i = 0; i < n4; ++i) {
            stringArray = (String[])arrayList.get(i);
            this.gaussians[i] = new float[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                this.gaussians[i][n] = this.parseFloat(stringArray[n]);
            }
        }
        if (Logger.debugging) {
            Logger.debug(n3 + " slater shells read");
            Logger.debug(n4 + " gaussian primitives read");
        }
        this.discardLinesUntilStartsWith(" There are");
        stringArray = QchemReader.getTokens(this.line);
        this.nBasis = this.parseInt(stringArray[5]);
    }

    private void readESym(boolean bl) throws Exception {
        this.alphas = new MOInfo[this.nBasis];
        this.betas = new MOInfo[this.nBasis];
        int n = 0;
        boolean bl2 = false;
        this.discardLinesUntilStartsWith(" Alpha");
        String[] stringArray = QchemReader.getTokens(this.line);
        MOInfo[] mOInfoArray = this.alphas;
        block0: for (int i = 0; i < 2; ++i) {
            int n2 = 0;
            while (this.readLine() != null) {
                if (this.line.startsWith(" -- ")) {
                    n = 0;
                    if (this.line.indexOf("Vacant") < 0 && this.line.indexOf("Occupied") > 0) {
                        n = 1;
                    }
                    this.readLine();
                }
                if (this.line.startsWith(" -------")) {
                    i = 2;
                    continue block0;
                }
                int n3 = QchemReader.getTokens(this.line).length;
                if (n3 == 0 || this.line.startsWith(" Warning")) {
                    this.discardLinesUntilStartsWith(" Beta");
                    bl2 = true;
                    mOInfoArray = this.betas;
                    continue block0;
                }
                if (bl) {
                    stringArray = QchemReader.getTokens(this.readLine());
                }
                int n4 = 0;
                int n5 = 0;
                while (n4 < n3) {
                    MOInfo mOInfo = new MOInfo();
                    mOInfo.ne = n;
                    if (bl) {
                        mOInfo.moSymmetry = stringArray[n5] + stringArray[n5 + 1] + " ";
                    }
                    mOInfoArray[n2] = mOInfo;
                    ++n2;
                    ++n4;
                    n5 += 2;
                }
            }
        }
        if (!bl2) {
            this.betas = this.alphas;
        }
    }

    private void readQchemMolecularOrbitals() throws Exception {
        String string = QchemReader.getTokens(this.line)[0];
        this.alphaBeta = string.equals("RESTRICTTED") ? "" : "A";
        int n = this.readMOs(string.equals("RESTRICTED"), this.alphas);
        if (string.equals("ALPHA")) {
            this.discardLinesUntilContains("BETA");
            this.alphaBeta = "B";
            n += this.readMOs(false, this.betas);
        }
        boolean bl = true;
        if (this.dList.length() > 0 && !(bl = this.dSpherical ? this.getDFMap(this.dList, 3, DS_LIST, 2) : this.getDFMap(this.dList, 4, DC_LIST, 3))) {
            Logger.error("atomic orbital order is unrecognized -- skipping reading of MOs. dList=" + this.dList);
            this.shells = null;
        }
        if (this.fList.length() > 0 && !(bl = this.fSpherical ? this.getDFMap(this.fList, 5, FS_LIST, 2) : this.getDFMap(this.fList, 6, FC_LIST, 3))) {
            Logger.error("atomic orbital order is unrecognized -- skipping reading of MOs. fList=" + this.fList);
            this.shells = null;
        }
        this.setMOData(this.shells == null);
        this.shells = null;
    }

    private int readMOs(boolean bl, MOInfo[] mOInfoArray) throws Exception {
        Hashtable[] hashtableArray = new Hashtable[6];
        float[][] fArrayArray = new float[6][];
        int[] nArray = new int[6];
        int n = 0;
        while (this.readLine().length() > 2) {
            int n2;
            String string;
            int n3;
            String[] stringArray = QchemReader.getTokens(this.line);
            int n4 = stringArray.length;
            String[] stringArray2 = QchemReader.getTokens(this.readLine().substring(13));
            for (n3 = 0; n3 < n4; ++n3) {
                nArray[n3] = this.parseInt(stringArray[n3]) - 1;
                fArrayArray[n3] = new float[this.nBasis];
                hashtableArray[n3] = new Hashtable();
            }
            int n5 = 0;
            block11: for (n3 = 0; n3 < this.nBasis; ++n3) {
                stringArray = QchemReader.getTokens(this.readLine());
                string = this.line.substring(12, 17).trim();
                n2 = string.charAt(0);
                switch (n2) {
                    case 100: {
                        string = string.substring(string.length() - 3).toUpperCase();
                        if (string.startsWith("D ")) {
                            if (!this.dFixed) {
                                this.fixSlaterTypes(4, 3);
                            }
                            string = "D" + string.charAt(2);
                            this.dSpherical = true;
                        }
                        if (this.dList.indexOf(string) < 0) {
                            this.dList = this.dList + string + " ";
                        }
                        this.dFixed = true;
                        break;
                    }
                    case 102: {
                        string = string.substring(string.length() - 3).toUpperCase();
                        if (string.startsWith("F ")) {
                            if (!this.fFixed) {
                                this.fixSlaterTypes(6, 5);
                            }
                            string = "F" + string.charAt(2);
                            this.fSpherical = true;
                        }
                        if (this.fList.indexOf(string) < 0) {
                            this.fList = this.fList + string + " ";
                        }
                        this.fFixed = true;
                        break;
                    }
                    default: {
                        if (!this.isQuantumBasisSupported((char)n2)) continue block11;
                    }
                }
                int n6 = stringArray.length - n4;
                for (int i = 0; i < n4; ++i) {
                    fArrayArray[i][n5] = this.parseFloat(stringArray[n6]);
                    ++n6;
                }
                ++n5;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                MOInfo mOInfo = mOInfoArray[nArray[n3]];
                hashtableArray[n3].put("energy", new Float(stringArray2[n3]));
                hashtableArray[n3].put("coefficients", fArrayArray[n3]);
                string = this.alphaBeta;
                n2 = mOInfo.ne;
                if (bl) {
                    n2 = this.alphas[nArray[n3]].ne + this.betas[nArray[n3]].ne;
                }
                hashtableArray[n3].put("occupancy", new Float(n2));
                switch (n2) {
                    case 2: {
                        string = "AB";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 0: {
                        string = bl ? "V" : "V" + string;
                    }
                }
                hashtableArray[n3].put("symmetry", mOInfo.moSymmetry + string + "(" + (nArray[n3] + 1) + ")");
                this.orbitals.add(hashtableArray[n3]);
            }
            n += n4;
        }
        return n;
    }

    protected class MOInfo {
        int ne = 0;
        String moSymmetry = "";

        protected MOInfo() {
        }
    }
}

