/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Component;
import java.awt.Event;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import org.jmol.export.image.ImageCreator;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.ActionManager;
import org.jmol.viewer.Viewer;

class MouseManager14
implements MouseWheelListener,
MouseListener,
MouseMotionListener,
KeyListener {
    private Viewer viewer;
    private ActionManager actionManager;
    private String keyBuffer = "";
    private boolean isMouseDown;
    private int xWhenPressed;
    private int yWhenPressed;
    private int modifiersWhenPressed10;

    MouseManager14(Viewer viewer, ActionManager actionManager) {
        this.viewer = viewer;
        this.actionManager = actionManager;
        Component component = viewer.getDisplay();
        component.addKeyListener(this);
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        component.addMouseWheelListener(this);
    }

    void clear() {
    }

    void dispose() {
        Component component = this.viewer.getDisplay();
        this.actionManager.dispose();
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
        component.removeMouseWheelListener(this);
        component.removeKeyListener(this);
    }

    boolean handleOldJvm10Event(Event event) {
        int n = event.x;
        int n2 = event.y;
        int n3 = event.modifiers;
        long l = event.when;
        n3 = MouseManager14.applyLeftMouse(n3);
        switch (event.id) {
            case 501: {
                this.xWhenPressed = n;
                this.yWhenPressed = n2;
                this.modifiersWhenPressed10 = n3;
                this.mousePressed(l, n, n2, n3, false);
                break;
            }
            case 506: {
                this.mouseDragged(l, n, n2, n3);
                break;
            }
            case 504: {
                this.mouseEntered(l, n, n2);
                break;
            }
            case 505: {
                this.mouseExited(l, n, n2);
                break;
            }
            case 503: {
                this.mouseMoved(l, n, n2, n3);
                break;
            }
            case 502: {
                this.mouseReleased(l, n, n2, n3);
                if (n != this.xWhenPressed || n2 != this.yWhenPressed || n3 != this.modifiersWhenPressed10) break;
                this.mouseClicked(l, n, n2, n3, 1);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.mouseClicked(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers(), mouseEvent.getClickCount());
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseEntered(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseExited(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY());
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mousePressed(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers(), mouseEvent.isPopupTrigger());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseReleased(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if ((n & 0x1C) == 0) {
            n |= 0x10;
        }
        this.mouseDragged(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY(), n);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        mouseWheelEvent.consume();
        this.mouseWheel(mouseWheelEvent.getWhen(), mouseWheelEvent.getWheelRotation(), mouseWheelEvent.getModifiers() | 0x20);
    }

    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.consume();
        if (!this.viewer.menuEnabled()) {
            return;
        }
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getModifiers();
        if (Logger.debuggingHigh) {
            Logger.debug("MouseManager keyTyped: " + c + " " + ('\u0000' + c) + " " + n);
        }
        if (n != 0) {
            switch (c) {
                case '\u000b': 
                case 'k': {
                    boolean bl = !this.viewer.getBooleanProperty("allowKeyStrokes");
                    switch (n) {
                        case 2: {
                            this.viewer.setBooleanProperty("allowKeyStrokes", bl);
                            this.viewer.setBooleanProperty("showKeyStrokes", true);
                            break;
                        }
                        case 8: 
                        case 10: {
                            this.viewer.setBooleanProperty("allowKeyStrokes", bl);
                            this.viewer.setBooleanProperty("showKeyStrokes", false);
                        }
                    }
                    this.clearKeyBuffer();
                    this.viewer.refresh(3, "showkey");
                    break;
                }
                case '\u0016': 
                case 'v': {
                    switch (n) {
                        case 2: {
                            String string = ImageCreator.getClipboardTextStatic();
                            if (string.startsWith("http://") && string.indexOf("\n") < 0) {
                                this.viewer.evalString("load " + Escape.escape(string));
                                break;
                            }
                            if ((string = this.viewer.loadInline(string, false)) == null) break;
                            Logger.error(string);
                        }
                    }
                    break;
                }
                case '\u001a': 
                case 'z': {
                    switch (n) {
                        case 2: {
                            this.viewer.undoAction(0, -2, true);
                            break;
                        }
                        case 3: {
                            this.viewer.undoAction(0, -3, true);
                        }
                    }
                    break;
                }
                case '\u0019': 
                case 'y': {
                    switch (n) {
                        case 2: {
                            this.viewer.undoAction(0, -3, true);
                        }
                    }
                }
            }
            return;
        }
        if (!this.viewer.getBooleanProperty("allowKeyStrokes")) {
            return;
        }
        this.addKeyBuffer(c);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.actionManager.keyPressed(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.actionManager.keyReleased(keyEvent);
    }

    private void clearKeyBuffer() {
        if (this.keyBuffer.length() == 0) {
            return;
        }
        this.keyBuffer = "";
        if (this.viewer.getBooleanProperty("showKeyStrokes")) {
            this.viewer.evalStringQuiet("!set echo _KEYSTROKES; set echo bottom left;echo \"\"");
        }
    }

    private void addKeyBuffer(char c) {
        if (c == '\n') {
            this.sendKeyBuffer();
            return;
        }
        if (c == '\b') {
            if (this.keyBuffer.length() > 0) {
                this.keyBuffer = this.keyBuffer.substring(0, this.keyBuffer.length() - 1);
            }
        } else {
            this.keyBuffer = this.keyBuffer + c;
        }
        if (this.viewer.getBooleanProperty("showKeyStrokes")) {
            this.viewer.evalStringQuiet("!set echo _KEYSTROKES; set echo bottom left;echo " + Escape.escape("\u0001" + this.keyBuffer));
        }
    }

    private void sendKeyBuffer() {
        String string = this.keyBuffer;
        if (this.viewer.getBooleanProperty("showKeyStrokes")) {
            this.viewer.evalStringQuiet("!set echo _KEYSTROKES; set echo bottom left;echo " + Escape.escape(this.keyBuffer));
        }
        this.clearKeyBuffer();
        this.viewer.script(string);
    }

    private void mouseEntered(long l, int n, int n2) {
        this.actionManager.mouseEntered(l, n, n2);
    }

    private void mouseExited(long l, int n, int n2) {
        this.actionManager.mouseExited(l, n, n2);
    }

    void setMouseMode() {
        this.clearKeyBuffer();
        this.actionManager.setMouseMode();
    }

    private void mouseClicked(long l, int n, int n2, int n3, int n4) {
        this.clearKeyBuffer();
        this.actionManager.mouseAction(2, l, n, n2, 1, n3);
    }

    private void mouseMoved(long l, int n, int n2, int n3) {
        this.clearKeyBuffer();
        if (this.isMouseDown) {
            this.actionManager.mouseAction(1, l, n, n2, 0, MouseManager14.applyLeftMouse(n3));
        } else {
            this.actionManager.mouseAction(0, l, n, n2, 0, n3);
        }
    }

    private void mouseWheel(long l, int n, int n2) {
        this.clearKeyBuffer();
        this.actionManager.mouseAction(3, l, 0, n, 0, n2);
    }

    private void mousePressed(long l, int n, int n2, int n3, boolean bl) {
        this.clearKeyBuffer();
        this.isMouseDown = true;
        this.actionManager.mouseAction(4, l, n, n2, 0, n3);
    }

    private void mouseReleased(long l, int n, int n2, int n3) {
        this.isMouseDown = false;
        this.actionManager.mouseAction(5, l, n, n2, 0, n3);
    }

    private void mouseDragged(long l, int n, int n2, int n3) {
        if ((n3 & 0x14) == 20) {
            n3 = n3 & 0xFFFFFFFB | 2;
        }
        this.actionManager.mouseAction(1, l, n, n2, 0, n3);
    }

    private static int applyLeftMouse(int n) {
        return (n & 0x1C) == 0 ? n | 0x10 : n;
    }
}

