/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.adapter.readers.quantum.MopacSlaterReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class MoldenReader
extends MopacSlaterReader {
    private boolean loadGeometries;
    private boolean loadVibrations;
    private boolean vibOnly;
    private boolean optOnly;
    private int modelAtomCount;

    protected void initializeReader() {
        this.vibOnly = this.checkFilter("VIBONLY");
        this.optOnly = this.checkFilter("OPTONLY");
        this.loadGeometries = !this.vibOnly && this.desiredVibrationNumber < 0 && !this.checkFilter("NOOPT");
        boolean bl = this.loadVibrations = !this.optOnly && this.desiredModelNumber < 0 && !this.checkFilter("NOVIB");
        this.filter = this.checkFilter("ALPHA") ? "alpha" : (this.checkFilter("BETA") ? "beta" : null);
    }

    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("[Atoms]") >= 0 || this.line.indexOf("[ATOMS]") >= 0) {
            this.readAtoms();
            this.modelAtomCount = this.atomSetCollection.getFirstAtomSetAtomCount();
            return false;
        }
        if (this.line.indexOf("[GTO]") >= 0) {
            return this.readGaussianBasis();
        }
        if (this.line.indexOf("[MO]") >= 0) {
            return !this.readMolecularOrbitals || this.readMolecularOrbitals();
        }
        if (this.line.indexOf("[FREQ]") >= 0) {
            return !this.loadVibrations || this.readFreqsAndModes();
        }
        if (this.line.indexOf("[GEOCONV]") >= 0) {
            return !this.loadGeometries || this.readGeometryOptimization();
        }
        return true;
    }

    private void readAtoms() throws Exception {
        float f;
        boolean bl;
        String string = this.getTokens()[1];
        int n = 0;
        int n2 = 0;
        boolean bl2 = bl = string.indexOf("Angs") < 0;
        if (bl && string.indexOf("AU") < 0) {
            throw new Exception("invalid coordinate unit " + string + " in [Atoms]");
        }
        this.readLine();
        float f2 = f = bl ? 0.5291772f : 1.0f;
        while (this.line != null && this.line.indexOf(91) < 0) {
            Atom atom = this.atomSetCollection.addNewAtom();
            String[] stringArray = this.getTokens();
            atom.atomName = stringArray[0];
            n2 = this.parseInt(stringArray[1]);
            if (n > 0 && n2 != n + 1) {
                throw new Exception("out of order atom in [Atoms]");
            }
            n = n2;
            atom.elementNumber = (short)this.parseInt(stringArray[2]);
            this.setAtomCoord(atom, this.parseFloat(stringArray[3]) * f, this.parseFloat(stringArray[4]) * f, this.parseFloat(stringArray[5]) * f);
            this.readLine();
        }
    }

    private boolean readGaussianBasis() throws Exception {
        Object object;
        this.shells = new ArrayList();
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        int n = 0;
        int n2 = 0;
        while (this.readLine() != null && (this.line = this.line.trim()).length() != 0 && this.line.charAt(0) != '[') {
            object = this.getTokens();
            n = this.parseInt((String)object[0]) - 1;
            while (this.readLine() != null && this.line.trim().length() > 0) {
                object = this.getTokens();
                String string = object[0].toUpperCase();
                int n3 = this.parseInt((String)object[1]);
                int[] nArray = new int[]{n, JmolAdapter.getQuantumShellTagID(string), n2, n3};
                int n4 = n3;
                while (--n4 >= 0) {
                    String[] stringArray = MoldenReader.getTokens(this.readLine());
                    int n5 = stringArray.length;
                    float[] fArray = new float[n5];
                    for (int i = 0; i < n5; ++i) {
                        fArray[i] = this.parseFloat(stringArray[i]);
                    }
                    arrayList.add(fArray);
                    ++n2;
                }
                this.shells.add(nArray);
            }
        }
        object = new float[n2][];
        for (int i = 0; i < n2; ++i) {
            object[i] = (float[])arrayList.get(i);
        }
        this.moData.put("shells", this.shells);
        this.moData.put("gaussians", object);
        if (Logger.debugging) {
            Logger.debug(this.shells.size() + " slater shells read");
            Logger.debug(((float[][])object).length + " gaussian primitives read");
        }
        this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", this.moData);
        return false;
    }

    private boolean readMolecularOrbitals() throws Exception {
        this.readLine();
        if (this.line.equals("[5D]")) {
            this.fixSlaterTypes(4, 3);
            this.fixSlaterTypes(6, 5);
            this.readLine();
        }
        String[] stringArray = this.getTokens();
        while (stringArray != null && stringArray[0].indexOf(91) < 0) {
            String string;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            ArrayList<String> arrayList = new ArrayList<String>();
            float f = Float.NaN;
            float f2 = Float.NaN;
            String string2 = null;
            while (stringArray != null && this.parseInt(string = stringArray[0]) == Integer.MIN_VALUE) {
                if (string.startsWith("Ene")) {
                    f = this.parseFloat(stringArray[1]);
                } else if (string.startsWith("Occup")) {
                    f2 = this.parseFloat(stringArray[1]);
                } else if (string.startsWith("Sym")) {
                    string2 = stringArray[1];
                } else if (string.startsWith("Spin")) {
                    this.alphaBeta = stringArray[1].toLowerCase();
                }
                stringArray = MoldenReader.getTokens(this.readLine());
            }
            if (stringArray == null) {
                throw new Exception("error reading MOs: unexpected EOF reading coeffs");
            }
            while (stringArray != null && this.parseInt(stringArray[0]) != Integer.MIN_VALUE) {
                if (stringArray.length != 2) {
                    throw new Exception("invalid MO coefficient specification");
                }
                arrayList.add(stringArray[1]);
                stringArray = MoldenReader.getTokens(this.readLine());
            }
            float[] fArray = new float[arrayList.size()];
            int n = arrayList.size();
            while (--n >= 0) {
                fArray[n] = this.parseFloat((String)arrayList.get(n));
            }
            String string3 = this.line;
            this.line = "";
            if (this.filterMO()) {
                hashtable.put("coefficients", fArray);
                if (!Float.isNaN(f)) {
                    hashtable.put("energy", new Float(f));
                }
                if (!Float.isNaN(f2)) {
                    hashtable.put("occupancy", new Float(f2));
                }
                if (string2 != null) {
                    hashtable.put("symmetry", string2);
                }
                if (this.alphaBeta.length() > 0) {
                    hashtable.put("type", this.alphaBeta);
                }
                this.setMO(hashtable);
                if (Logger.debugging) {
                    Logger.debug(fArray.length + " coefficients in MO " + this.orbitals.size());
                }
            }
            this.line = string3;
        }
        Logger.debug("read " + this.orbitals.size() + " MOs");
        this.setMOs("eV");
        return false;
    }

    private boolean readFreqsAndModes() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        BitSet bitSet = new BitSet();
        int n = 0;
        while (this.readLine() != null && this.line.indexOf(91) < 0) {
            String string = this.getTokens()[0];
            bitSet.set(n++, this.parseFloat(string) != 0.0f);
            arrayList.add(string);
        }
        int n2 = arrayList.size();
        this.discardLinesUntilContains("[FR-COORD]");
        if (!this.vibOnly) {
            this.readAtomSet("frequency base geometry", true, true);
        }
        this.discardLinesUntilContains("[FR-NORM-COORD]");
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            this.discardLinesUntilContains("vibration");
            if (!bitSet.get(i) || !this.doGetVibration(++this.vibrationNumber)) continue;
            if (bl) {
                this.atomSetCollection.cloneLastAtomSet();
            }
            bl = true;
            this.atomSetCollection.setAtomSetFrequency(null, null, Double.valueOf((String)arrayList.get(i)).toString(), null);
            int n3 = this.atomSetCollection.getLastAtomSetAtomIndex();
            for (int j = 0; j < this.modelAtomCount; ++j) {
                String[] stringArray = MoldenReader.getTokens(this.readLine());
                this.atomSetCollection.addVibrationVector(j + n3, this.parseFloat(stringArray[0]) * 0.5291772f, this.parseFloat(stringArray[1]) * 0.5291772f, this.parseFloat(stringArray[2]) * 0.5291772f);
            }
        }
        return true;
    }

    private boolean readGeometryOptimization() throws Exception {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        this.readLine();
        while (this.readLine() != null && this.line.indexOf("force") < 0) {
            arrayList.add(Double.valueOf(this.line.trim()).toString());
        }
        this.discardLinesUntilContains("[GEOMETRIES] XYZ");
        int n2 = arrayList.size();
        this.modelNumber = n = this.optOnly || this.desiredModelNumber >= 0 ? 0 : 1;
        boolean bl = false;
        if (this.desiredModelNumber == 0 || this.desiredModelNumber == n2) {
            this.desiredModelNumber = n2;
        } else {
            this.setMOData(null);
        }
        for (int i = 0; i < n2; ++i) {
            this.discardLines(2);
            if (this.doGetModel(++this.modelNumber)) {
                this.readAtomSet("Step " + (this.modelNumber - n) + "/" + n2 + ": " + arrayList.get(i), false, !this.optOnly || bl);
                bl = true;
                continue;
            }
            this.discardLines(this.modelAtomCount);
        }
        return true;
    }

    private void readAtomSet(String string, boolean bl, boolean bl2) throws Exception {
        if (bl2 && this.desiredModelNumber < 0) {
            this.atomSetCollection.cloneFirstAtomSet();
        }
        this.atomSetCollection.setAtomSetName(string);
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        int n = this.atomSetCollection.getLastAtomSetAtomIndex();
        float f = bl ? 0.5291772f : 1.0f;
        for (int i = 0; i < this.modelAtomCount; ++i) {
            String[] stringArray = MoldenReader.getTokens(this.readLine());
            Atom atom = atomArray[i + n];
            this.setAtomCoord(atom, this.parseFloat(stringArray[1]) * f, this.parseFloat(stringArray[2]) * f, this.parseFloat(stringArray[3]) * f);
        }
    }
}

